/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.options.Argument;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Ports
implements ComposableOption<Ports> {
    private final Map<String, Port> ports;

    private Ports(Map<String, Port> ports) {
        this.ports = ports;
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.ports.values());
    }

    public SystemProperties asMappedProperties(SystemProperties properties) {
        SystemProperties copy = new SystemProperties(properties);
        HashMap<String, Object> mappedProperties = new HashMap<String, Object>();
        Iterator<SystemProperty> iterator = properties.iterator();
        while (iterator.hasNext()) {
            SystemProperty property = iterator.next();
            String name = property.getName();
            if (!this.ports.containsKey(name)) continue;
            Port port = this.ports.get(name);
            mappedProperties.put(name, port.getMappedPort());
        }
        return copy.addAll(mappedProperties);
    }

    public synchronized Ports compose(Ports other) {
        HashMap<String, Port> set = new HashMap<String, Port>(this.ports);
        set.putAll(other.ports);
        return new Ports(set);
    }

    public static Ports of(Port ... ports) {
        return Ports.of(Arrays.asList(ports));
    }

    public static Ports of(Collection<Port> ports) {
        HashMap<String, Port> map = new HashMap<String, Port>();
        ports.forEach(port -> map.put(port.getName(), (Port)port));
        return new Ports(map);
    }

    public boolean hasPort(String name) {
        return this.ports.containsKey(name);
    }

    @OptionsByType.Default
    public static Ports empty() {
        return new Ports(Collections.emptyMap());
    }

    public static Option capture() {
        return Decoration.of((Object)ResolveHandler.INSTANCE);
    }

    private static class ResolveHandler
    implements Argument.ResolveHandler,
    SystemProperty.ResolveHandler {
        private static ResolveHandler INSTANCE = new ResolveHandler();

        private ResolveHandler() {
        }

        @Override
        public void onResolve(String name, String value, OptionsByType optionsByType) {
            try {
                optionsByType.add((Option)Ports.of(new Port(name, Integer.parseInt(value))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public void onResolve(String name, List<String> values, OptionsByType optionsByType) {
            for (String value : values) {
                try {
                    optionsByType.add((Option)Ports.of(new Port(name, Integer.parseInt(value))));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public static class Port {
        private final String name;
        private final int actualPort;
        private final int mappedPort;

        public Port(String name, int actualPort) {
            this(name, actualPort, actualPort);
        }

        public Port(String name, int actualPort, int mappedPort) {
            this.name = name;
            this.actualPort = actualPort;
            this.mappedPort = mappedPort;
        }

        public String getName() {
            return this.name;
        }

        public int getActualPort() {
            return this.actualPort;
        }

        public int getMappedPort() {
            return this.mappedPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Port port = (Port)o;
            if (this.actualPort != port.actualPort) {
                return false;
            }
            if (this.mappedPort != port.mappedPort) {
                return false;
            }
            return this.name != null ? this.name.equals(port.name) : port.name == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.actualPort;
            result = 31 * result + this.mappedPort;
            return result;
        }

        public String toString() {
            return "Port(name='" + this.name + "' " + this.actualPort + "=" + this.mappedPort + ')';
        }
    }
}

