/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.deferred.Concurrent;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredFunction;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.DeferredRemoteExecution;
import com.oracle.bedrock.deferred.Repetitively;
import com.oracle.bedrock.deferred.options.FailFast;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.java.JavaApplication;
import java.util.function.Function;
import org.hamcrest.Matcher;

public class Concurrently {
    public static <T> Concurrent.Assertion assertThat(T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        return Concurrently.assertThat(null, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T> Concurrent.Assertion assertThat(String message, T value, Matcher<? super T> matcher) throws AssertionError {
        return Concurrently.assertThat(message, DeferredHelper.eventually(value), matcher, new Option[0]);
    }

    public static <T> Concurrent.Assertion assertThat(String message, T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        return Concurrently.assertThat(message, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T> Concurrent.Assertion assertThat(String message, Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) {
        ConcurrentAssertion<T> assertion = new ConcurrentAssertion<T>(message, deferred, matcher, options);
        assertion.setDaemon(true);
        assertion.setName("ConcurrentAssertion");
        assertion.start();
        return assertion;
    }

    public static <T, R> Concurrent.Assertion assertThat(T value, Function<T, R> function, Matcher<? super R> matcher, Option ... options) {
        return Concurrently.assertThat(DeferredHelper.eventually(value), function, matcher, options);
    }

    public static <T, R> Concurrent.Assertion assertThat(Deferred<T> deferred, Function<T, R> function, Matcher<? super R> matcher, Option ... options) {
        return Concurrently.assertThat(null, new DeferredFunction(deferred, function), matcher, options);
    }

    public static <T> Concurrent.Assertion assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher) {
        return Concurrently.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, new Option[0]);
    }

    public static <T> Concurrent.Assertion assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher, Option ... options) {
        return Concurrently.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, options);
    }

    static class ConcurrentAssertion<T>
    extends Thread
    implements Concurrent.Assertion {
        private final String message;
        private final Deferred<T> deferred;
        private final Matcher<? super T> matcher;
        private final OptionsByType optionsByType;
        private final Thread creatingThread;
        private volatile AssertionError assertionError;
        private volatile boolean closing;
        private volatile boolean closed;
        private volatile boolean throwAssertionErrorWhenClosing;

        public ConcurrentAssertion(String message, Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) {
            this.message = message;
            this.deferred = deferred;
            this.matcher = matcher;
            this.optionsByType = OptionsByType.of((Option[])options);
            this.creatingThread = Thread.currentThread();
            this.assertionError = null;
            this.closing = false;
            this.closed = false;
            this.throwAssertionErrorWhenClosing = true;
        }

        @Override
        public void check() throws AssertionError {
            AssertionError assertionError = this.assertionError;
            if (assertionError != null) {
                this.throwAssertionErrorWhenClosing = false;
                throw assertionError;
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closing = true;
            this.interrupt();
            if (this.assertionError != null && this.throwAssertionErrorWhenClosing) {
                throw this.assertionError;
            }
        }

        @Override
        public void run() {
            try {
                while (!this.closing) {
                    Repetitively.assertThat(this.message, this.deferred, this.matcher, this.optionsByType.asArray());
                }
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).getCause() instanceof InterruptedException && this.closing) {
                } else {
                    this.assertionError = e;
                    if (((FailFast)this.optionsByType.get(FailFast.class, new Object[0])).isEnabled()) {
                        this.creatingThread.interrupt();
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }
    }
}

