/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Assembly;
import com.oracle.bedrock.runtime.AssemblyBuilder;
import com.oracle.bedrock.runtime.Infrastructure;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.util.Triple;
import java.util.ArrayList;
import org.junit.rules.ExternalResource;

public abstract class AbstractAssemblyResource<A extends Application, G extends Assembly<A>, R extends AbstractAssemblyResource<A, G, R>>
extends ExternalResource {
    protected ArrayList<Triple<Integer, Class<? extends A>, OptionsByType>> launchDefinitions = new ArrayList();
    protected AssemblyBuilder<A, G> assemblyBuilder;
    protected Infrastructure infrastructure = null;
    protected OptionsByType commonOptionsByType = OptionsByType.empty();
    protected OptionsByType creationOptionsByType = OptionsByType.empty();
    protected OptionsByType closingOptionsByType = OptionsByType.empty();
    protected G assembly = null;

    protected AbstractAssemblyResource() {
        this.assemblyBuilder = this.createBuilder();
    }

    protected abstract AssemblyBuilder<A, G> createBuilder();

    protected void before() throws Throwable {
        for (Triple<Integer, Class<? extends A>, OptionsByType> triple : this.launchDefinitions) {
            OptionsByType optionsByType = OptionsByType.of((OptionsByType)this.commonOptionsByType).addAll((OptionsByType)triple.getZ());
            this.assemblyBuilder.include(((Integer)triple.getX()).intValue(), (Class)triple.getY(), optionsByType.asArray());
        }
        this.assembly = this.assemblyBuilder.build(this.infrastructure == null ? Infrastructure.local() : this.infrastructure, this.creationOptionsByType.asArray());
        super.before();
    }

    protected void after() {
        this.assembly.close(this.closingOptionsByType.asArray());
        super.after();
    }

    public R include(int count, Class<? extends A> applicationClass, Option ... options) {
        this.launchDefinitions.add(new Triple((Object)count, applicationClass, (Object)OptionsByType.of((Option[])options)));
        return (R)((Object)this);
    }

    public R using(Infrastructure infrastructure) {
        this.infrastructure = infrastructure;
        return (R)((Object)this);
    }

    public R using(Platform ... platforms) {
        return this.using(Infrastructure.using((Platform[])platforms));
    }

    public R with(Option ... options) {
        this.commonOptionsByType.addAll(options);
        return (R)((Object)this);
    }

    public R withOverridingOptions(Option ... options) {
        this.creationOptionsByType.addAll(options);
        return (R)((Object)this);
    }

    public R withClosingOptions(Option ... options) {
        this.closingOptionsByType.addAll(options);
        return (R)((Object)this);
    }
}

