/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.junit.JUnitReporter;
import com.oracle.bedrock.junit.JUnitTestListener;
import java.io.File;
import java.io.PrintStream;

public class JUnitTextReporter
extends JUnitReporter {
    public static final String DASHES = "-------------------------------------------------------------------------------";

    public JUnitTextReporter() {
        super(null);
    }

    public JUnitTextReporter(File reportFolder) {
        super(reportFolder);
    }

    @Override
    public void writeReport(PrintStream out, JUnitReporter.TestResults test) {
        String className = test.getClassName();
        int failures = test.getFailureCount();
        int errors = test.getErrorCount();
        out.println(DASHES);
        out.println("Test set: " + className);
        out.println(DASHES);
        out.printf("Tests run: %d, Failures: %d, Errors: %d, Skipped: %d, Time elapsed: %.3f sec %s - in %s\n", test.getTestCount(), failures, errors, test.getSkipCount(), Float.valueOf(test.getTestTime()), errors > 0 || failures > 0 ? "<<< FAILURE!" : "", className);
        for (JUnitTestListener.Event event : test.getEvents()) {
            if (!event.isError() && !event.isFailure()) continue;
            float testTime = (float)event.getTime() / 1000.0f;
            StackTraceElement[] stackTrace = event.getStackTrace();
            out.printf("%s Time elapsed: %.3f sec  <<< FAILURE!\n", event.getName(), Float.valueOf(testTime));
            out.printf("%s : %s\n", event.getException(), event.getMessage());
            for (StackTraceElement element : stackTrace) {
                out.println("\t at " + element);
            }
        }
    }

    @Override
    public String getReportFileName(String className) {
        return className + ".txt";
    }

    public String getReportFileName(Class testClass) {
        return this.getReportFileName(testClass.getCanonicalName());
    }

    public static Option at(File folder) {
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalStateException("Report folder exists but is not a directory " + folder);
        }
        return new JUnitTextReporter(folder).asOption();
    }

    public static Option toConsole() {
        return new JUnitTextReporter().asOption();
    }
}

