/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.junit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public abstract class JUnitUtils {
    private static final Pattern BRACKETS = Pattern.compile("^.+\\(([^\\\\(\\\\)]+)\\)$");

    public static String findClassName(Description description) {
        String name;
        String displayName = description.getDisplayName();
        Matcher matcher = BRACKETS.matcher(displayName);
        String string = name = matcher.find() ? matcher.group(1) : displayName;
        if (name == null || "null".equals(name)) {
            Description childDescription = (Description)description.getChildren().get(0);
            if (childDescription != null) {
                String childName = childDescription.getDisplayName();
                matcher = BRACKETS.matcher(childName);
                String string2 = name = matcher.find() ? matcher.group(1) : childName;
            }
            if (name == null) {
                name = "Error instantiating test";
            }
        }
        return name;
    }

    public static String getIgnoredMessage(Description description) {
        String message = null;
        Ignore ignore = (Ignore)description.getAnnotation(Ignore.class);
        if (ignore != null) {
            message = ignore.value();
        }
        return message;
    }

    public static String getFailureMessage(Failure failure) {
        String header = failure.getTestHeader();
        if (header == null || "null".equals(header)) {
            header = "Failed to construct test";
        }
        return header;
    }
}

