/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.matchers;

import com.oracle.bedrock.matchers.Equivalence;
import com.oracle.bedrock.matchers.MapMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class EntrySetMatcher<K, V>
extends TypeSafeMatcher<Set<Map.Entry<K, V>>> {
    private Map<K, V> map;
    private Equivalence<V> valueEquivalence;

    private EntrySetMatcher(Set<Map.Entry<K, V>> entries, Equivalence<V> valueEquivalence) {
        this.map = this.mapOf(entries);
        this.valueEquivalence = valueEquivalence == null ? Equivalence.EQUALS : valueEquivalence;
    }

    private Map<K, V> mapOf(Set<Map.Entry<K, V>> entries) {
        if (entries == null) {
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public boolean matchesSafely(Set<Map.Entry<K, V>> entries) {
        Map<K, V> otherMap = this.mapOf(entries);
        MapMatcher matcher = (MapMatcher)MapMatcher.sameAs(this.map, this.valueEquivalence);
        return matcher.matchesSafely(otherMap);
    }

    public void describeMismatchSafely(Set<Map.Entry<K, V>> entries, Description mismatchDescription) {
        MapMatcher matcher = (MapMatcher)MapMatcher.sameAs(this.map, this.valueEquivalence);
        matcher.describeMismatchSafely(this.mapOf(entries), mismatchDescription);
    }

    public void describeTo(Description description) {
        MapMatcher matcher = (MapMatcher)MapMatcher.sameAs(this.map, this.valueEquivalence);
        matcher.describeTo(description);
    }

    @Factory
    public static <K, V> Matcher<Set<Map.Entry<K, V>>> sameAs(Set<Map.Entry<K, V>> entries, Equivalence<V> equivalence) {
        return new EntrySetMatcher<K, V>(entries, equivalence);
    }

    @Factory
    public static <K, V> Matcher<Map<? extends K, ? extends V>> sameAs(Set<Map.Entry<K, V>> entries) {
        return EntrySetMatcher.sameAs(entries, Equivalence.EQUALS);
    }
}

