/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.matchers;

import com.oracle.bedrock.matchers.Equivalence;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class MapMatcher<K, V>
extends TypeSafeMatcher<Map<? extends K, ? extends V>> {
    private Map<K, V> map;
    private Equivalence<V> valueEquivalence;

    private MapMatcher(Map<K, V> map, Equivalence<V> valueEquivalence) {
        this.map = map;
        this.valueEquivalence = valueEquivalence == null ? Equivalence.EQUALS : valueEquivalence;
    }

    public boolean matchesSafely(Map<? extends K, ? extends V> otherMap) {
        if (this.map == otherMap) {
            return true;
        }
        if (this.map.size() == otherMap.size()) {
            V value2;
            V value1;
            Object key;
            boolean same = true;
            Iterator<Object> i = this.map.keySet().iterator();
            while (same && i.hasNext()) {
                key = i.next();
                value1 = this.map.get(key);
                same = value1 == (value2 = otherMap.get(key)) || this.valueEquivalence.equals(value1, value2);
            }
            i = otherMap.keySet().iterator();
            while (same && i.hasNext()) {
                key = i.next();
                value1 = this.map.get(key);
                same = value1 == (value2 = otherMap.get(key)) || this.valueEquivalence.equals(value1, value2);
            }
            return same;
        }
        return false;
    }

    public void describeMismatchSafely(Map<? extends K, ? extends V> map, Description mismatchDescription) {
        if (this.map != null && map == null) {
            mismatchDescription.appendText("The provided map was null (but the matching map wasn't)");
        } else if (this.map == null && map != null) {
            mismatchDescription.appendText("The provided map was not null (but the matching map was)");
        } else {
            V thatValue;
            V thisValue;
            HashSet<K> missingKeys = new HashSet<K>();
            HashSet<K> additionalKeys = new HashSet<K>();
            HashSet<K> nonMatchingKeys = new HashSet<K>();
            for (Object k : this.map.keySet()) {
                if (map.containsKey(k)) {
                    thisValue = this.map.get(k);
                    if (!(thisValue != (thatValue = map.get(k)) || thisValue == null && thatValue != null || thisValue != null && thatValue == null) && thisValue.equals(thatValue)) continue;
                    nonMatchingKeys.add(k);
                    continue;
                }
                missingKeys.add(k);
            }
            for (Object k : map.keySet()) {
                if (this.map.containsKey(k)) {
                    thisValue = this.map.get(k);
                    if (!(thisValue != (thatValue = map.get(k)) || thisValue == null && thatValue != null || thisValue != null && thatValue == null) && thisValue.equals(thatValue)) continue;
                    nonMatchingKeys.add(k);
                    continue;
                }
                additionalKeys.add(k);
            }
            if (this.map.size() == map.size()) {
                mismatchDescription.appendText("Both maps are the same size, each containing " + map.size() + " entries");
            } else {
                mismatchDescription.appendText("Each map has a different size.  The matcher map contains " + this.map.size() + " entries.  The provided map contains " + map.size() + " entries.");
            }
            if (!missingKeys.isEmpty()) {
                mismatchDescription.appendText("The provided map is missing the keys ").appendValueList("[", ", ", "]", missingKeys);
            }
            if (!additionalKeys.isEmpty()) {
                mismatchDescription.appendText("The provided map additionally contains the keys ").appendValueList("[", ", ", "]", additionalKeys);
            }
            if (!nonMatchingKeys.isEmpty()) {
                mismatchDescription.appendText("The following entries in the provided map don't match the matching map ").appendValueList("[", ", ", "]", nonMatchingKeys);
            }
        }
    }

    public void describeTo(Description description) {
        description.appendText("map containing ").appendValueList("[", ", ", "]", this.map.entrySet());
    }

    @Factory
    public static <K, V> Matcher<Map<? extends K, ? extends V>> sameAs(Map<K, V> map) {
        return new MapMatcher<K, V>(map, Equivalence.EQUALS);
    }

    @Factory
    public static <K, V> Matcher<Map<? extends K, ? extends V>> sameAs(Map<K, V> map, Equivalence<V> valueEquivalence) {
        return new MapMatcher<K, V>(map, valueEquivalence);
    }
}

