/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.deferred;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;

public class FutureMatcher<T>
extends TypeSafeDiagnosingMatcher<CompletableFuture<? super T>> {
    private final Matcher<? super T> matcher;

    public FutureMatcher(Matcher<? super T> matcher) {
        this.matcher = matcher;
    }

    protected boolean matchesSafely(CompletableFuture<? super T> item, Description mismatchDescription) {
        try {
            T result = item.get();
            return this.matcher.matches(result);
        }
        catch (InterruptedException | ExecutionException e) {
            mismatchDescription.appendText(" but completed with exception ").appendValue((Object)e);
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a CompletableFuture with result ").appendDescriptionOf(this.matcher);
    }

    @Factory
    public static <T> Matcher<T> futureOf(Matcher<T> matcher) {
        return new Is(matcher);
    }

    @Factory
    public static <T> Matcher<T> futureOf(T value) {
        return FutureMatcher.futureOf(IsEqual.equalTo(value));
    }
}

