/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredFunction;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.options.InitialDelay;
import com.oracle.bedrock.deferred.options.MaximumRetryDelay;
import com.oracle.bedrock.deferred.options.RetryFrequency;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteChannel;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.testsupport.deferred.DeferredRemoteExecution;
import com.oracle.bedrock.util.Duration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class Repetitively {
    public static <T> void assertThat(T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Repetitively.assertThat(null, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T> void assertThat(String message, T value, Matcher<? super T> matcher) throws AssertionError {
        Repetitively.assertThat(message, DeferredHelper.eventually(value), matcher, new Option[0]);
    }

    public static <T> void assertThat(String message, T value, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Repetitively.assertThat(message, DeferredHelper.eventually(value), matcher, options);
    }

    public static <T> void assertThat(String message, Deferred<T> deferred, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        long initialDelayDurationMS = ((InitialDelay)optionsByType.getOrDefault(InitialDelay.class, (Option)InitialDelay.none())).to(TimeUnit.MILLISECONDS);
        long maximumRetryDurationMS = ((Timeout)optionsByType.getOrDefault(Timeout.class, (Option)Timeout.after((Duration)DeferredHelper.getDefaultEnsuredMaximumRetryDuration()))).to(TimeUnit.MILLISECONDS);
        long maximumPollingDurationMS = ((MaximumRetryDelay)optionsByType.getOrDefault(MaximumRetryDelay.class, (Option)MaximumRetryDelay.of((Duration)DeferredHelper.getDefaultEnsuredMaximumPollingDuration()))).to(TimeUnit.MILLISECONDS);
        Iterator retryDurations = ((RetryFrequency)optionsByType.getOrDefault(RetryFrequency.class, (Option)RetryFrequency.of((Iterable)DeferredHelper.getDefaultEnsuredRetryDurationsIterable()))).get().iterator();
        int matchCount = 0;
        int attemptCount = 0;
        long remainingRetryDurationMS = maximumRetryDurationMS;
        do {
            block18: {
                if (initialDelayDurationMS > 0L) {
                    try {
                        Thread.sleep(initialDelayDurationMS);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError("Interrupted while resolving " + deferred, e);
                    }
                    remainingRetryDurationMS -= initialDelayDurationMS;
                }
                long acquisitionDurationMS = 0L;
                try {
                    long started = System.currentTimeMillis();
                    optionsByType.add((Option)Timeout.after((long)Math.min(remainingRetryDurationMS, 0L), (TimeUnit)TimeUnit.MILLISECONDS));
                    Object object = DeferredHelper.ensure(deferred, (Option[])optionsByType.asArray());
                    long stopped = System.currentTimeMillis();
                    acquisitionDurationMS = stopped - started;
                    remainingRetryDurationMS -= acquisitionDurationMS < 0L ? 0L : acquisitionDurationMS;
                    ++attemptCount;
                    if (matcher.matches(object)) {
                        ++matchCount;
                        break block18;
                    }
                    StringDescription description = new StringDescription();
                    matcher.describeMismatch(object, (Description)description);
                    throw new AssertionError((Object)(description.toString() + " (attempted " + attemptCount + " time(s), succeeded " + matchCount + " time(s))"));
                }
                catch (PermanentlyUnavailableException e) {
                    throw new AssertionError("Failed to resolve value for " + deferred, e);
                }
                catch (UnsupportedOperationException e) {
                    throw new AssertionError("Failed to resolve value for " + deferred, e);
                }
                catch (TemporarilyUnavailableException e) {
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            if (maximumRetryDurationMS >= 0L && remainingRetryDurationMS <= 0L) continue;
            if (retryDurations.hasNext()) {
                try {
                    Duration duration = (Duration)retryDurations.next();
                    long durationMS = duration.to(TimeUnit.MILLISECONDS);
                    if (durationMS > maximumPollingDurationMS) {
                        durationMS = maximumPollingDurationMS;
                    }
                    if (remainingRetryDurationMS - durationMS < 0L) {
                        durationMS = remainingRetryDurationMS;
                    }
                    if (durationMS > 0L) {
                        TimeUnit.MILLISECONDS.sleep(durationMS);
                    }
                    remainingRetryDurationMS -= durationMS;
                }
                catch (InterruptedException e) {
                    throw new AssertionError("Interrupted while resolving " + deferred, e);
                }
            } else {
                throw new AssertionError((Object)"Exhausted retry time-out durations");
            }
        } while (maximumRetryDurationMS < 0L || remainingRetryDurationMS > 0L);
        if (matchCount == 0) {
            throw new AssertionError((Object)("Failed to resolve a value for " + deferred));
        }
    }

    public static <T, R> void assertThat(T value, Function<T, R> function, Matcher<? super R> matcher, Option ... options) throws AssertionError {
        Repetitively.assertThat(DeferredHelper.eventually(value), function, matcher, options);
    }

    public static <T, R> void assertThat(Deferred<T> deferred, Function<T, R> function, Matcher<? super R> matcher, Option ... options) throws AssertionError {
        Repetitively.assertThat(null, new DeferredFunction(deferred, function), matcher, options);
    }

    public static <T> void assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher) throws AssertionError {
        Repetitively.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, new Option[0]);
    }

    public static <T> void assertThat(JavaApplication application, RemoteCallable<T> callable, Matcher<? super T> matcher, Option ... options) throws AssertionError {
        Repetitively.assertThat(DeferredHelper.valueOf(new DeferredRemoteExecution<T>((RemoteChannel)application, callable)), matcher, options);
    }
}

