/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.testsupport.junit.JUnitReporter;
import com.oracle.bedrock.testsupport.junit.JUnitTestListener;
import java.io.File;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Queue;
import java.util.TreeSet;

public class JUnitXmlReporter
extends JUnitReporter {
    public JUnitXmlReporter() {
        super(null);
    }

    public JUnitXmlReporter(File reportFolder) {
        super(reportFolder);
    }

    @Override
    public void writeReport(PrintStream out, JUnitReporter.TestResults test) {
        Queue<JUnitTestListener.Event> results = test.getEvents();
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.printf("<testsuite name=\"%s\" time=\"%.3f\" tests=\"%d\" errors=\"%d\" skipped=\"%d\" failures=\"%d\">\n", test.getClassName(), Float.valueOf(test.getTestTime()), results.size(), test.getErrorCount(), test.getSkipCount(), test.getFailureCount());
        Properties properties = this.getTestProperties();
        if (properties != null) {
            out.println("  <properties>");
            for (String name : new TreeSet<String>(properties.stringPropertyNames())) {
                out.printf("    <property name=\"%s\" value=\"%s\"/>\n", name, properties.getProperty(name));
            }
            out.println("  </properties>");
        }
        for (JUnitTestListener.Event result : results) {
            float testTime = (float)result.getTime() / 1000.0f;
            out.printf("  <testcase name=\"%s\" classname=\"%s\" time=\"%.3f\"", result.getName(), result.getClassName(), Float.valueOf(testTime));
            if (result.isSkipped()) {
                String message = result.getMessage();
                if (message == null) {
                    out.println(">\n    <skipped/>");
                } else {
                    out.printf(">\n    <skipped message=\"%s\"/>\n", message);
                }
                out.println("  </testcase>");
                continue;
            }
            if (result.isFailure() || result.isError()) {
                String exception = result.getException();
                String message = result.getMessage();
                out.printf(">\n    <failure message=\"%s\" type=\"%s\"", message, exception);
                StackTraceElement[] stackTrace = result.getStackTrace();
                if (stackTrace != null) {
                    out.printf("><![CDATA[%s: %s\n", exception, message);
                    for (StackTraceElement element : stackTrace) {
                        out.println("\tat " + element.toString());
                    }
                    out.println("]]></failure>");
                } else {
                    out.println("/>");
                }
                out.println("  </testcase>");
                continue;
            }
            out.println("/>");
        }
        out.println("</testsuite>");
    }

    public String getReportFileName(Class testClass) {
        return this.getReportFileName(testClass.getCanonicalName());
    }

    @Override
    public String getReportFileName(String className) {
        return "TEST-" + className + ".xml";
    }

    public static Option at(File folder) {
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalStateException("Report folder exists but is not a directory " + folder);
        }
        return new JUnitXmlReporter(folder).asOption();
    }

    public static Option toConsole() {
        return new JUnitXmlReporter().asOption();
    }
}

