/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.options.Decoration;
import com.oracle.bedrock.testsupport.junit.JUnitTestListener;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleJUnitTestListener
implements JUnitTestListener {
    private AtomicInteger testCount = new AtomicInteger(0);
    private AtomicInteger skipCount = new AtomicInteger(0);
    private AtomicInteger failureCount = new AtomicInteger(0);
    private AtomicInteger errorCount = new AtomicInteger(0);
    private CountDownLatch completed = new CountDownLatch(1);
    private Properties testProperties;

    public Properties getTestProperties() {
        return this.testProperties;
    }

    public int getTestCount() {
        return this.testCount.get();
    }

    public int getSkipCount() {
        return this.skipCount.get();
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public boolean hasTestFailures() {
        return this.errorCount.get() > 0 || this.failureCount.get() > 0;
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completed.await(timeout, unit);
    }

    public Option asOption() {
        return Decoration.of((Object)this);
    }

    @Override
    public void junitStarted(JUnitTestListener.Event event) {
    }

    @Override
    public void junitCompleted(JUnitTestListener.Event event) {
        this.completed.countDown();
    }

    @Override
    public void testRunStarted(JUnitTestListener.Event event) {
        this.testProperties = event.getProperties();
    }

    @Override
    public void testRunFinished(JUnitTestListener.Event event) {
    }

    @Override
    public void testStarted(JUnitTestListener.Event event) {
        this.testCount.incrementAndGet();
    }

    @Override
    public void testClassStarted(JUnitTestListener.Event event) {
    }

    @Override
    public void testClassFinished(JUnitTestListener.Event event) {
    }

    @Override
    public void testSucceeded(JUnitTestListener.Event event) {
    }

    @Override
    public void testIgnored(JUnitTestListener.Event event) {
        this.skipCount.incrementAndGet();
    }

    @Override
    public void testFailed(JUnitTestListener.Event event) {
        this.failureCount.incrementAndGet();
    }

    @Override
    public void testError(JUnitTestListener.Event event) {
        this.errorCount.incrementAndGet();
    }

    @Override
    public void testAssumptionFailure(JUnitTestListener.Event event) {
        this.skipCount.incrementAndGet();
    }
}

