/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.junit;

import java.util.Properties;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SystemPropertyIsolation
extends ExternalResource {
    private Properties originalProperties;

    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    protected void before() throws Throwable {
        this.originalProperties = new Properties();
        for (String name : System.getProperties().stringPropertyNames()) {
            String value = System.getProperty(name);
            this.originalProperties.setProperty(name, value);
        }
        System.out.println("SystemPropertyIsolation: Captured " + this.originalProperties.size() + " Original System Properties");
        super.before();
    }

    protected void after() {
        super.after();
        System.out.println("SystemPropertyIsolation: Restoring Original System Properties...");
        int nrReplaced = 0;
        int nrRemoved = 0;
        for (String name : System.getProperties().stringPropertyNames()) {
            if (this.originalProperties.containsKey(name)) {
                String value = System.getProperty(name);
                String originalValue = this.originalProperties.getProperty(name);
                if (originalValue.equals(value)) continue;
                System.out.println("SystemPropertyIsolation: Restoring Property: " + name + " = \"" + originalValue + "\"");
                System.getProperties().setProperty(name, originalValue);
                ++nrReplaced;
                continue;
            }
            System.out.println("SystemPropertyIsolation: Removing Property: " + name + "");
            System.getProperties().remove(name);
            ++nrRemoved;
        }
        System.out.println("SystemPropertyIsolation: Restored Original System Properties (removed " + nrRemoved + ", replaced " + nrReplaced + ")");
    }
}

