/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.coherence.CoherenceNamedCache;
import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterMemberUIDs;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterName;
import com.oracle.bedrock.runtime.coherence.callables.GetClusterSize;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberId;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberRoleName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberSiteName;
import com.oracle.bedrock.runtime.coherence.callables.GetLocalMemberUID;
import com.oracle.bedrock.runtime.coherence.callables.GetServiceStatus;
import com.oracle.bedrock.runtime.coherence.callables.IsServiceRunning;
import com.oracle.bedrock.runtime.coherence.callables.IsServiceStorageEnabled;
import com.oracle.bedrock.runtime.java.AbstractJavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.features.JmxFeature;
import com.oracle.bedrock.util.Trilean;
import com.tangosol.net.NamedCache;
import com.tangosol.util.UID;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

public abstract class AbstractCoherenceClusterMember
extends AbstractJavaApplication<JavaApplicationProcess>
implements CoherenceClusterMember {
    public static final String MBEAN_NAME_CLUSTER = "Coherence:type=Cluster";

    public AbstractCoherenceClusterMember(Platform platform, JavaApplicationProcess process, OptionsByType optionsByType) {
        super(platform, process, optionsByType);
    }

    public MBeanInfo getClusterMBeanInfo() {
        JmxFeature jmxFeature = (JmxFeature)this.get(JmxFeature.class);
        if (jmxFeature == null) {
            throw new UnsupportedOperationException("The JmxFeature (Java Management Extensions) haven't been enabled for this application");
        }
        try {
            return jmxFeature.getMBeanInfo(new ObjectName(MBEAN_NAME_CLUSTER));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not retrieve the Coherence Cluster MBean", e);
        }
    }

    @Override
    public int getClusterSize() {
        return (Integer)this.invoke(new GetClusterSize(), new Option[0]);
    }

    @Override
    public int getLocalMemberId() {
        return (Integer)this.invoke(new GetLocalMemberId(), new Option[0]);
    }

    @Override
    public UID getLocalMemberUID() {
        return (UID)this.invoke(new GetLocalMemberUID(), new Option[0]);
    }

    @Override
    public Set<UID> getClusterMemberUIDs() {
        return (Set)this.invoke(new GetClusterMemberUIDs(), new Option[0]);
    }

    public MBeanInfo getServiceMBeanInfo(String serviceName, int nodeId) {
        JmxFeature jmxFeature = (JmxFeature)this.get(JmxFeature.class);
        if (jmxFeature == null) {
            throw new UnsupportedOperationException("The JmxFeature (Java Management Extensions) haven't been enabled for this application");
        }
        try {
            return jmxFeature.getMBeanInfo(new ObjectName(String.format("Coherence:type=Service,name=%s,nodeId=%d", serviceName, nodeId)));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(String.format("Could not retrieve the Coherence Service MBean [%s]", serviceName), e);
        }
    }

    @Override
    public String getRoleName() {
        return (String)this.invoke(new GetLocalMemberRoleName(), new Option[0]);
    }

    @Override
    public String getSiteName() {
        return (String)this.invoke(new GetLocalMemberSiteName(), new Option[0]);
    }

    @Override
    public String getClusterName() {
        return (String)this.invoke(new GetClusterName(), new Option[0]);
    }

    @Override
    public NamedCache getCache(String cacheName) {
        return new CoherenceNamedCache<Object, Object>(this, cacheName, Object.class, Object.class);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String cacheName, Class<K> keyClass, Class<V> valueClass) {
        return new CoherenceNamedCache<K, V>(this, cacheName, keyClass, valueClass);
    }

    @Override
    public boolean isServiceRunning(String serviceName) {
        return (Boolean)this.invoke(new IsServiceRunning(serviceName), new Option[0]);
    }

    @Override
    public Trilean isStorageEnabled(String serviceName) {
        return (Trilean)this.invoke(new IsServiceStorageEnabled(serviceName), new Option[0]);
    }

    @Override
    public ServiceStatus getServiceStatus(String serviceName) {
        return (ServiceStatus)((Object)this.invoke(new GetServiceStatus(serviceName), new Option[0]));
    }
}

