/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.coherence.CoherenceCacheServer;
import com.oracle.bedrock.runtime.coherence.ServiceStatus;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteCallableStaticMethod;
import com.oracle.bedrock.runtime.java.ContainerBasedJavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.container.ContainerClassLoader;
import com.oracle.bedrock.runtime.java.options.ClassName;
import com.oracle.bedrock.runtime.java.options.Headless;
import com.oracle.bedrock.runtime.java.options.IPv4Preferred;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.remote.RemotePlatform;
import com.oracle.bedrock.util.Trilean;
import com.tangosol.net.NamedCache;
import com.tangosol.util.UID;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface CoherenceClusterMember
extends JavaApplication {
    public int getClusterSize();

    public int getLocalMemberId();

    public UID getLocalMemberUID();

    public Set<UID> getClusterMemberUIDs();

    public String getRoleName();

    public String getSiteName();

    public String getClusterName();

    public NamedCache getCache(String var1);

    public <K, V> NamedCache<K, V> getCache(String var1, Class<K> var2, Class<V> var3);

    public boolean isServiceRunning(String var1);

    public Trilean isStorageEnabled(String var1);

    public ServiceStatus getServiceStatus(String var1);

    public static class MetaClass
    implements com.oracle.bedrock.runtime.MetaClass<CoherenceClusterMember>,
    ContainerBasedJavaApplicationLauncher.ApplicationController {
        public static final String DEFAULT_CACHE_SERVER_CLASSNAME = "com.tangosol.net.DefaultCacheServer";
        public static final String CACHE_FACTORY_CLASSNAME = "com.tangosol.net.CacheFactory";

        @OptionsByType.Default
        public MetaClass() {
        }

        public Class<? extends CoherenceClusterMember> getImplementationClass(Platform platform, OptionsByType optionsByType) {
            return CoherenceCacheServer.class;
        }

        public void onLaunching(Platform platform, OptionsByType optionsByType) {
            optionsByType.addIfAbsent((Option)ClassName.of((String)DEFAULT_CACHE_SERVER_CLASSNAME));
            optionsByType.addIfAbsent((Option)IPv4Preferred.yes());
            optionsByType.add((Option)Headless.enabled());
            SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of((String)"tangosol.coherence.localhost", (SystemProperty.ContextSensitiveValue)new SystemProperty.ContextSensitiveValue(){

                public Object resolve(String name, Platform platform, OptionsByType optionsByType) {
                    if (platform instanceof RemotePlatform) {
                        InetAddress inetAddress = platform.getAddress();
                        if (inetAddress == null) {
                            return null;
                        }
                        return inetAddress.getHostAddress();
                    }
                    return null;
                }
            }, (Option[])new Option[0]));
            systemProperties = systemProperties.addIfAbsent(SystemProperty.of((String)"tangosol.coherence.machine", (SystemProperty.ContextSensitiveValue)new SystemProperty.ContextSensitiveValue(){

                public Object resolve(String name, Platform platform, OptionsByType optionsByType) {
                    if (platform instanceof RemotePlatform) {
                        return platform.getName();
                    }
                    return null;
                }
            }, (Option[])new Option[0]));
            optionsByType.add((Option)systemProperties);
        }

        public void onLaunch(Platform platform, OptionsByType optionsByType) {
        }

        public void onLaunched(Platform platform, CoherenceClusterMember member, OptionsByType optionsByType) {
        }

        public CompletableFuture<Void> start(ContainerBasedJavaApplicationLauncher.ControllableApplication application) {
            RemoteCallableStaticMethod callable = new RemoteCallableStaticMethod(DEFAULT_CACHE_SERVER_CLASSNAME, "start", new Object[0]);
            return application.submit((RemoteCallable)callable, new Option[0]);
        }

        public CompletableFuture<Void> destroy(ContainerBasedJavaApplicationLauncher.ControllableApplication application) {
            RemoteCallableStaticMethod callable = new RemoteCallableStaticMethod(DEFAULT_CACHE_SERVER_CLASSNAME, "shutdown", new Object[0]);
            return application.submit((RemoteCallable)callable, new Option[0]);
        }

        public void configure(ContainerClassLoader containerClassLoader, PipedOutputStream pipedOutputStream, PipedInputStream pipedInputStream, OptionsByType optionsByType) {
            ClassName className = (ClassName)optionsByType.getOrSetDefault(ClassName.class, (Option)ClassName.of((String)DEFAULT_CACHE_SERVER_CLASSNAME));
            ContainerBasedJavaApplicationLauncher.configureRemoteChannel((ContainerClassLoader)containerClassLoader, (PipedOutputStream)pipedOutputStream, (PipedInputStream)pipedInputStream, (String)className.getName());
        }
    }
}

