/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.Assembly;
import com.oracle.bedrock.runtime.coherence.CoherenceCluster;
import com.oracle.bedrock.runtime.coherence.CoherenceClusterMember;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteCallableStaticMethod;
import com.oracle.bedrock.runtime.concurrent.callable.RemoteMethodInvocation;
import com.oracle.bedrock.util.ReflectionHelper;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

class CoherenceNamedCache<K, V>
implements NamedCache<K, V> {
    private CoherenceClusterMember member;
    private Optional<CoherenceCluster> cluster;
    private String cacheName;
    private Class<K> keyClass;
    private Class<V> valueClass;
    private RemoteCallable<NamedCache> producer;
    private RemoteMethodInvocation.Interceptor interceptor;

    public CoherenceNamedCache(CoherenceClusterMember member, String cacheName, Class<K> keyClass, Class<V> valueClass) {
        this(member, cacheName, keyClass, valueClass, (RemoteCallable<NamedCache>)new RemoteCallableStaticMethod("com.tangosol.net.CacheFactory", "getCache", new Object[]{cacheName}));
    }

    public CoherenceNamedCache(CoherenceClusterMember member, String cacheName, Class<K> keyClass, Class<V> valueClass, RemoteCallable<NamedCache> producer) {
        this.member = member;
        this.cacheName = cacheName;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.producer = producer;
        this.interceptor = new NamedCacheMethodInterceptor();
        Assembly assembly = (Assembly)member.get(Assembly.class);
        this.cluster = assembly instanceof CoherenceCluster ? Optional.of((CoherenceCluster)assembly) : Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T remotelyInvoke(String methodName, Object ... arguments) {
        Method method = ReflectionHelper.getCompatibleMethod(NamedCache.class, (String)methodName, (Object[])arguments);
        if (method == null) {
            throw new UnsupportedOperationException("Unable to locate method [" + methodName + "] with arguments [" + Arrays.toString(arguments) + "] on NamedCache interface");
        }
        this.interceptor.onBeforeRemoteInvocation(method, arguments);
        int retryCount = 0;
        while ((long)retryCount < (this.cluster.isPresent() ? this.cluster.get().count() : 1L)) {
            boolean chooseNewMember;
            boolean bl = chooseNewMember = !this.member.isOperational() || retryCount > 0;
            if (chooseNewMember) {
                if (!this.cluster.isPresent()) throw new IllegalStateException("The underlying Cluster Member [" + this.member.getName() + "] is no longer available to perform the request [" + methodName + "]");
                Optional optional = this.cluster.get().findAny();
                if (!optional.isPresent()) throw new IllegalStateException("The underlying Cluster no longer has available Cluster Members to perform the request [" + methodName + "]");
                this.member = (CoherenceClusterMember)optional.get();
            }
            try {
                CompletableFuture future = this.member.submit((RemoteCallable)new RemoteMethodInvocation(this.producer, methodName, arguments, this.interceptor), new Option[0]);
                return (T)this.interceptor.onAfterRemoteInvocation(method, arguments, future.get());
            }
            catch (IllegalStateException e) {
                ++retryCount;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute [" + methodName + "] with arguments " + Arrays.toString(arguments), this.interceptor.onRemoteInvocationException(method, arguments, e));
            }
        }
        throw new IllegalStateException("Failed to perform request [" + methodName + "] with arguments " + Arrays.toString(arguments) + " using [" + retryCount + "] Cluster Members");
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheService getCacheService() {
        throw new UnsupportedOperationException("The method NamedCache.getCacheService is not supported for remote execution");
    }

    public boolean isActive() {
        return (Boolean)this.remotelyInvoke("isActive", new Object[0]);
    }

    public void release() {
        this.remotelyInvoke("release", new Object[0]);
    }

    public void destroy() {
        this.remotelyInvoke("destroy", new Object[0]);
    }

    public V put(K key, V value, long expiry) {
        return (V)this.remotelyInvoke("put", key, value, expiry);
    }

    public Map<K, V> getAll(Collection<? extends K> keys) {
        return (Map)this.remotelyInvoke("getAll", keys);
    }

    public boolean lock(Object key, long duration) {
        return (Boolean)this.remotelyInvoke("lock", key, duration);
    }

    public boolean lock(Object key) {
        return (Boolean)this.remotelyInvoke("lock", key);
    }

    public boolean unlock(Object key) {
        return (Boolean)this.remotelyInvoke("unlock", key);
    }

    public <R> R invoke(K key, InvocableMap.EntryProcessor<K, V, R> processor) {
        return (R)this.remotelyInvoke("invoke", key, processor);
    }

    public <R> Map<K, R> invokeAll(Collection<? extends K> keys, InvocableMap.EntryProcessor<K, V, R> processor) {
        return (Map)this.remotelyInvoke("invokeAll", keys, processor);
    }

    public <R> Map<K, R> invokeAll(Filter filter, InvocableMap.EntryProcessor<K, V, R> processor) {
        return (Map)this.remotelyInvoke("invokeAll", filter, processor);
    }

    public <R> R aggregate(Collection<? extends K> keys, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return (R)this.remotelyInvoke("aggregate", keys, aggregator);
    }

    public <R> R aggregate(Filter filter, InvocableMap.EntryAggregator<? super K, ? super V, R> aggregator) {
        return (R)this.remotelyInvoke("aggregate", filter, aggregator);
    }

    public void addMapListener(MapListener listener) {
        throw new UnsupportedOperationException("The method NamedCache.addMapListener is not supported for remote execution");
    }

    public void removeMapListener(MapListener listener) {
        throw new UnsupportedOperationException("The method NamedCache.removeMapListener is not supported for remote execution");
    }

    public void addMapListener(MapListener listener, Object key, boolean lite) {
        throw new UnsupportedOperationException("The method NamedCache.addMapListener is not supported for remote execution");
    }

    public void removeMapListener(MapListener listener, Object key) {
        throw new UnsupportedOperationException("The method NamedCache.removeMapListener is not supported for remote execution");
    }

    public void addMapListener(MapListener listener, Filter filter, boolean lite) {
        throw new UnsupportedOperationException("The method NamedCache.addMapListener is not supported for remote execution");
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        throw new UnsupportedOperationException("The method NamedCache.removeMapListener is not supported for remote execution");
    }

    public Set<K> keySet(Filter filter) {
        return (Set)this.remotelyInvoke("keySet", filter);
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter) {
        return (Set)this.remotelyInvoke("entrySet", filter);
    }

    public Set<Map.Entry<K, V>> entrySet(Filter filter, Comparator comparator) {
        return (Set)this.remotelyInvoke("entrySet", filter, comparator);
    }

    public <T, E> void addIndex(ValueExtractor<? super T, ? extends E> valueExtractor, boolean ordered, Comparator<? super E> comparator) {
        this.remotelyInvoke("addIndex", valueExtractor, ordered, comparator);
    }

    public <T, E> void removeIndex(ValueExtractor<? super T, ? extends E> valueExtractor) {
        this.remotelyInvoke("removeIndex", valueExtractor);
    }

    public int size() {
        return (Integer)this.remotelyInvoke("size", new Object[0]);
    }

    public boolean isEmpty() {
        return (Boolean)this.remotelyInvoke("isEmpty", new Object[0]);
    }

    public boolean containsKey(Object key) {
        return (Boolean)this.remotelyInvoke("containsKey", key);
    }

    public boolean containsValue(Object value) {
        return (Boolean)this.remotelyInvoke("containsValue", value);
    }

    public V get(Object key) {
        return (V)this.remotelyInvoke("get", key);
    }

    public V put(K key, V value) {
        return (V)this.remotelyInvoke("put", key, value);
    }

    public V remove(Object key) {
        return (V)this.remotelyInvoke("remove", key);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.remotelyInvoke("putAll", map);
    }

    public void clear() {
        this.remotelyInvoke("clear", new Object[0]);
    }

    public void truncate() {
        this.remotelyInvoke("truncate", new Object[0]);
    }

    public Set<K> keySet() {
        return (Set)this.remotelyInvoke("keySet", new Object[0]);
    }

    public Collection<V> values() {
        return (Collection)this.remotelyInvoke("values", new Object[0]);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.remotelyInvoke("entrySet", new Object[0]);
    }

    public static class NamedCacheMethodInterceptor
    implements RemoteMethodInvocation.Interceptor {
        public void onBeforeRemoteInvocation(Method method, Object[] arguments) {
            String name = method.getName();
            if ((name.equals("getAll") || name.equals("invokeAll") || name.equals("aggregate")) && !(arguments[0] instanceof Serializable)) {
                arguments[0] = new ArrayList((Collection)arguments[0]);
            } else if (name.equals("putAll") && !(arguments[0] instanceof Serializable)) {
                arguments[0] = new HashMap((Map)arguments[0]);
            }
        }

        public Object onAfterRemoteInvocation(Method method, Object[] arguments, Object result) {
            return result;
        }

        public Exception onRemoteInvocationException(Method method, Object[] arguments, Exception exception) {
            return exception;
        }

        public void onBeforeInvocation(Object instance, Method method, Object[] arguments) {
        }

        public Object onAfterInvocation(Object instance, Method method, Object[] arguments, Object result) {
            String name = method.getName();
            if (name.equals("invokeAll") || name.equals("getAll")) {
                result = new HashMap(result);
            } else if (name.equals("keySet")) {
                result = new HashSet((Set)((Object)result));
            } else if (name.equals("entrySet")) {
                Set set = (Set)((Object)result);
                HashSet resultSet = new HashSet();
                for (Map.Entry entry : set) {
                    resultSet.add(new AbstractMap.SimpleEntry(entry.getKey(), entry.getValue()));
                }
                result = resultSet;
            } else if (name.equals("values")) {
                result = new ArrayList((Collection)((Object)result));
            }
            return result;
        }

        public Exception onInvocationException(Object instance, Method method, Object[] arguments, Exception exception) {
            return exception;
        }
    }
}

