/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.callables;

import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.scheme.AbstractCompositeScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.run.xml.XmlElement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GetAutoStartServiceNames
implements RemoteCallable<Set<String>> {
    public Set<String> call() throws Exception {
        ConfigurableCacheFactory configurableCacheFactory = CacheFactory.getConfigurableCacheFactory();
        if (configurableCacheFactory instanceof DefaultConfigurableCacheFactory) {
            DefaultConfigurableCacheFactory cacheFactory = (DefaultConfigurableCacheFactory)configurableCacheFactory;
            XmlElement xmlCacheConfig = cacheFactory.getConfig();
            Map serviceSchemes = DefaultConfigurableCacheFactory.collectServiceSchemes((XmlElement)xmlCacheConfig);
            HashSet<String> serviceNames = new HashSet<String>();
            for (String serviceName : serviceSchemes.keySet()) {
                XmlElement xmlServiceScheme = (XmlElement)serviceSchemes.get(serviceName);
                boolean isAutoStart = xmlServiceScheme.getSafeElement("autostart").getBoolean(false);
                if (!isAutoStart) continue;
                serviceNames.add(serviceName);
            }
            return serviceNames;
        }
        if (configurableCacheFactory instanceof ExtensibleConfigurableCacheFactory) {
            ExtensibleConfigurableCacheFactory cacheFactory = (ExtensibleConfigurableCacheFactory)configurableCacheFactory;
            CacheConfig cacheConfig = cacheFactory.getCacheConfig();
            if (cacheConfig == null) {
                throw new RuntimeException("Failed to determine the CacheConfig for the ExtensibleConfigurableCacheFactory");
            }
            LinkedHashSet<String> serviceNames = new LinkedHashSet<String>();
            for (ServiceScheme serviceScheme : cacheConfig.getServiceSchemeRegistry()) {
                if (!serviceScheme.isAutoStart()) continue;
                if (serviceScheme instanceof AbstractCompositeScheme) {
                    if (!this.isAutoStartable(serviceScheme = ((AbstractCompositeScheme)serviceScheme).getBackScheme())) continue;
                    serviceNames.add(serviceScheme.getServiceName());
                    continue;
                }
                serviceNames.add(serviceScheme.getServiceName());
            }
            return serviceNames;
        }
        throw new RuntimeException("The ConfigurableCacheFactory is neither a DefaultConfigurableCacheFactory or a ExtensibleConfigurableCacheFactory");
    }

    public boolean isAutoStartable(ServiceScheme scheme) {
        return scheme.getServiceBuilder().isRunningClusterNeeded();
    }
}

