/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;

public class Pof
implements Profile,
ComposableOption<Pof> {
    public static final String PROPERTY_CONFIG = "tangosol.pof.config";
    public static final String PROPERTY_ENABLED = "tangosol.pof.enabled";
    private String configUri;
    private Boolean enabled;

    private Pof(String configUri, Boolean enabled) {
        this.configUri = configUri;
        this.enabled = enabled;
    }

    public static Pof config(String configUri) {
        return new Pof(configUri, null);
    }

    public static Pof enabled(boolean enabled) {
        return new Pof(null, enabled);
    }

    public static Pof disabled() {
        return new Pof(null, false);
    }

    public static Pof enabled() {
        return new Pof(null, true);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null && this.configUri != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY_CONFIG, (String)this.configUri, (Option[])new Option[0]));
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY_ENABLED, (Object)true, (Option[])new Option[0]));
        }
        if (systemProperties != null && this.enabled != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY_ENABLED, (Object)this.enabled, (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public Pof compose(Pof other) {
        return new Pof(this.configUri == null ? other.configUri : this.configUri, this.enabled == null ? other.enabled : this.enabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pof)) {
            return false;
        }
        Pof logging = (Pof)o;
        if (this.configUri != null ? !this.configUri.equals(logging.configUri) : logging.configUri != null) {
            return false;
        }
        return this.enabled != null ? this.enabled.equals(logging.enabled) : logging.enabled == null;
    }

    public int hashCode() {
        int result = this.configUri != null ? this.configUri.hashCode() : 0;
        result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
        return result;
    }
}

