/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.coherence.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.SystemProperty;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import com.oracle.bedrock.util.Capture;
import com.oracle.bedrock.util.PerpetualIterator;
import java.util.Iterator;

public class WellKnownAddress
implements Profile,
Option {
    public static final String PROPERTY = "tangosol.coherence.wka";
    public static final String PROPERTY_PORT = "tangosol.coherence.wka.port";
    private String address;
    private Iterator<Integer> ports;

    private WellKnownAddress(String address, Iterator<Integer> ports) {
        this.address = address;
        this.ports = ports;
    }

    public String getAddress() {
        return this.address;
    }

    public Iterator<Integer> getPorts() {
        return this.ports;
    }

    public static WellKnownAddress of(String address, int port) {
        return new WellKnownAddress(address, (Iterator<Integer>)new PerpetualIterator((Object)port));
    }

    public static WellKnownAddress of(String address, Capture<Integer> port) {
        return new WellKnownAddress(address, (Iterator<Integer>)port);
    }

    public static WellKnownAddress of(String address, Iterator<Integer> ports) {
        return new WellKnownAddress(address, ports);
    }

    public static WellKnownAddress of(String address, AvailablePortIterator ports) {
        return new WellKnownAddress(address, (Iterator<Integer>)ports);
    }

    public void onLaunching(Platform platform, MetaClass metaClass, OptionsByType optionsByType) {
        if (!this.ports.hasNext()) {
            throw new IllegalStateException("Exhausted the available ports for the WellKnownAddress");
        }
        SystemProperties systemProperties = (SystemProperties)optionsByType.get(SystemProperties.class, new Object[0]);
        if (systemProperties != null) {
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY, (String)this.address, (Option[])new Option[0]));
            optionsByType.add((Option)SystemProperty.of((String)PROPERTY_PORT, (Object)this.ports.next(), (Option[])new Option[0]));
        }
    }

    public void onLaunched(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public void onClosing(Platform platform, Application application, OptionsByType optionsByType) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WellKnownAddress)) {
            return false;
        }
        WellKnownAddress that = (WellKnownAddress)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return this.ports != null ? this.ports.equals(that.ports) : that.ports == null;
    }

    public int hashCode() {
        int result = this.address != null ? this.address.hashCode() : 0;
        result = 31 * result + (this.ports != null ? this.ports.hashCode() : 0);
        return result;
    }
}

