/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache;

public class ServerCacheMetrics {
    private long count;
    private long size;

    public ServerCacheMetrics() {
    }

    public ServerCacheMetrics(long count, long size) {
        this.count = count;
        this.size = size;
    }

    public String toString() {
        return "ServerCacheMetrics{count=" + this.count + ", size=" + this.size + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerCacheMetrics metrics = (ServerCacheMetrics)o;
        if (this.count != metrics.count) {
            return false;
        }
        return this.size == metrics.size;
    }

    public int hashCode() {
        int result = (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public void incrementCount(long countDelta) {
        this.count += countDelta;
    }

    public void incrementSize(long sizeDelta) {
        this.size += sizeDelta;
    }
}

