/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.basic;

import com.google.protobuf.ByteString;
import com.oracle.cloud.cache.ServerCacheMetrics;
import com.oracle.cloud.cache.basic.CacheRpc;

class CacheProtocol {
    private static final CacheRpc.EmptyResponse EMPTY = CacheRpc.EmptyResponse.newBuilder().build();

    CacheProtocol() {
    }

    static CacheRpc.GetRequest getRequest(String cacheName, String key) {
        return CacheRpc.GetRequest.newBuilder().setCache(cacheName).setKey(key).build();
    }

    static CacheRpc.GetResponse getResponse(byte[] value) {
        return CacheRpc.GetResponse.newBuilder().setValue(value == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])value)).build();
    }

    static CacheRpc.PutRequest putRequest(String cacheName, String key, byte[] value, long ttl, boolean returnOld) {
        return CacheRpc.PutRequest.newBuilder().setCache(cacheName).setKey(key).setValue(ByteString.copyFrom((byte[])value)).setTtl(ttl).setReturn(returnOld).build();
    }

    static CacheRpc.PutResponse putResponse(byte[] value) {
        CacheRpc.PutResponse.Builder builder = CacheRpc.PutResponse.newBuilder();
        if (value != null) {
            builder.setValue(ByteString.copyFrom((byte[])value));
        }
        return builder.build();
    }

    static CacheRpc.RemoveRequest removeRequest(String cacheName, String key, boolean returnOld) {
        return CacheRpc.RemoveRequest.newBuilder().setCache(cacheName).setKey(key).setReturn(returnOld).build();
    }

    static CacheRpc.RemoveResponse removeResponse(byte[] value) {
        CacheRpc.RemoveResponse.Builder builder = CacheRpc.RemoveResponse.newBuilder();
        if (value != null) {
            builder.setValue(ByteString.copyFrom((byte[])value));
        }
        return builder.build();
    }

    static CacheRpc.RemoveValueRequest removeValueRequest(String cacheName, String key, byte[] oldValue) {
        return CacheRpc.RemoveValueRequest.newBuilder().setCache(cacheName).setKey(key).setOldValue(ByteString.copyFrom((byte[])oldValue)).build();
    }

    static CacheRpc.RemoveValueResponse removeValueResponse(boolean success) {
        return CacheRpc.RemoveValueResponse.newBuilder().setSuccess(success).build();
    }

    static CacheRpc.ReplaceRequest replaceRequest(String cacheName, String key, byte[] value, long ttl, boolean returnOld) {
        return CacheRpc.ReplaceRequest.newBuilder().setCache(cacheName).setKey(key).setValue(ByteString.copyFrom((byte[])value)).setTtl(ttl).setReturn(returnOld).build();
    }

    static CacheRpc.ReplaceResponse replaceResponse(byte[] value) {
        CacheRpc.ReplaceResponse.Builder builder = CacheRpc.ReplaceResponse.newBuilder();
        if (value != null) {
            builder.setValue(ByteString.copyFrom((byte[])value));
        }
        return builder.build();
    }

    static CacheRpc.ReplaceValueRequest replaceValueRequest(String cacheName, String key, byte[] oldValue, byte[] newValue, long ttl) {
        return CacheRpc.ReplaceValueRequest.newBuilder().setCache(cacheName).setKey(key).setOldValue(ByteString.copyFrom((byte[])oldValue)).setNewValue(ByteString.copyFrom((byte[])newValue)).setTtl(ttl).build();
    }

    static CacheRpc.ReplaceValueResponse replaceValueResponse(boolean success) {
        return CacheRpc.ReplaceValueResponse.newBuilder().setSuccess(success).build();
    }

    static CacheRpc.ClearRequest clearRequest(String cacheName) {
        return CacheRpc.ClearRequest.newBuilder().setCache(cacheName).build();
    }

    static CacheRpc.MetricsRequest metricsRequest(String cacheName) {
        if (cacheName == null) {
            throw new IllegalArgumentException("Cache name cannot be null");
        }
        return CacheRpc.MetricsRequest.newBuilder().setCache(cacheName).build();
    }

    static CacheRpc.MetricsResponse metricsResponse(ServerCacheMetrics cacheMetrics) {
        long nCount = cacheMetrics == null ? 0L : cacheMetrics.getCount();
        long nSize = cacheMetrics == null ? 0L : cacheMetrics.getSize();
        return CacheRpc.MetricsResponse.newBuilder().setCount(nCount).setSize(nSize).build();
    }

    static CacheRpc.EmptyResponse emptyResponse() {
        return EMPTY;
    }
}

