/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cloud.cache.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;

public class MultiValue {
    private final List<byte[]> values;
    private final int size;

    public MultiValue(byte[] ... values) {
        this(Arrays.asList(values));
    }

    private MultiValue(List<byte[]> values) {
        this.values = values;
        this.size = values.stream().mapToInt(abValue -> ((byte[])abValue).length).sum() + 4 + values.size() * 4;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.size);
        this.writeTo(out);
        return out.toByteArray();
    }

    private void writeTo(OutputStream output) throws IOException {
        DataOutputStream out = new DataOutputStream(output);
        out.writeInt(this.values.size());
        for (byte[] abValue : this.values) {
            out.writeInt(abValue.length);
            out.write(abValue);
        }
    }

    public static MultiValue from(byte[] abValues) throws IOException {
        return MultiValue.from(new ByteArrayInputStream(abValues));
    }

    public static MultiValue from(InputStream input) throws IOException {
        DataInputStream in = new DataInputStream(input);
        int count = in.readInt();
        if (count > 1000) {
            throw new IOException("Invalid value of " + count + " for MultiValue");
        }
        ArrayList<byte[]> values = new ArrayList<byte[]>(count);
        for (int i = 0; i < count; ++i) {
            int nLength = in.readInt();
            byte[] abValue = new byte[nLength];
            in.readFully(abValue);
            values.add(abValue);
        }
        return new MultiValue(values);
    }

    public byte[] get(int index) {
        return this.values.get(index);
    }

    public static class Writer
    implements MessageBodyWriter<MultiValue> {
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return MultiValue.class.equals(type);
        }

        public long getSize(MultiValue multiValue, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return multiValue.size;
        }

        public void writeTo(MultiValue multiValue, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
            multiValue.writeTo(entityStream);
        }
    }

    public static class Reader
    implements MessageBodyReader<MultiValue> {
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return MultiValue.class.equals(type);
        }

        public MultiValue readFrom(Class<MultiValue> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
            return MultiValue.from(entityStream);
        }
    }
}

