/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import oracle.ons.InputBuffer;
import oracle.ons.Notification;
import oracle.ons.NotificationProperty;
import oracle.ons.ONS;
import oracle.ons.OutputBuffer;
import oracle.ons.PropertyElement;

public class PropertyList {
    PropertyElement head;
    int numelems;

    protected PropertyList() {
        this.head = null;
        this.numelems = 0;
    }

    protected PropertyList(int n, InputBuffer ibuf) throws IOException {
        this.numelems = 0;
        this.head = null;
        for (int i = 0; i < n; ++i) {
            String line = ibuf.getNextString();
            int colon = line.indexOf(58);
            String name = line.substring(0, colon);
            String value = line.substring(colon + 2);
            this.put(name, value);
        }
    }

    protected void put(String name, String value) {
        PropertyElement newelem = new PropertyElement(name, value);
        if (this.head == null) {
            this.head = newelem;
        } else {
            newelem.next = this.head;
            this.head = newelem;
        }
        ++this.numelems;
    }

    protected String get(String name) {
        String ret = null;
        PropertyElement cur = this.head;
        while (cur != null && ret == null) {
            if (cur.name.equals(name)) {
                ret = cur.value;
                continue;
            }
            cur = cur.next;
        }
        return ret;
    }

    protected void write(OutputBuffer obuf) throws IOException {
        PropertyElement cur = this.head;
        while (cur != null) {
            obuf.putString(cur.name);
            obuf.putBytes(Notification.headerseparator, 2);
            obuf.putString(cur.value);
            obuf.putBytes(Notification.crlf, 2);
            cur = cur.next;
        }
    }

    protected NotificationProperty[] getAll() {
        NotificationProperty[] ret = null;
        int i = 0;
        PropertyElement cur = this.head;
        if (this.numelems > 0) {
            ret = new NotificationProperty[this.numelems];
            while (cur != null) {
                ret[i] = new NotificationProperty(cur.name, cur.value);
                ++i;
                cur = cur.next;
            }
        }
        return ret;
    }

    protected int num() {
        return this.numelems;
    }

    protected void print() {
        PropertyElement cur = this.head;
        while (cur != null) {
            ONS.outstream.println("PROPERTY ==> " + cur.name + " = " + cur.value);
            cur = cur.next;
        }
    }
}

