/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class Util {
    static final Pattern onsMaskPattern = Pattern.compile("(walletfile=|walletpassword=).*(\n|$)");

    public static boolean sameOrEqual(Object o1, Object o2) {
        return o1 == o2 || null != o1 && o1.equals(o2);
    }

    public static boolean isAffinityStrict() {
        try {
            return "true".equals(((String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty("oracle.ucp.jdbc.oracle.affinity.strict", "false");
                }
            })).trim().toLowerCase());
        }
        catch (PrivilegedActionException e) {
            return false;
        }
    }

    public static String maskONSConfigurationString(String onsConfigStr) {
        return onsConfigStr == null || "".equals(onsConfigStr) ? "" : onsMaskPattern.matcher(onsConfigStr).replaceAll("*****");
    }

    public static boolean isSQLRecoverableException(Throwable t) {
        if (t instanceof SQLException) {
            int errCode = ((SQLException)t).getErrorCode();
            for (int ec : new int[]{28, 603, 1033, 1034, 1089, 1090, 1092, 3113, 3114, 17002, 17008, 17009, 17010, 17089, 17410}) {
                if (ec != errCode) continue;
                return true;
            }
        }
        return false;
    }
}

