/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.i18n.util.LocaleMapper;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLCharReader;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLExternalReader;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLUCS2Reader;
import oracle.xml.parser.v2.XMLUCS4Reader;
import oracle.xml.parser.v2.XMLUTF8Reader;
import oracle.xml.util.StringHashtable;
import oracle.xml.util.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class XMLReader
implements XMLLocator,
XMLConstants {
    char[] currentBuffer = null;
    int currentPos = 0;
    int markPos = -1;
    int markCount = 0;
    private boolean replaceIllegalChars = false;
    boolean externalReader = false;
    boolean externalDTD = false;
    boolean isStandalone = false;
    private int entityDepth = 16;
    private int entityExpansionCount = -1;
    private int entityExpansionCountLimit = 64000;
    XMLByteReader[] inputArray = new XMLByteReader[this.entityDepth];
    int[] inputPos = new int[this.entityDepth];
    int currentInput = -1;
    XMLByteReader input;
    String encoding = "UTF-8";
    boolean reader = false;
    String ebcdic_defaultcs = null;
    int valMode = 0;
    private XMLExternalReader extReader;
    XMLError err;
    DTD dtd;
    EntityResolver entResolver;
    LexicalHandler lexHandler;
    boolean checkDecl;
    String declSysId;
    String declPubId;
    int declCol;
    String xmlDeclVersion = null;
    String xmlDeclStandalone = null;
    String xmlDeclEncoding = null;
    boolean xmlDecl;
    boolean attrReader = false;
    final StringHashtable names = new StringHashtable(600);
    private boolean allowIllegalUTF8Encoding = false;
    static final byte[] isInitialNameChar = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final boolean T = true;
    private static final boolean F = false;
    static final boolean[] isNameChar = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    static final boolean[] isWhiteSpaceChar = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    static final byte[] charDataStopper = new byte[]{5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected XMLReader() {
        this.entResolver = null;
    }

    XMLReader(DTD dTD, XMLError xMLError, EntityResolver entityResolver, boolean bl) {
        this.dtd = dTD;
        this.err = xMLError;
        this.entResolver = entityResolver;
        if (bl) {
            this.valMode = 1;
        }
        xMLError.setLocator(this);
    }

    XMLReader(DTD dTD, XMLError xMLError, EntityResolver entityResolver, int n) {
        this.dtd = dTD;
        this.err = xMLError;
        this.entResolver = entityResolver;
        this.valMode = n;
        xMLError.setLocator(this);
    }

    void pushXMLReader(InputSource inputSource) throws SAXException, IOException {
        String string = inputSource.getSystemId();
        String string2 = inputSource.getPublicId();
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            this.pushXMLReader(reader, string, string2);
        } else {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                String string3 = inputSource.getEncoding();
                if (string3 == null) {
                    this.pushXMLReader(inputStream, string, string2);
                } else {
                    this.pushXMLReader(new InputStreamReader(inputStream, string3), string, string2);
                }
            } else {
                string = inputSource.getSystemId();
                if (string != null) {
                    try {
                        URL uRL = new URL(string);
                        inputStream = this.openURL(uRL);
                        this.pushXMLReader(inputStream, string, string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.err.setException(malformedURLException);
                        this.err.error0(220, 0);
                        this.err.flushErrors1();
                    }
                } else {
                    this.err.error0(220, 0);
                    this.err.flushErrors1();
                }
            }
        }
        this.input.setCloseInput(true);
    }

    void pushXMLReader(Reader reader, String string, String string2) throws SAXException, IOException {
        if (this.input != null) {
            this.input.setPosition(this.currentPos);
        }
        this.reader = true;
        this.input = new XMLCharReader(reader, string, string2);
        this.pushInputArray(this.input);
        this.currentBuffer = this.input.getBuffer();
        this.currentPos = this.input.getPosition();
        this.input.setError(this.err);
        if (this.currentInput == 0 && !this.externalDTD) {
            this.scanXMLDecl();
        } else {
            this.scanTextDecl();
        }
    }

    void pushXMLReader(URL uRL, String string, String string2) throws SAXException, IOException {
        this.reader = false;
        this.pushXMLReader(this.openURL(uRL), string, string2);
        this.input.setCloseInput(true);
    }

    void pushXMLReader(XMLByteReader xMLByteReader) throws SAXException, IOException {
        if (this.input != null) {
            this.input.setPosition(this.currentPos);
        }
        this.reader = false;
        this.pushInputArray(xMLByteReader);
        this.input = xMLByteReader;
        this.currentBuffer = this.input.getBuffer();
        this.currentPos = this.input.getPosition();
        this.input.setError(this.err);
    }

    void pushXMLReader(InputStream inputStream, String string, String string2) throws SAXException, IOException {
        int[] nArray = new int[]{-1, -1, -1, -1};
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        this.reader = false;
        if (this.input != null) {
            this.input.setPosition(this.currentPos);
        }
        try {
            for (n = 0; n < 4 && (nArray[n] = inputStream.read()) != -1; ++n) {
            }
            if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 60 || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 254 && nArray[3] == 255) {
                if (nArray[3] == 255) {
                    n2 = 4;
                }
                this.encoding = "UCS-4";
                this.input = new XMLUCS4Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(2);
            } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0 || nArray[0] == 255 && nArray[1] == 254 && nArray[2] == 0 && nArray[3] == 0) {
                if (nArray[0] == 255) {
                    n2 = 4;
                }
                this.encoding = "UCS-4";
                this.input = new XMLUCS4Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(1);
            } else if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 60 && nArray[3] == 0 || nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 255 && nArray[3] == 254) {
                this.encoding = "UCS-4";
                if (nArray[2] == 255) {
                    n2 = 4;
                }
                this.input = new XMLUCS4Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(3);
            } else if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 0 || nArray[0] == 254 && nArray[1] == 255 && nArray[2] == 0 && nArray[3] == 0) {
                this.encoding = "UCS-4";
                if (nArray[1] == 255) {
                    n2 = 4;
                }
                this.input = new XMLUCS4Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(4);
            } else if (nArray[0] == 0 && nArray[1] == 60 && nArray[2] == 0 && nArray[3] == 63) {
                this.encoding = "UCS-2";
                this.input = new XMLUCS2Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(2);
            } else if (nArray[0] == 60 && nArray[1] == 0 && nArray[2] == 63 && nArray[3] == 0) {
                this.encoding = "UCS-2";
                this.input = new XMLUCS2Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(1);
            } else if (nArray[0] == 254 && nArray[1] == 255) {
                this.encoding = "UTF-16";
                n2 = 2;
                this.input = new XMLUCS2Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                ((XMLUCS2Reader)this.input).setUTF16Mode(true);
                this.input.setByteOrder(2);
            } else if (nArray[0] == 255 && nArray[1] == 254) {
                this.encoding = "UTF-16";
                n2 = 2;
                this.input = new XMLUCS2Reader(inputStream, string, string2);
                this.pushInputArray(this.input);
                this.input.setByteOrder(1);
                ((XMLUCS2Reader)this.input).setUTF16Mode(true);
            } else if (nArray[0] == 239 && nArray[1] == 187 && nArray[2] == 191) {
                this.encoding = "UTF-8";
                n2 = 3;
                this.input = new XMLUTF8Reader(inputStream, string, string2);
                ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
                this.pushInputArray(this.input);
            } else if (nArray[0] == 76 && nArray[1] == 111 && nArray[2] == 167 && nArray[3] == 148) {
                String string3 = XMLUtil.getProperty("file.encoding", "Cp037");
                this.ebcdic_defaultcs = XMLUtil.getProperty("oracle.xml.parser.default.character.set", string3);
                this.reader = true;
                this.encoding = "EBCDIC";
                this.input = new XMLCharReader((Reader)null, string, string2);
                this.pushInputArray(this.input);
                ((XMLCharReader)this.input).fillXMLDecl(inputStream);
                char[] cArray = new char[]{'<', '?', 'x', 'm'};
                this.currentPos = this.input.pushChars(cArray, 0, 4);
            } else if (nArray[0] == 60 && nArray[1] == 63 && nArray[2] == 120 && nArray[3] == 109) {
                this.encoding = "UTF-8";
                this.checkDecl = true;
                this.declSysId = string;
                this.declPubId = string2;
                this.declCol = 0;
                if (this.currentInput == -1 && !this.externalDTD) {
                    this.checkXMLDecl(inputStream, string, string2);
                } else {
                    this.checkTextDecl(inputStream, string, string2);
                }
                this.checkDecl = false;
                bl = true;
            } else {
                this.encoding = "UTF-8";
                this.input = new XMLUTF8Reader(inputStream, string, string2);
                ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
                this.pushInputArray(this.input);
            }
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(241, 0, string);
            this.err.flushErrors1();
        }
        this.currentBuffer = this.input.getBuffer();
        this.currentPos = this.input.getPosition();
        this.input.setError(this.err);
        if (!bl) {
            if (!this.reader) {
                this.input.pushBytes(nArray, n2, n);
            }
            if (this.currentInput == 0 && !this.externalDTD) {
                this.scanXMLDecl();
            } else {
                this.scanTextDecl();
            }
        }
    }

    void popXMLReader() throws XMLParseException, SAXException, IOException {
        if (this.input.en != null) {
            this.input.en.inStack = false;
            this.lexHandler.endEntity(this.input.en.getNodeName());
            this.input.en = null;
        }
        this.input.close();
        if (this.currentInput == 0) {
            this.err.error1(210, 0, "EOF");
            this.err.flushErrors1();
        }
        this.input = this.inputArray[--this.currentInput];
        this.currentBuffer = this.input.getBuffer();
        this.currentPos = this.input.getPosition();
    }

    boolean isTopLevelReader() {
        return this.currentInput == 0;
    }

    public String getSystemId() {
        if (this.checkDecl) {
            return this.declSysId;
        }
        if (this.input == null) {
            return "";
        }
        return this.input.sysId;
    }

    public String getPublicId() {
        if (this.checkDecl) {
            return this.declPubId;
        }
        if (this.input == null) {
            return "";
        }
        return this.input.pubId;
    }

    public int getLineNumber() {
        if (this.externalReader) {
            return this.extReader.getLineNumber();
        }
        if (this.checkDecl) {
            return 1;
        }
        if (this.input == null) {
            return 0;
        }
        this.syncCurrentPos();
        return this.input.getLineNumber();
    }

    public int getColumnNumber() {
        if (this.externalReader) {
            return this.extReader.getColumnNumber();
        }
        if (this.checkDecl) {
            return this.declCol;
        }
        if (this.input == null) {
            return 0;
        }
        this.syncCurrentPos();
        return this.input.getColumnNumber();
    }

    public String getXMLVersion() {
        return this.xmlDeclVersion;
    }

    public String getEncoding() {
        if (this.xmlDeclEncoding == null) {
            return this.encoding;
        }
        return this.xmlDeclEncoding;
    }

    public String getDeclEncoding() {
        return this.xmlDeclEncoding;
    }

    public String getStandalone() {
        return this.xmlDeclStandalone;
    }

    void syncCurrentPos() {
        this.input.setPosition(this.currentPos);
    }

    void setSystemId(String string) {
        this.input.sysId = string;
    }

    void setPublicId(String string) {
        this.input.pubId = string;
    }

    boolean isStandalone() {
        return this.isStandalone;
    }

    XMLExternalReader getExternalReader() {
        if (this.extReader == null) {
            this.extReader = new XMLExternalReader(this);
        } else {
            this.extReader.synchronize();
        }
        this.externalReader = true;
        return this.extReader;
    }

    XMLReader getInternalReader() throws SAXException, IOException {
        return this;
    }

    void setMarkPosition(int n) {
        if (this.markCount == 0) {
            this.markPos = n;
        }
        ++this.markCount;
    }

    void resetMarkPosition() {
        if (this.markCount > 0) {
            --this.markCount;
        }
    }

    void setEncoding(String string) throws SAXException, IOException {
        if (this.reader && !this.encoding.equalsIgnoreCase("EBCDIC")) {
            return;
        }
        if (this.encoding.equalsIgnoreCase("UTF-16") || this.encoding.equalsIgnoreCase("UCS-2")) {
            if (string.equalsIgnoreCase("UCS-2") || string.equalsIgnoreCase("ISO-10646-UCS-2")) {
                ((XMLUCS2Reader)this.input).setUTF16Mode(false);
                return;
            }
            if (string.equalsIgnoreCase("UTF-16LE") && this.input.getByteOrder() == 1) {
                return;
            }
            if (string.equalsIgnoreCase("UTF-16BE") && this.input.getByteOrder() == 2) {
                return;
            }
            if (!(string.equalsIgnoreCase("ISO-10646-UCS-2") || string.equalsIgnoreCase("Unicode") || string.equalsIgnoreCase("UCS-2") || string.equalsIgnoreCase("UTF-16"))) {
                this.err.error2(230, 1, this.encoding, string);
                return;
            }
        } else if (this.encoding.equalsIgnoreCase("UCS-4")) {
            if (!string.equalsIgnoreCase("ISO-10646-UCS-4") && !string.equalsIgnoreCase("UCS-4")) {
                this.err.error2(230, 1, this.encoding, string);
                return;
            }
        } else if (this.encoding.equalsIgnoreCase("EBCDIC")) {
            String string2 = LocaleMapper.getJavaCharacterSet((int)2, (String)string.toUpperCase());
            if (string2 == null) {
                this.err.error1(231, 0, string);
                this.err.flushErrors();
                return;
            }
            ((XMLCharReader)this.input).setEncoding(string2);
        }
    }

    void setEncoding(InputStream inputStream, String string, String string2, String string3) throws SAXException, IOException {
        if (string3.toUpperCase().equals("ASCII")) {
            if (!this.encoding.toUpperCase().equals("UTF8") && !this.encoding.toUpperCase().equals("UTF-8")) {
                this.err.error2(230, 1, this.encoding, string3);
                return;
            }
            this.encoding = "ASCII";
            this.input = new XMLByteReader(inputStream, string, string2);
            this.pushInputArray(this.input);
        } else if (string3.toUpperCase().equals("UTF8") || string3.toUpperCase().equals("UTF-8")) {
            if (!this.encoding.toUpperCase().equals("UTF8") && !this.encoding.toUpperCase().equals("UTF-8")) {
                this.err.error2(230, 1, this.encoding, string3);
                return;
            }
            this.encoding = "UTF-8";
            this.input = new XMLUTF8Reader(inputStream, string, string2);
            ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
            this.pushInputArray(this.input);
        } else {
            boolean bl = false;
            BufferedReader bufferedReader = null;
            InputStreamReader inputStreamReader = null;
            String string4 = LocaleMapper.getJavaCharacterSet((int)2, (String)string3.toUpperCase());
            if (string4 != null) {
                try {
                    inputStreamReader = new InputStreamReader(inputStream, string4);
                    bufferedReader = new BufferedReader(inputStreamReader);
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (bl || string4 == null) {
                string4 = LocaleMapper.getJavaCharacterSet((int)1, (String)string3.toUpperCase());
                try {
                    inputStreamReader = new InputStreamReader(inputStream, string4);
                    bufferedReader = new BufferedReader(inputStreamReader);
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
            if (bl || string4 == null) {
                try {
                    inputStreamReader = new InputStreamReader(inputStream, string3);
                    bufferedReader = new BufferedReader(inputStreamReader);
                }
                catch (Exception exception) {
                    this.err.setException(exception);
                    this.err.error1(231, 0, string3);
                    this.err.flushErrors1();
                    return;
                }
            }
            this.encoding = string3;
            this.input = new XMLCharReader(bufferedReader, string, string2);
            this.pushInputArray(this.input);
        }
    }

    boolean isEOF() {
        return this.currentPos >= this.input.eofPos;
    }

    void close() throws SAXException, IOException {
        if (this.input != null) {
            this.input.close();
        }
        this.extReader = null;
    }

    int read() throws SAXException, IOException {
        try {
            return this.currentBuffer[this.currentPos++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.read();
            }
            return -1;
        }
    }

    int peek() throws SAXException, IOException {
        try {
            return this.currentBuffer[this.currentPos];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.peek();
            }
            return -1;
        }
    }

    boolean peek(char[] cArray, int n, int n2) throws SAXException, IOException {
        int n3 = this.currentPos;
        int n4 = n;
        try {
            for (int i = n2; i > 0; --i) {
                if (cArray[n4] != this.currentBuffer[n3]) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.peek(cArray, n, n2);
            }
            return false;
        }
    }

    void push(int n) {
        this.syncCurrentPos();
        this.currentPos = this.input.pushChar((char)n);
    }

    boolean tryRead(int n) throws SAXException, IOException {
        block3: {
            try {
                if (n == this.currentBuffer[this.currentPos]) {
                    ++this.currentPos;
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block3;
                return this.tryRead(n);
            }
        }
        return false;
    }

    boolean tryRead(char[] cArray, int n, int n2) throws SAXException, IOException {
        int n3 = this.currentPos;
        int n4 = n;
        try {
            for (int i = n2; i > 0; --i) {
                if (cArray[n4] != this.currentBuffer[n3]) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            this.currentPos = n3;
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.tryRead(cArray, n, n2);
            }
            return false;
        }
    }

    boolean setMarkupDepth(int n) throws SAXException, IOException {
        return this.tryRead(n);
    }

    boolean setMarkupDepth(char[] cArray, int n, int n2) throws SAXException, IOException {
        return this.tryRead(cArray, n, n2);
    }

    boolean checkMarkupDepth(int n) throws SAXException, IOException {
        return this.tryRead(n);
    }

    boolean checkMarkupDepth(char[] cArray, int n, int n2) throws SAXException, IOException {
        return this.tryRead(cArray, n, n2);
    }

    boolean isCMGroupStart() throws SAXException, IOException {
        return this.tryRead(40);
    }

    boolean isCMGroupEnd() throws SAXException, IOException {
        return this.tryRead(41);
    }

    int scanNameChars() throws SAXException, IOException {
        int n;
        int n2;
        block17: {
            n2 = this.currentPos;
            n = 0;
            try {
                char c = this.currentBuffer[n2];
                if (c < '\u007f') {
                    switch (isInitialNameChar[c & 0x7F]) {
                        case 0: {
                            if (this.attrReader) {
                                this.err.error2(201, 1, "name", "" + c);
                            } else {
                                this.err.error2(201, 0, "name", "" + c);
                                this.err.flushErrors1();
                            }
                            if (c != ':') break;
                            ++n2;
                            break;
                        }
                        case 1: {
                            ++n2;
                        }
                    }
                } else if (XMLUtil.isFirstNameChar(c)) {
                    ++n2;
                } else if (this.attrReader) {
                    this.err.error2(201, 1, "name", "" + c);
                } else {
                    this.err.error2(201, 0, "name", "" + c);
                    this.err.flushErrors1();
                }
                while (true) {
                    if (isNameChar[(c = this.currentBuffer[n2]) & 0x7F] && c < '\u007f') {
                        ++n2;
                        continue;
                    }
                    if (c >= '\u007f' && XMLUtil.isNameChar(c)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block17;
                return this.scanNameChars();
            }
        }
        n = n2 - this.currentPos;
        this.currentPos = n2;
        return n;
    }

    char[] scanComment(int[] nArray) throws SAXException, IOException {
        int n;
        block9: {
            int n2 = 0;
            n = this.currentPos;
            try {
                char c;
                do {
                    if ((c = this.currentBuffer[n]) >= '\u0000' && c <= '\u001f' && !isWhiteSpaceChar[c]) {
                        this.err.error1(171, 0, "" + c);
                    }
                    ++n;
                    if (n2 == 0) {
                        if (c != '-') continue;
                        n2 = 1;
                        continue;
                    }
                    if (n2 == 1) {
                        if (c == '-') {
                            n2 = 2;
                            continue;
                        }
                        n2 = 0;
                        continue;
                    }
                    if (n2 != 2) continue;
                    if (c == '>') break block9;
                    int n3 = this.currentPos;
                    this.currentPos = n;
                    this.err.error2(211, 0, "--", "comments");
                    this.currentPos = n3;
                    if (c == '-') continue;
                    n2 = 0;
                } while (c != '\uffff' || !this.isEOF(n));
                this.currentPos = n;
                this.err.error2(200, 0, "-->", "EOF");
                this.err.flushErrors1();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.fillBuffer()) {
                    return this.scanComment(nArray);
                }
                this.err.error2(200, 0, "-->", "EOF");
                this.err.flushErrors1();
            }
        }
        nArray[0] = this.currentPos;
        nArray[1] = n - this.currentPos - 3;
        this.currentPos = n;
        return this.currentBuffer;
    }

    String scanPI() throws SAXException, IOException {
        int n;
        int n2;
        block10: {
            boolean bl = false;
            n2 = this.currentPos;
            try {
                while (true) {
                    if ((n = this.currentBuffer[n2]) >= 0 && n <= 31 && !isWhiteSpaceChar[n]) {
                        this.err.error1(171, 0, "" + n);
                    }
                    ++n2;
                    if (!bl) {
                        if (n == 63) {
                            bl = true;
                        }
                    } else if (bl) {
                        if (n == 63) continue;
                        if (n == 62) break block10;
                        bl = false;
                    }
                    if (n == 65535 && this.isEOF(n2)) break;
                }
                this.currentPos = n2;
                this.err.error2(200, 0, "?>", "EOF");
                this.err.flushErrors1();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.fillBuffer()) {
                    return this.scanPI();
                }
                this.err.error2(200, 0, "?>", "EOF");
                this.err.flushErrors1();
            }
        }
        n = n2 - this.currentPos - 2;
        String string = new String(this.currentBuffer, this.currentPos, n);
        this.currentPos = n2;
        return string;
    }

    char[] scanCDATA(int[] nArray, boolean bl) throws SAXException, IOException {
        int n;
        boolean bl2;
        int n2;
        block16: {
            if (this.currentPos == this.currentBuffer.length) {
                this.fillBuffer();
            }
            n2 = 0;
            bl2 = false;
            n = this.currentPos;
            try {
                while (true) {
                    char c = this.currentBuffer[n];
                    ++n;
                    if (n2 == 0) {
                        if (c == ']') {
                            n2 = 1;
                        }
                    } else if (n2 == 1) {
                        n2 = c == ']' ? 2 : 0;
                    } else if (n2 == 2) {
                        if (c == ']') continue;
                        if (c == '>') {
                            bl2 = true;
                            break block16;
                        }
                        n2 = 0;
                    }
                    if (c == '\uffff' && this.isEOF(n)) break;
                }
                this.currentPos = n;
                this.err.error2(200, 0, "]]>", "EOF");
                this.err.flushErrors1();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!bl ? this.fillBuffer() : n - this.currentPos == n2 && this.fillBuffer()) {
                    return this.scanCDATA(nArray, bl);
                }
                if (!this.input.isEOF()) break block16;
                this.err.error2(200, 0, "]]>", "EOF");
                this.err.flushErrors1();
            }
        }
        nArray[0] = this.currentPos;
        nArray[1] = n - this.currentPos;
        this.currentPos = n;
        if (bl2) {
            nArray[1] = nArray[1] - cCDATAEND.length;
            if (bl && nArray[1] != 0) {
                this.currentPos -= cCDATAEND.length;
            }
        } else {
            nArray[1] = nArray[1] - n2;
            if (bl && nArray[1] != 0) {
                this.currentPos -= n2;
            }
        }
        return this.currentBuffer;
    }

    char[] scanChars(int[] nArray, boolean bl) throws SAXException, IOException {
        boolean[] blArray = new boolean[]{false};
        return this.scanChars(nArray, bl, blArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    char[] scanChars(int[] nArray, boolean bl, boolean[] blArray) throws SAXException, IOException {
        int n;
        boolean bl2;
        int n2;
        boolean bl3;
        block18: {
            if (this.currentPos == this.currentBuffer.length || this.currentBuffer[this.currentPos] == '&') {
                this.fillBuffer();
            }
            int n3 = 0;
            bl3 = false;
            n2 = this.currentPos;
            bl2 = false;
            n = n2;
            try {
                while (true) {
                    char c;
                    if ((c = this.currentBuffer[n2]) < '\u007f') {
                        int n4;
                        byte by = charDataStopper[c & 0x7F];
                        if (by == 0) {
                            n3 = 0;
                            ++n2;
                            if (!bl2 || isWhiteSpaceChar[c & 0x7F]) continue;
                            bl2 = false;
                            continue;
                        }
                        if (by == 1) break;
                        if (by == 2) {
                            n3 = 0;
                            bl2 = false;
                            n4 = this.tryCharRef(n2, true);
                            if (n4 != 0) {
                                bl3 = true;
                                if (n4 < 0) {
                                    bl2 = true;
                                    n = n2 -= n4;
                                    continue;
                                }
                                n2 += n4;
                                continue;
                            }
                            break;
                        } else {
                            if (by == 3) {
                                ++n3;
                                ++n2;
                                bl2 = false;
                                continue;
                            }
                            if (by == 4) {
                                bl2 = false;
                                if (n3 >= 2) {
                                    n4 = this.currentPos;
                                    this.currentPos = n2;
                                    this.err.error2(211, 0, "]]>", "text");
                                    this.currentPos = n4;
                                }
                                n3 = 0;
                            }
                            if (by == 5) {
                                n4 = this.currentPos;
                                this.currentPos = n2;
                                if (this.replaceIllegalChars) {
                                    this.currentBuffer[n2] = 63;
                                    this.err.error0(221, 1);
                                    this.currentPos = n4;
                                    continue;
                                }
                                n3 = 0;
                                bl2 = false;
                                this.err.error0(221, 0);
                                this.currentPos = n4;
                            }
                            ++n2;
                            continue;
                        }
                    }
                    n3 = 0;
                    if (!this.isEOF(n2)) {
                        ++n2;
                        bl2 = false;
                        continue;
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (bl || !this.fillBuffer()) break block18;
                return this.scanChars(nArray, bl, blArray);
            }
        }
        if (bl2) {
            n2 = n;
            blArray[0] = true;
        }
        nArray[0] = this.currentPos;
        nArray[1] = n2 - this.currentPos;
        if (bl3) {
            nArray[1] = nArray[1] - this.packBuffer(this.currentPos, n2);
        }
        this.currentPos = n2;
        return this.currentBuffer;
    }

    char[] scanWhiteSpace(int[] nArray) throws SAXException, IOException {
        int n;
        block3: {
            n = this.currentPos;
            try {
                while (isWhiteSpaceChar[this.currentBuffer[n] & 0x7F] && this.currentBuffer[n] < '\u007f') {
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block3;
                return this.scanWhiteSpace(nArray);
            }
        }
        nArray[0] = this.currentPos;
        nArray[1] = n - this.currentPos;
        this.currentPos = n;
        return this.currentBuffer;
    }

    String scanAttrString(int n) throws SAXException, IOException {
        int n2;
        int n3;
        boolean bl;
        int n4;
        block9: {
            n4 = this.currentPos;
            bl = false;
            try {
                while (true) {
                    if (isWhiteSpaceChar[(n3 = this.currentBuffer[n4]) & 0x7F] && n3 < 127) {
                        this.currentBuffer[n4] = 32;
                    } else {
                        if (n3 == 38) {
                            n2 = this.tryCharRef(n4);
                            if (n2 != 0) {
                                bl = true;
                                n4 += n2;
                                continue;
                            }
                            break;
                        }
                        if (n3 == 60 || n3 == n) break;
                    }
                    ++n4;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block9;
                return this.scanAttrString(n);
            }
        }
        n3 = n4 - this.currentPos;
        n2 = bl ? this.packBuffer(this.currentPos, n4) : 0;
        this.currentPos = n4;
        return new String(this.currentBuffer, this.currentPos - n3, n3 - n2);
    }

    String scanEntityString(int n) throws SAXException, IOException {
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        block12: {
            n5 = this.currentPos;
            n4 = this.currentPos;
            n3 = 0;
            n2 = 0;
            bl = false;
            this.setMarkPosition(this.currentPos);
            try {
                while (true) {
                    char c;
                    if ((c = this.currentBuffer[n5]) == '&') {
                        int n6 = this.tryCharRef(n5);
                        if (n6 != 0) {
                            bl = true;
                            n5 += n6;
                            continue;
                        }
                        c = this.currentBuffer[n5 + 1];
                        if (c != '%' && c != n) {
                            this.currentPos = ++n5;
                            int n7 = this.scanNameChars();
                            if (n7 != 0) {
                                if (this.currentBuffer[n5 += n7] == ':') {
                                    this.currentPos = ++n5;
                                    n5 += this.scanNameChars();
                                }
                                if (this.currentBuffer[n5] == ';') {
                                    ++n5;
                                    continue;
                                }
                            }
                        }
                        this.err.error2(211, 0, "&", "entity value");
                    } else if (c == '%' || c == n) break;
                    ++n5;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block12;
                this.resetMarkPosition();
                return this.scanEntityString(n);
            }
        }
        n3 = n5 - n4;
        if (bl) {
            n2 = this.packBuffer(n4, n5);
        }
        this.currentPos = n5;
        this.resetMarkPosition();
        return new String(this.currentBuffer, this.currentPos - n3, n3 - n2);
    }

    String scanQuotedString(char c) throws SAXException, IOException {
        int n;
        int n2;
        block4: {
            n2 = this.currentPos--;
            n = 0;
            if (c != '\"' && c != '\'') {
                this.err.error2(206, 0, "'", "\"");
                this.err.flushErrors1();
                return "";
            }
            try {
                while (this.currentBuffer[n2] != c) {
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block4;
                return this.scanQuotedString(c);
            }
        }
        n = n2 - this.currentPos;
        this.currentPos = n2 + 1;
        return new String(this.currentBuffer, this.currentPos - n - 1, n);
    }

    String scanPubIdLiteral(char c) throws SAXException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        block14: {
            n4 = this.currentPos;
            n3 = 0;
            n2 = 0;
            if (c != '\"' && c != '\'') {
                this.err.error2(206, 0, "'", "\"");
                this.err.flushErrors1();
                return "";
            }
            try {
                while (this.currentBuffer[n4] != c) {
                    switch (this.currentBuffer[n4]) {
                        case '\"': {
                            if (c == '\'') {
                                this.err.error1(282, 0, "\"");
                                this.err.flushErrors1();
                                return "";
                            }
                        }
                        case '\n': 
                        case '\r': {
                            this.currentBuffer[n4] = 32;
                            break;
                        }
                        case '\t': 
                        case '&': 
                        case '<': 
                        case '>': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            this.err.error1(282, 0, "" + this.currentBuffer[this.currentPos]);
                            this.err.flushErrors1();
                            return "";
                        }
                    }
                    ++n4;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block14;
                return this.scanPubIdLiteral(c);
            }
        }
        int n5 = this.currentPos;
        this.currentPos = n4 + 1;
        for (n = n5; n < n4 && this.currentBuffer[n] == ' '; ++n) {
        }
        n5 = n;
        for (n = n4 - 1; n >= n5 && this.currentBuffer[n] == ' '; --n) {
        }
        n4 = n;
        for (n = n5; n <= n4; ++n) {
            if (n2 != 0) {
                this.currentBuffer[n - n2] = this.currentBuffer[n];
            }
            if (this.currentBuffer[n] != ' ' || this.currentBuffer[n - 1] != ' ') continue;
            ++n2;
        }
        n3 = n4 - n5 - n2 + 1;
        return new String(this.currentBuffer, n5, n3);
    }

    String scanQuotedString() throws SAXException, IOException {
        char c = (char)this.read();
        return this.scanQuotedString(c);
    }

    String scanPubIdLiteral() throws SAXException, IOException {
        char c = (char)this.read();
        return this.scanPubIdLiteral(c);
    }

    String scanNmToken() throws SAXException, IOException {
        int n;
        int n2;
        block6: {
            n2 = this.currentPos;
            n = 0;
            try {
                while (XMLUtil.isNmtokenChar(this.currentBuffer[n2])) {
                    ++n2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block6;
                return this.scanNmToken();
            }
        }
        n = n2 - this.currentPos;
        this.currentPos = n2;
        if (n == 0) {
            if (this.attrReader) {
                this.err.error0(281, 1);
            } else {
                this.err.error0(281, 0);
            }
            this.err.flushErrors1();
        }
        return this.names.create(this.currentBuffer, this.currentPos - n, n);
    }

    String scanName() throws SAXException, IOException {
        int n = this.scanNameChars();
        return this.names.create(this.currentBuffer, this.currentPos - n, n);
    }

    String scanQName(String[] stringArray) throws SAXException, IOException {
        String string;
        block3: {
            string = "";
            try {
                this.setMarkPosition(this.currentPos);
                int n = this.scanNameChars();
                stringArray[0] = "";
                stringArray[1] = this.names.create(this.currentBuffer, this.currentPos - n, n);
                string = stringArray[1];
                if (this.currentBuffer[this.currentPos] == ':') {
                    ++this.currentPos;
                    stringArray[0] = string;
                    int n2 = this.scanNameChars();
                    stringArray[1] = this.names.create(this.currentBuffer, this.currentPos - n2, n2);
                    string = this.names.create(this.currentBuffer, this.markPos, n + n2 + 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block3;
                this.resetMarkPosition();
                return this.scanQName(stringArray);
            }
        }
        this.resetMarkPosition();
        return string;
    }

    String scanQName() throws SAXException, IOException {
        int n;
        String string;
        block4: {
            string = "";
            n = 0;
            try {
                this.setMarkPosition(this.currentPos);
                n = this.scanNameChars();
                if (this.currentBuffer[this.currentPos] == ':') {
                    ++this.currentPos;
                    n += this.scanNameChars() + 1;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block4;
                this.resetMarkPosition();
                return this.scanQName();
            }
        }
        if (n <= 0) {
            String string2 = "" + this.getLineNumber();
            String string3 = "" + this.getColumnNumber();
            this.err.error3(24033, 0, string, string2, string3);
        }
        string = this.names.create(this.currentBuffer, this.markPos, n);
        this.resetMarkPosition();
        return string;
    }

    protected int tryCharRef(int n) throws SAXException, IOException {
        int n2 = this.tryCharRef(n, false);
        if (n2 < 0) {
            return -n2;
        }
        return n2;
    }

    protected int tryCharRef(int n, boolean bl) throws SAXException, IOException {
        boolean bl2 = false;
        int n2 = n;
        int n3 = 0;
        if (this.currentBuffer[n + 1] == '#') {
            int n4;
            char c;
            block25: {
                if (this.currentBuffer[n += 2] == 'x') {
                    while (true) {
                        int n5 = ++n;
                        ++n;
                        c = this.currentBuffer[n5];
                        if (c >= '0' && c <= '9') {
                            n3 = n3 * 16 + c - 48;
                            continue;
                        }
                        if (c >= 'a' && c <= 'f') {
                            n3 = n3 * 16 + c - 97 + 10;
                            continue;
                        }
                        if (c < 'A' || c > 'F') break;
                        n3 = n3 * 16 + c - 65 + 10;
                    }
                    if (c != ';' && n3 == 0) {
                        bl2 = true;
                    }
                } else {
                    while ((c = this.currentBuffer[n++]) >= '0' && c <= '9') {
                        if ((n3 = n3 * 10 + c - 48) <= 65535) continue;
                        bl2 = true;
                        break block25;
                    }
                    if (c != ';' && n3 == 0) {
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                int n6 = this.currentPos;
                this.currentPos = n;
                this.err.error1(205, 0, "Char Ref");
                this.currentPos = n6;
                return n - n2;
            }
            if (c != ';') {
                n4 = this.currentPos;
                this.currentPos = n;
                this.err.error1(100, 0, ";");
                this.currentPos = n4;
            }
            if (!(n3 == -1 || n3 == 9 || n3 == 10 || n3 == 13 || n3 >= 32 && n3 <= 55295 || n3 >= 57344 && n3 <= 65533 || n3 >= 65536 && n3 <= 0x10FFFF)) {
                n4 = this.currentPos;
                this.currentPos = n;
                this.err.error1(280, 0, "" + Integer.toHexString((char)n3));
                this.currentPos = n4;
                return n - n2;
            }
            this.currentBuffer[n2 + 1] = 63;
            this.currentBuffer[n2 + 2] = (char)n3;
            this.currentBuffer[n2 + 3] = (char)(n - n2);
            if (n3 >= 65536) {
                this.currentBuffer[n2 + 1] = 42;
                this.currentBuffer[n2 + 2] = (char)(((n3 -= 65536) >> 10) + 55296);
                this.currentBuffer[n2 + 3] = (char)((n3 & 0x3FF) + 56320);
                this.currentBuffer[n2 + 4] = (char)(n - n2);
            }
        } else if (bl && this.currentBuffer[n + 1] != '?') {
            switch (this.currentBuffer[n + 1]) {
                case 'a': {
                    if (this.currentBuffer[n + 2] == 'm' && this.currentBuffer[n + 3] == 'p' && this.currentBuffer[n + 4] == ';') {
                        this.currentBuffer[n2 + 1] = 63;
                        this.currentBuffer[n2 + 2] = 38;
                        this.currentBuffer[n2 + 3] = 5;
                        return -5;
                    }
                    if (this.currentBuffer[n + 2] != 'p' || this.currentBuffer[n + 3] != 'o' || this.currentBuffer[n + 4] != 's' || this.currentBuffer[n + 5] != ';') break;
                    this.currentBuffer[n2 + 1] = 63;
                    this.currentBuffer[n2 + 2] = 39;
                    this.currentBuffer[n2 + 3] = 6;
                    n += 6;
                    return -6;
                }
                case 'g': {
                    if (this.currentBuffer[n + 2] != 't' || this.currentBuffer[n + 3] != ';') break;
                    this.currentBuffer[n2 + 1] = 63;
                    this.currentBuffer[n2 + 2] = 62;
                    this.currentBuffer[n2 + 3] = 4;
                    n += 4;
                    return -4;
                }
                case 'l': {
                    if (this.currentBuffer[n + 2] != 't' || this.currentBuffer[n + 3] != ';') break;
                    this.currentBuffer[n2 + 1] = 63;
                    this.currentBuffer[n2 + 2] = 60;
                    this.currentBuffer[n2 + 3] = 4;
                    n += 4;
                    return -4;
                }
                case 'n': {
                    if (this.currentBuffer[n + 2] != 'b' || this.currentBuffer[n + 3] != 's' || this.currentBuffer[n + 4] != 'p' || this.currentBuffer[n + 5] != ';') break;
                    this.currentBuffer[n2 + 1] = 63;
                    this.currentBuffer[n2 + 2] = 160;
                    this.currentBuffer[n2 + 3] = 6;
                    n += 6;
                    return -6;
                }
                case 'q': {
                    if (this.currentBuffer[n + 2] != 'u' || this.currentBuffer[n + 3] != 'o' || this.currentBuffer[n + 4] != 't' || this.currentBuffer[n + 5] != ';') break;
                    this.currentBuffer[n2 + 1] = 63;
                    this.currentBuffer[n2 + 2] = 34;
                    this.currentBuffer[n2 + 3] = 6;
                    n += 6;
                    return -6;
                }
            }
        } else if (this.currentBuffer[n + 1] == '?') {
            return this.currentBuffer[n + 3];
        }
        return n - n2;
    }

    void skipIgnoreSection() throws SAXException, IOException {
    }

    void skipUntil(int n) throws SAXException, IOException {
        int n2;
        block3: {
            this.currentBuffer[0] = this.currentBuffer[0];
            n2 = this.currentPos;
            try {
                while (this.currentBuffer[n2++] != n) {
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block3;
                this.skipUntil(n);
                return;
            }
        }
        this.currentPos = n2;
    }

    boolean skipWhiteSpace() throws SAXException, IOException {
        int n;
        boolean bl;
        block3: {
            bl = false;
            n = this.currentPos;
            try {
                while (isWhiteSpaceChar[this.currentBuffer[n] & 0x7F] && this.currentBuffer[n] < '\u007f') {
                    bl = true;
                    ++n;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block3;
                return this.skipWhiteSpace();
            }
        }
        this.currentPos = n;
        return bl;
    }

    void skipQName() throws SAXException, IOException {
        int n;
        block5: {
            n = this.currentPos;
            boolean bl = false;
            char c = '\uffff';
            try {
                while (true) {
                    if (XMLUtil.isNameChar(c = this.currentBuffer[n])) {
                        ++n;
                        continue;
                    }
                    if (c != 58) break;
                    ++n;
                    if (bl) break;
                    bl = true;
                }
                if (n == this.currentPos) {
                    this.err.error2(201, 0, "name", "" + c);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (!this.fillBuffer()) break block5;
                this.skipQName();
                return;
            }
        }
        this.currentPos = n;
    }

    void skipQuotedString() throws SAXException, IOException {
        char c = (char)this.read();
        if (c != '\"' && c != '\'') {
            this.err.error2(206, 0, "'", "\"");
            this.err.flushErrors1();
            return;
        }
        this.skipUntil(c);
    }

    void requireWhiteSpace() throws SAXException, IOException {
        if (!this.skipWhiteSpace()) {
            this.err.error0(190, 0);
        }
    }

    XMLEntity getEntity(boolean bl) throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity;
        String string = this.scanQName();
        if (!this.tryRead(59)) {
            this.err.error1(100, 0, ";");
        }
        if ((xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl)) == null) {
            int n = 0;
            if (bl || !this.isStandalone && this.dtd.getSystemId() != null) {
                n = this.valMode == 0 ? 2 : 1;
            }
            this.err.error1(250, n, string);
        }
        return xMLEntity;
    }

    boolean pushEntityRef(XMLEntity xMLEntity) throws SAXException, IOException {
        return this.pushEntityRef(xMLEntity, true, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean pushEntityRef(XMLEntity xMLEntity, boolean bl, boolean bl2) throws SAXException, IOException {
        block16: {
            block17: {
                block18: {
                    String string;
                    String string2;
                    InputStream inputStream;
                    InputSource inputSource;
                    block19: {
                        if (xMLEntity.inStack) {
                            this.err.error1(251, 0, xMLEntity.getNodeName());
                            return false;
                        }
                        if (this.isStandalone() && this.valMode == 2 && xMLEntity.isNodeFlag(128) && this instanceof XMLReader) {
                            this.err.error1(151, 0, xMLEntity.getNodeName());
                        }
                        if (bl2) {
                            this.lexHandler.startEntity(xMLEntity.getNodeName());
                        }
                        if (!xMLEntity.expanderef) {
                            this.lexHandler.endEntity(xMLEntity.getNodeName());
                            return false;
                        }
                        if (xMLEntity.getSystemId() == null) break block17;
                        inputSource = this.entResolver.resolveEntity(xMLEntity.getPublicId(), xMLEntity.getSystemId());
                        if (inputSource == null) break block18;
                        Reader reader = null;
                        inputStream = null;
                        string2 = null;
                        string = inputSource.getEncoding();
                        if (string != null) {
                            xMLEntity.setInputEncoding(string);
                        }
                        if ((reader = inputSource.getCharacterStream()) == null) break block19;
                        this.pushXMLReader(reader, inputSource.getSystemId(), inputSource.getPublicId());
                        break block16;
                    }
                    inputStream = inputSource.getByteStream();
                    if (inputStream != null) {
                        if (string == null) {
                            this.pushXMLReader(inputStream, inputSource.getSystemId(), inputSource.getPublicId());
                            break block16;
                        } else {
                            this.pushXMLReader(new InputStreamReader(inputStream, string), inputSource.getSystemId(), inputSource.getPublicId());
                        }
                        break block16;
                    } else {
                        string2 = inputSource.getSystemId();
                        if (string2 == null) {
                            this.err.error0(240, 0);
                            this.err.flushErrors1();
                            return false;
                        }
                        try {
                            this.pushXMLReader(new URL(string2), string2, inputSource.getPublicId());
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.err.setException(malformedURLException);
                            this.err.error1(242, 0, xMLEntity.getSystemId());
                            this.err.flushErrors1();
                            return false;
                        }
                    }
                }
                if (!bl) {
                    this.err.error1(241, 0, xMLEntity.getSystemId());
                    this.err.flushErrors1();
                    return false;
                }
                try {
                    this.pushXMLReader(new URL(xMLEntity.getSystemId()), xMLEntity.getSystemId(), xMLEntity.getPublicId());
                }
                catch (MalformedURLException malformedURLException) {
                    this.err.setException(malformedURLException);
                    this.err.error1(242, 0, xMLEntity.getSystemId());
                    this.err.flushErrors1();
                    return false;
                }
            }
            XMLCharReader xMLCharReader = xMLEntity.getReader(this);
            if (xMLCharReader == null) {
                return false;
            }
            this.syncCurrentPos();
            this.pushXMLReader(xMLCharReader);
        }
        xMLEntity.inStack = true;
        this.input.en = xMLEntity;
        xMLEntity.setXmlVersion(this.xmlDeclVersion);
        xMLEntity.setXmlEncoding(this.xmlDeclEncoding);
        return true;
    }

    boolean checkParEntity() throws SAXException, IOException {
        if (this.tryRead(37)) {
            this.requireWhiteSpace();
            return true;
        }
        return false;
    }

    protected boolean fillBuffer() throws SAXException, IOException {
        if (this.input.isEOF()) {
            return false;
        }
        if (this.markCount > 0) {
            int n = this.currentPos - this.markPos;
            this.markPos = this.input.saveBuffer(this.markPos);
            this.currentPos = this.markPos + n;
        } else {
            this.currentPos = this.input.saveBuffer(this.currentPos);
        }
        this.currentBuffer = this.input.getBuffer();
        return true;
    }

    private boolean isEOF(int n) {
        return n >= this.input.eofPos;
    }

    private int packBuffer(int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (this.currentBuffer[n4] == '&') {
                if (this.currentBuffer[n4 + 1] == '?') {
                    this.currentBuffer[n4 - n3] = this.currentBuffer[n4 + 2];
                    n3 += this.currentBuffer[n4 + 3] - '\u0001';
                    n4 += this.currentBuffer[n4 + 3];
                    continue;
                }
                if (this.currentBuffer[n4 + 1] == '*') {
                    this.currentBuffer[n4 - n3] = this.currentBuffer[n4 + 2];
                    this.currentBuffer[n4 - n3 + 1] = this.currentBuffer[n4 + 3];
                    n3 += this.currentBuffer[n4 + 4] - 2;
                    n4 += this.currentBuffer[n4 + 4];
                    continue;
                }
            }
            if (n3 != 0) {
                this.currentBuffer[n4 - n3] = this.currentBuffer[n4];
            }
            ++n4;
        }
        return n3;
    }

    InputStream openURL(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            if (uRL.getProtocol().toLowerCase().equals("file")) {
                String string = uRL.getFile();
                inputStream = new FileInputStream(string);
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (Exception exception) {
            inputStream = uRL.openStream();
        }
        return inputStream;
    }

    private void checkTextDecl(InputStream inputStream, String string, String string2) throws XMLParseException, SAXException, IOException {
        boolean bl = true;
        int n = 0;
        int[] nArray = new int[6];
        nArray[0] = 60;
        nArray[1] = 63;
        nArray[2] = 120;
        nArray[3] = 109;
        n = 4;
        this.declCol = 4;
        int n2 = nArray[n] = inputStream.read();
        ++this.declCol;
        if (nArray[n] == 108) {
            nArray[++n] = inputStream.read();
            ++this.declCol;
            if (!isWhiteSpaceChar[nArray[n] & 0x7F] && nArray[n] < 127) {
                this.encoding = "UTF-8";
                this.input = new XMLUTF8Reader(inputStream, string, string2);
                ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
                this.pushInputArray(this.input);
                this.input.pushBytes(nArray, 0, n + 1);
                this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
                return;
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        } else {
            this.encoding = "UTF-8";
            this.input = new XMLUTF8Reader(inputStream, string, string2);
            ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
            this.pushInputArray(this.input);
            this.input.pushBytes(nArray, 0, n + 1);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
            return;
        }
        this.xmlDecl = true;
        n = 0;
        while (n < cVERSION.length) {
            if (n2 == cVERSION[n]) {
                ++n;
                ++this.declCol;
                n2 = inputStream.read();
                continue;
            }
            if (n == 0) break;
            this.err.error2(200, 1, "version", new String(cVERSION, 0, n));
            break;
        }
        if (n == cVERSION.length) {
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            if (n2 != 61) {
                this.err.error1(100, 0, "=");
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            this.xmlDeclVersion = this.scanUntil(inputStream, n2);
            this.declCol += this.xmlDeclVersion.length() + 1;
            if (!this.xmlDeclVersion.equals("1.0")) {
                this.err.error1(100, 0, "version '1.0'");
            }
            n2 = inputStream.read();
            ++this.declCol;
            boolean bl2 = bl = isWhiteSpaceChar[n2 & 0x7F] && n2 < 127;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        }
        n = 0;
        while (n < cENCODING.length) {
            if (n2 == cENCODING[n]) {
                ++n;
                ++this.declCol;
                n2 = inputStream.read();
                continue;
            }
            if (n != 0) {
                this.err.error2(200, 1, "encoding", new String(cENCODING, 0, n));
                break;
            }
            this.err.error1(100, 0, "encoding");
            break;
        }
        if (n == cENCODING.length) {
            if (!bl) {
                this.err.error0(190, 0);
            }
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            if (n2 != 61) {
                this.err.error1(100, 0, "=");
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            this.xmlDeclEncoding = this.scanUntil(inputStream, n2);
            this.declCol += this.xmlDeclEncoding.length() + 1;
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        }
        if (n2 != 63) {
            this.err.error1(100, 0, "?>");
        } else {
            n2 = inputStream.read();
            ++this.declCol;
            if (n2 != 62) {
                this.err.error1(100, 0, "?>");
            }
        }
        if (this.xmlDeclEncoding != null) {
            this.setEncoding(inputStream, string, string2, this.xmlDeclEncoding);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
        } else {
            this.encoding = "UTF-8";
            this.input = new XMLUTF8Reader(inputStream, string, string2);
            ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
            this.pushInputArray(this.input);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
        }
    }

    private void checkXMLDecl(InputStream inputStream, String string, String string2) throws XMLParseException, SAXException, IOException {
        boolean bl = true;
        int n = 0;
        int[] nArray = new int[6];
        nArray[0] = 60;
        nArray[1] = 63;
        nArray[2] = 120;
        nArray[3] = 109;
        n = 4;
        this.declCol = 4;
        int n2 = nArray[n] = inputStream.read();
        ++this.declCol;
        if (nArray[n] == 108) {
            nArray[++n] = inputStream.read();
            ++this.declCol;
            if (!isWhiteSpaceChar[nArray[n] & 0x7F] && nArray[n] < 127) {
                this.encoding = "UTF-8";
                this.input = new XMLUTF8Reader(inputStream, string, string2);
                ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
                this.pushInputArray(this.input);
                this.input.pushBytes(nArray, 0, n + 1);
                this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
                return;
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        } else {
            this.encoding = "UTF-8";
            this.input = new XMLUTF8Reader(inputStream, string, string2);
            ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
            this.pushInputArray(this.input);
            this.input.pushBytes(nArray, 0, n + 1);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
            return;
        }
        this.xmlDecl = true;
        n = 0;
        while (n < cVERSION.length) {
            if (n2 == cVERSION[n]) {
                ++n;
                ++this.declCol;
                n2 = inputStream.read();
                continue;
            }
            if (n != 0) {
                this.err.error2(200, 1, "version", new String(cVERSION, 0, n));
                break;
            }
            this.err.error1(205, 0, "version");
            break;
        }
        if (n == cVERSION.length) {
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            if (n2 != 61) {
                this.err.error1(100, 0, "=");
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            this.xmlDeclVersion = this.scanUntil(inputStream, n2);
            this.declCol += this.xmlDeclVersion.length() + 1;
            if (!this.xmlDeclVersion.equals("1.0")) {
                this.err.error1(100, 0, "version '1.0'");
            }
            n2 = inputStream.read();
            ++this.declCol;
            boolean bl2 = bl = isWhiteSpaceChar[n2 & 0x7F] && n2 < 127;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        }
        n = 0;
        while (n < cENCODING.length) {
            if (n2 == cENCODING[n]) {
                ++n;
                ++this.declCol;
                n2 = inputStream.read();
                continue;
            }
            if (n == 0) break;
            this.err.error2(200, 1, "encoding", new String(cENCODING, 0, n));
            break;
        }
        if (n == cENCODING.length) {
            if (!bl) {
                this.err.error0(190, 0);
            }
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            if (n2 != 61) {
                this.err.error1(100, 0, "=");
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            this.xmlDeclEncoding = this.scanUntil(inputStream, n2);
            this.declCol += this.xmlDeclEncoding.length() + 1;
            n2 = inputStream.read();
            ++this.declCol;
            boolean bl3 = bl = isWhiteSpaceChar[n2 & 0x7F] && n2 < 127;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        }
        n = 0;
        while (n < cSTANDALONE.length) {
            if (n2 == cSTANDALONE[n]) {
                ++n;
                ++this.declCol;
                n2 = inputStream.read();
                continue;
            }
            if (n == 0) break;
            this.err.error2(200, 1, "standalone", new String(cSTANDALONE, 0, n));
            break;
        }
        if (n == cSTANDALONE.length) {
            if (!bl) {
                this.err.error0(190, 0);
            }
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            if (n2 != 61) {
                this.err.error1(100, 0, "=");
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
            this.xmlDeclStandalone = this.scanUntil(inputStream, n2);
            this.declCol += this.xmlDeclStandalone.length() + 1;
            if (!this.xmlDeclStandalone.equals("yes") && !this.xmlDeclStandalone.equals("no")) {
                this.err.error2(202, 0, "standalone", "'yes' or 'no'");
            }
            if (this.xmlDeclStandalone.equals("yes")) {
                this.isStandalone = true;
            }
            n2 = inputStream.read();
            ++this.declCol;
            while (isWhiteSpaceChar[n2 & 0x7F] && n2 < 127) {
                n2 = inputStream.read();
                ++this.declCol;
            }
        }
        if (n2 != 63) {
            this.err.error1(100, 0, "?>");
        } else {
            n2 = inputStream.read();
            ++this.declCol;
            if (n2 != 62) {
                this.err.error1(100, 0, "?>");
            }
        }
        if (this.xmlDeclEncoding != null) {
            this.setEncoding(inputStream, string, string2, this.xmlDeclEncoding);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
        } else {
            this.encoding = "UTF-8";
            this.input = new XMLUTF8Reader(inputStream, string, string2);
            ((XMLUTF8Reader)this.input).setAllowIllegalUTF8Encoding(this.allowIllegalUTF8Encoding);
            this.pushInputArray(this.input);
            this.input.lineNumbers[0] = this.input.lineNumbers[0] - this.declCol;
        }
    }

    private String scanUntil(InputStream inputStream, int n) throws XMLParseException, SAXException, IOException {
        int n2;
        int n3 = 0;
        int n4 = 20;
        char[] cArray = new char[n4];
        if (n != 34 && n != 39) {
            this.err.error2(206, 0, "'", "\"");
            this.err.flushErrors1();
            return "";
        }
        while ((n2 = inputStream.read()) != n) {
            if (n2 == -1) {
                this.err.error2(200, 0, "quote [" + (char)n + "]", "EOF");
                this.err.flushErrors1();
                return "";
            }
            try {
                cArray[n3] = (char)n2;
                ++n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                char[] cArray2 = new char[n4 *= 2];
                System.arraycopy(cArray, 0, cArray2, 0, n3);
                cArray = cArray2;
                cArray[n3] = (char)n2;
                ++n3;
            }
        }
        return new String(cArray, 0, n3);
    }

    private void scanXMLDecl() throws XMLParseException, SAXException, IOException {
        if (this.tryRead(cPISTART, 0, cPISTART.length)) {
            boolean bl = false;
            if (!this.tryRead(cXML, 0, cXML.length) || !this.skipWhiteSpace()) {
                this.input.setPosition(this.currentPos);
                this.currentPos = this.input.pushChars(cPISTART, 0, cPISTART.length);
                return;
            }
            this.xmlDecl = true;
            if (!this.tryRead(cVERSION, 0, cVERSION.length)) {
                this.err.error1(205, 0, "version");
            }
            this.skipWhiteSpace();
            if (!this.tryRead(61)) {
                this.err.error1(100, 0, "=");
            }
            this.skipWhiteSpace();
            this.xmlDeclVersion = this.scanQuotedString();
            if (!this.xmlDeclVersion.equals("1.0")) {
                this.err.error1(100, 0, "version '1.0'");
            }
            bl = this.skipWhiteSpace();
            if (this.tryRead(cENCODING, 0, cENCODING.length)) {
                if (!bl) {
                    this.err.error0(190, 0);
                }
                this.skipWhiteSpace();
                if (!this.tryRead(61)) {
                    this.err.error1(100, 0, "=");
                }
                this.skipWhiteSpace();
                this.xmlDeclEncoding = this.scanQuotedString();
                this.setEncoding(this.xmlDeclEncoding);
                bl = this.skipWhiteSpace();
            } else if (this.ebcdic_defaultcs != null) {
                this.setEncoding(this.ebcdic_defaultcs);
            }
            if (this.tryRead(cSTANDALONE, 0, cSTANDALONE.length)) {
                if (!bl) {
                    this.err.error0(190, 0);
                }
                this.skipWhiteSpace();
                if (!this.tryRead(61)) {
                    this.err.error1(100, 0, "=");
                }
                this.skipWhiteSpace();
                this.xmlDeclStandalone = this.scanQuotedString();
                if (!this.xmlDeclStandalone.equals("yes") && !this.xmlDeclStandalone.equals("no")) {
                    this.err.error2(202, 0, "standalone", "'yes' or 'no'");
                }
                if (this.xmlDeclStandalone.equals("yes")) {
                    this.isStandalone = true;
                }
            }
            this.skipWhiteSpace();
            if (!this.tryRead(cPIEND, 0, cPIEND.length)) {
                this.err.error1(100, 0, "?>");
            }
        }
    }

    private void scanTextDecl() throws XMLParseException, SAXException, IOException {
        if (this.tryRead(cPISTART, 0, cPISTART.length)) {
            if (!this.tryRead(cXML, 0, cXML.length)) {
                this.currentPos = this.input.pushChars(cPISTART, 0, cPISTART.length);
                return;
            }
            if (!this.skipWhiteSpace()) {
                this.currentPos = this.input.pushChars(cPISTART, 0, cPISTART.length);
                return;
            }
            this.xmlDecl = true;
            if (this.tryRead(cVERSION, 0, cVERSION.length)) {
                this.skipWhiteSpace();
                if (!this.tryRead(61)) {
                    this.err.error1(100, 0, "=");
                }
                this.skipWhiteSpace();
                this.xmlDeclVersion = this.scanQuotedString();
                this.requireWhiteSpace();
            }
            if (this.tryRead(cENCODING, 0, cENCODING.length)) {
                this.skipWhiteSpace();
                if (!this.tryRead(61)) {
                    this.err.error1(100, 0, "=");
                }
                this.skipWhiteSpace();
                this.xmlDeclEncoding = this.scanQuotedString();
                this.setEncoding(this.xmlDeclEncoding);
            } else {
                this.err.error1(100, 0, "encoding");
            }
            this.skipWhiteSpace();
            if (!this.tryRead(cPIEND, 0, cPIEND.length)) {
                this.err.error1(100, 0, "?>");
            }
        }
    }

    void dump(String string, int n) {
        if (n == -1) {
            n = this.currentPos;
        }
        System.err.println(string + " CP :" + n);
        for (int i = n; i < n + 10 && i < this.currentBuffer.length; ++i) {
            System.err.print(this.currentBuffer[i]);
        }
        System.err.println();
        System.err.println(string + " EOF :" + this.input.eofPos);
    }

    void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexHandler = lexicalHandler;
    }

    final void setReplaceIllegalChars(boolean bl) {
        this.replaceIllegalChars = bl;
    }

    final boolean isReplaceIllegalChars() {
        return this.replaceIllegalChars;
    }

    final void setAllowIllegalUTF8Encoding(boolean bl) {
        this.allowIllegalUTF8Encoding = bl;
    }

    final boolean isAllowIllegalUTF8Encoding() {
        return this.allowIllegalUTF8Encoding;
    }

    private void pushInputArray(XMLByteReader xMLByteReader) throws XMLParseException {
        if (this.currentInput + 1 >= this.entityDepth) {
            this.err.error1(25127, 0, "" + this.entityDepth);
            this.err.flushErrors();
        } else {
            this.inputArray[++this.currentInput] = xMLByteReader;
        }
        if (++this.entityExpansionCount > this.entityExpansionCountLimit) {
            this.err.error1(25128, 0, "" + this.entityExpansionCountLimit);
            this.err.flushErrors();
            throw new XMLParseException(this.err, 0);
        }
    }

    void setEntityDepth(int n) {
        this.entityDepth = n;
    }

    void setEntityExpansionCountLimit(int n) {
        this.entityExpansionCountLimit = n;
    }

    int getEntityExpansionCountLimit() {
        return this.entityExpansionCountLimit;
    }
}

