/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.adm.requests;

import com.oracle.bmc.adm.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/3.40.0/adm/ListVulnerabilityAuditsExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListVulnerabilityAuditsRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220421")
public class ListVulnerabilityAuditsRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /**
     * A filter to return only resources that match the specified identifier. Required only if the
     * compartmentId query parameter is not specified.
     */
    private String id;

    /**
     * A filter to return only resources that match the specified identifier. Required only if the
     * compartmentId query parameter is not specified.
     */
    public String getId() {
        return id;
    }
    /**
     * A filter to return only resources that belong to the specified compartment identifier.
     * Required only if the id query param is not specified.
     */
    private String compartmentId;

    /**
     * A filter to return only resources that belong to the specified compartment identifier.
     * Required only if the id query param is not specified.
     */
    public String getCompartmentId() {
        return compartmentId;
    }
    /**
     * A filter to return only Vulnerability Audits that were created against the specified
     * knowledge base.
     */
    private String knowledgeBaseId;

    /**
     * A filter to return only Vulnerability Audits that were created against the specified
     * knowledge base.
     */
    public String getKnowledgeBaseId() {
        return knowledgeBaseId;
    }
    /** A filter to return only successful or failed Vulnerability Audits. */
    private Boolean isSuccess;

    /** A filter to return only successful or failed Vulnerability Audits. */
    public Boolean getIsSuccess() {
        return isSuccess;
    }
    /** A filter to return only Vulnerability Audits that match the specified lifecycleState. */
    private com.oracle.bmc.adm.model.VulnerabilityAudit.LifecycleState lifecycleState;

    /** A filter to return only Vulnerability Audits that match the specified lifecycleState. */
    public com.oracle.bmc.adm.model.VulnerabilityAudit.LifecycleState getLifecycleState() {
        return lifecycleState;
    }
    /** The sort order to use, either 'ASC' or 'DESC'. */
    private com.oracle.bmc.adm.model.SortOrder sortOrder;

    /** The sort order to use, either 'ASC' or 'DESC'. */
    public com.oracle.bmc.adm.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    private String page;

    /**
     * A token representing the position at which to start retrieving results. This must come from
     * the {@code opc-next-page} header field of a previous response.
     */
    public String getPage() {
        return page;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }
    /**
     * The field used to sort Vulnerability Audits. Only one sort order is allowed. Default order
     * for _maxObservedCvssV2Score_ is **ascending**. Default order for _maxObservedCvssV3Score_ is
     * **ascending**. Default order for _maxObservedCvssV2ScoreWithIgnored_ is **ascending**.
     * Default order for _maxObservedCvssV3ScoreWithIgnored_ is **ascending**. Default order for
     * _timeCreated_ is **descending**. Default order for _vulnerableArtifactsCount_ is
     * **ascending**. Default order for _vulnerableArtifactsCountWithIgnored_ is **ascending**.
     * Default order for _maxObservedSeverity_ is **ascending**. Default order for
     * _maxObservedSeverityWithIgnored_ is **ascending**. Default order for _displayName_ is
     * **ascending**.
     */
    private SortBy sortBy;

    /**
     * The field used to sort Vulnerability Audits. Only one sort order is allowed. Default order
     * for _maxObservedCvssV2Score_ is **ascending**. Default order for _maxObservedCvssV3Score_ is
     * **ascending**. Default order for _maxObservedCvssV2ScoreWithIgnored_ is **ascending**.
     * Default order for _maxObservedCvssV3ScoreWithIgnored_ is **ascending**. Default order for
     * _timeCreated_ is **descending**. Default order for _vulnerableArtifactsCount_ is
     * **ascending**. Default order for _vulnerableArtifactsCountWithIgnored_ is **ascending**.
     * Default order for _maxObservedSeverity_ is **ascending**. Default order for
     * _maxObservedSeverityWithIgnored_ is **ascending**. Default order for _displayName_ is
     * **ascending**.
     */
    public enum SortBy implements com.oracle.bmc.http.internal.BmcEnum {
        MaxObservedCvssV2Score("maxObservedCvssV2Score"),
        MaxObservedCvssV3Score("maxObservedCvssV3Score"),
        MaxObservedSeverity("maxObservedSeverity"),
        TimeCreated("timeCreated"),
        VulnerableArtifactsCount("vulnerableArtifactsCount"),
        MaxObservedCvssV2ScoreWithIgnored("maxObservedCvssV2ScoreWithIgnored"),
        MaxObservedCvssV3ScoreWithIgnored("maxObservedCvssV3ScoreWithIgnored"),
        MaxObservedSeverityWithIgnored("maxObservedSeverityWithIgnored"),
        VulnerableArtifactsCountWithIgnored("vulnerableArtifactsCountWithIgnored"),
        DisplayName("displayName"),
        ;

        private final String value;
        private static java.util.Map<String, SortBy> map;

        static {
            map = new java.util.HashMap<>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }

        SortBy(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }
    };

    /**
     * The field used to sort Vulnerability Audits. Only one sort order is allowed. Default order
     * for _maxObservedCvssV2Score_ is **ascending**. Default order for _maxObservedCvssV3Score_ is
     * **ascending**. Default order for _maxObservedCvssV2ScoreWithIgnored_ is **ascending**.
     * Default order for _maxObservedCvssV3ScoreWithIgnored_ is **ascending**. Default order for
     * _timeCreated_ is **descending**. Default order for _vulnerableArtifactsCount_ is
     * **ascending**. Default order for _vulnerableArtifactsCountWithIgnored_ is **ascending**.
     * Default order for _maxObservedSeverity_ is **ascending**. Default order for
     * _maxObservedSeverityWithIgnored_ is **ascending**. Default order for _displayName_ is
     * **ascending**.
     */
    public SortBy getSortBy() {
        return sortBy;
    }
    /** A filter to return only resources that match the entire display name given. */
    private String displayName;

    /** A filter to return only resources that match the entire display name given. */
    public String getDisplayName() {
        return displayName;
    }
    /**
     * A filter to return only Vulnerability Audits with timeCreated greater or equal to the
     * specified value.
     */
    private java.util.Date timeCreatedGreaterThanOrEqualTo;

    /**
     * A filter to return only Vulnerability Audits with timeCreated greater or equal to the
     * specified value.
     */
    public java.util.Date getTimeCreatedGreaterThanOrEqualTo() {
        return timeCreatedGreaterThanOrEqualTo;
    }
    /**
     * A filter to return only Vulnerability Audits with timeCreated less or equal to the specified
     * value.
     */
    private java.util.Date timeCreatedLessThanOrEqualTo;

    /**
     * A filter to return only Vulnerability Audits with timeCreated less or equal to the specified
     * value.
     */
    public java.util.Date getTimeCreatedLessThanOrEqualTo() {
        return timeCreatedLessThanOrEqualTo;
    }
    /**
     * A filter that returns only Vulnerability Audits that have a maximum observed Severity greater
     * than or equal to the specified value.
     */
    private com.oracle.bmc.adm.model.VulnerabilitySeverity maxObservedSeverityGreaterThanOrEqualTo;

    /**
     * A filter that returns only Vulnerability Audits that have a maximum observed Severity greater
     * than or equal to the specified value.
     */
    public com.oracle.bmc.adm.model.VulnerabilitySeverity
            getMaxObservedSeverityGreaterThanOrEqualTo() {
        return maxObservedSeverityGreaterThanOrEqualTo;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListVulnerabilityAuditsRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /**
         * A filter to return only resources that match the specified identifier. Required only if
         * the compartmentId query parameter is not specified.
         */
        private String id = null;

        /**
         * A filter to return only resources that match the specified identifier. Required only if
         * the compartmentId query parameter is not specified.
         *
         * @param id the value to set
         * @return this builder instance
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * A filter to return only resources that belong to the specified compartment identifier.
         * Required only if the id query param is not specified.
         */
        private String compartmentId = null;

        /**
         * A filter to return only resources that belong to the specified compartment identifier.
         * Required only if the id query param is not specified.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /**
         * A filter to return only Vulnerability Audits that were created against the specified
         * knowledge base.
         */
        private String knowledgeBaseId = null;

        /**
         * A filter to return only Vulnerability Audits that were created against the specified
         * knowledge base.
         *
         * @param knowledgeBaseId the value to set
         * @return this builder instance
         */
        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        /** A filter to return only successful or failed Vulnerability Audits. */
        private Boolean isSuccess = null;

        /**
         * A filter to return only successful or failed Vulnerability Audits.
         *
         * @param isSuccess the value to set
         * @return this builder instance
         */
        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            return this;
        }

        /** A filter to return only Vulnerability Audits that match the specified lifecycleState. */
        private com.oracle.bmc.adm.model.VulnerabilityAudit.LifecycleState lifecycleState = null;

        /**
         * A filter to return only Vulnerability Audits that match the specified lifecycleState.
         *
         * @param lifecycleState the value to set
         * @return this builder instance
         */
        public Builder lifecycleState(
                com.oracle.bmc.adm.model.VulnerabilityAudit.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        /** The sort order to use, either 'ASC' or 'DESC'. */
        private com.oracle.bmc.adm.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'ASC' or 'DESC'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.adm.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         */
        private String page = null;

        /**
         * A token representing the position at which to start retrieving results. This must come
         * from the {@code opc-next-page} header field of a previous response.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * The field used to sort Vulnerability Audits. Only one sort order is allowed. Default
         * order for _maxObservedCvssV2Score_ is **ascending**. Default order for
         * _maxObservedCvssV3Score_ is **ascending**. Default order for
         * _maxObservedCvssV2ScoreWithIgnored_ is **ascending**. Default order for
         * _maxObservedCvssV3ScoreWithIgnored_ is **ascending**. Default order for _timeCreated_ is
         * **descending**. Default order for _vulnerableArtifactsCount_ is **ascending**. Default
         * order for _vulnerableArtifactsCountWithIgnored_ is **ascending**. Default order for
         * _maxObservedSeverity_ is **ascending**. Default order for
         * _maxObservedSeverityWithIgnored_ is **ascending**. Default order for _displayName_ is
         * **ascending**.
         */
        private SortBy sortBy = null;

        /**
         * The field used to sort Vulnerability Audits. Only one sort order is allowed. Default
         * order for _maxObservedCvssV2Score_ is **ascending**. Default order for
         * _maxObservedCvssV3Score_ is **ascending**. Default order for
         * _maxObservedCvssV2ScoreWithIgnored_ is **ascending**. Default order for
         * _maxObservedCvssV3ScoreWithIgnored_ is **ascending**. Default order for _timeCreated_ is
         * **descending**. Default order for _vulnerableArtifactsCount_ is **ascending**. Default
         * order for _vulnerableArtifactsCountWithIgnored_ is **ascending**. Default order for
         * _maxObservedSeverity_ is **ascending**. Default order for
         * _maxObservedSeverityWithIgnored_ is **ascending**. Default order for _displayName_ is
         * **ascending**.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** A filter to return only resources that match the entire display name given. */
        private String displayName = null;

        /**
         * A filter to return only resources that match the entire display name given.
         *
         * @param displayName the value to set
         * @return this builder instance
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * A filter to return only Vulnerability Audits with timeCreated greater or equal to the
         * specified value.
         */
        private java.util.Date timeCreatedGreaterThanOrEqualTo = null;

        /**
         * A filter to return only Vulnerability Audits with timeCreated greater or equal to the
         * specified value.
         *
         * @param timeCreatedGreaterThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeCreatedGreaterThanOrEqualTo(
                java.util.Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        /**
         * A filter to return only Vulnerability Audits with timeCreated less or equal to the
         * specified value.
         */
        private java.util.Date timeCreatedLessThanOrEqualTo = null;

        /**
         * A filter to return only Vulnerability Audits with timeCreated less or equal to the
         * specified value.
         *
         * @param timeCreatedLessThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeCreatedLessThanOrEqualTo(java.util.Date timeCreatedLessThanOrEqualTo) {
            this.timeCreatedLessThanOrEqualTo = timeCreatedLessThanOrEqualTo;
            return this;
        }

        /**
         * A filter that returns only Vulnerability Audits that have a maximum observed Severity
         * greater than or equal to the specified value.
         */
        private com.oracle.bmc.adm.model.VulnerabilitySeverity
                maxObservedSeverityGreaterThanOrEqualTo = null;

        /**
         * A filter that returns only Vulnerability Audits that have a maximum observed Severity
         * greater than or equal to the specified value.
         *
         * @param maxObservedSeverityGreaterThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder maxObservedSeverityGreaterThanOrEqualTo(
                com.oracle.bmc.adm.model.VulnerabilitySeverity
                        maxObservedSeverityGreaterThanOrEqualTo) {
            this.maxObservedSeverityGreaterThanOrEqualTo = maxObservedSeverityGreaterThanOrEqualTo;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListVulnerabilityAuditsRequest o) {
            id(o.getId());
            compartmentId(o.getCompartmentId());
            knowledgeBaseId(o.getKnowledgeBaseId());
            isSuccess(o.getIsSuccess());
            lifecycleState(o.getLifecycleState());
            sortOrder(o.getSortOrder());
            limit(o.getLimit());
            page(o.getPage());
            opcRequestId(o.getOpcRequestId());
            sortBy(o.getSortBy());
            displayName(o.getDisplayName());
            timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            timeCreatedLessThanOrEqualTo(o.getTimeCreatedLessThanOrEqualTo());
            maxObservedSeverityGreaterThanOrEqualTo(o.getMaxObservedSeverityGreaterThanOrEqualTo());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListVulnerabilityAuditsRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListVulnerabilityAuditsRequest
         */
        public ListVulnerabilityAuditsRequest build() {
            ListVulnerabilityAuditsRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListVulnerabilityAuditsRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListVulnerabilityAuditsRequest
         */
        public ListVulnerabilityAuditsRequest buildWithoutInvocationCallback() {
            ListVulnerabilityAuditsRequest request = new ListVulnerabilityAuditsRequest();
            request.id = id;
            request.compartmentId = compartmentId;
            request.knowledgeBaseId = knowledgeBaseId;
            request.isSuccess = isSuccess;
            request.lifecycleState = lifecycleState;
            request.sortOrder = sortOrder;
            request.limit = limit;
            request.page = page;
            request.opcRequestId = opcRequestId;
            request.sortBy = sortBy;
            request.displayName = displayName;
            request.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            request.timeCreatedLessThanOrEqualTo = timeCreatedLessThanOrEqualTo;
            request.maxObservedSeverityGreaterThanOrEqualTo =
                    maxObservedSeverityGreaterThanOrEqualTo;
            return request;
            // new ListVulnerabilityAuditsRequest(id, compartmentId, knowledgeBaseId, isSuccess,
            // lifecycleState, sortOrder, limit, page, opcRequestId, sortBy, displayName,
            // timeCreatedGreaterThanOrEqualTo, timeCreatedLessThanOrEqualTo,
            // maxObservedSeverityGreaterThanOrEqualTo);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .id(id)
                .compartmentId(compartmentId)
                .knowledgeBaseId(knowledgeBaseId)
                .isSuccess(isSuccess)
                .lifecycleState(lifecycleState)
                .sortOrder(sortOrder)
                .limit(limit)
                .page(page)
                .opcRequestId(opcRequestId)
                .sortBy(sortBy)
                .displayName(displayName)
                .timeCreatedGreaterThanOrEqualTo(timeCreatedGreaterThanOrEqualTo)
                .timeCreatedLessThanOrEqualTo(timeCreatedLessThanOrEqualTo)
                .maxObservedSeverityGreaterThanOrEqualTo(maxObservedSeverityGreaterThanOrEqualTo);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(",isSuccess=").append(String.valueOf(this.isSuccess));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",timeCreatedGreaterThanOrEqualTo=")
                .append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",timeCreatedLessThanOrEqualTo=")
                .append(String.valueOf(this.timeCreatedLessThanOrEqualTo));
        sb.append(",maxObservedSeverityGreaterThanOrEqualTo=")
                .append(String.valueOf(this.maxObservedSeverityGreaterThanOrEqualTo));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListVulnerabilityAuditsRequest)) {
            return false;
        }

        ListVulnerabilityAuditsRequest other = (ListVulnerabilityAuditsRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId)
                && java.util.Objects.equals(this.isSuccess, other.isSuccess)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(
                        this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo)
                && java.util.Objects.equals(
                        this.timeCreatedLessThanOrEqualTo, other.timeCreatedLessThanOrEqualTo)
                && java.util.Objects.equals(
                        this.maxObservedSeverityGreaterThanOrEqualTo,
                        other.maxObservedSeverityGreaterThanOrEqualTo);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result = (result * PRIME) + (this.isSuccess == null ? 43 : this.isSuccess.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result =
                (result * PRIME)
                        + (this.timeCreatedGreaterThanOrEqualTo == null
                                ? 43
                                : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result =
                (result * PRIME)
                        + (this.timeCreatedLessThanOrEqualTo == null
                                ? 43
                                : this.timeCreatedLessThanOrEqualTo.hashCode());
        result =
                (result * PRIME)
                        + (this.maxObservedSeverityGreaterThanOrEqualTo == null
                                ? 43
                                : this.maxObservedSeverityGreaterThanOrEqualTo.hashCode());
        return result;
    }
}
