/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.core.model;

/** Type of encryption cipher suite to use for the MACsec connection. */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20160918")
public enum MacsecEncryptionCipher implements com.oracle.bmc.http.internal.BmcEnum {
    Aes128Gcm("AES128_GCM"),
    Aes128GcmXpn("AES128_GCM_XPN"),
    Aes256Gcm("AES256_GCM"),
    Aes256GcmXpn("AES256_GCM_XPN"),

    /**
     * This value is used if a service returns a value for this enum that is not recognized by this
     * version of the SDK.
     */
    UnknownEnumValue(null);

    private static final org.slf4j.Logger LOG =
            org.slf4j.LoggerFactory.getLogger(MacsecEncryptionCipher.class);

    private final String value;
    private static java.util.Map<String, MacsecEncryptionCipher> map;

    static {
        map = new java.util.HashMap<>();
        for (MacsecEncryptionCipher v : MacsecEncryptionCipher.values()) {
            if (v != UnknownEnumValue) {
                map.put(v.getValue(), v);
            }
        }
    }

    MacsecEncryptionCipher(String value) {
        this.value = value;
    }

    @com.fasterxml.jackson.annotation.JsonValue
    public String getValue() {
        return value;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    public static MacsecEncryptionCipher create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn(
                "Received unknown value '{}' for enum 'MacsecEncryptionCipher', returning UnknownEnumValue",
                key);
        return UnknownEnumValue;
    }
}
