/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.desktops;

import com.oracle.bmc.desktops.requests.*;
import com.oracle.bmc.desktops.responses.*;

/**
 * Create and manage cloud-hosted desktops which can be accessed from a web browser or installed
 * client.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220618")
public interface DesktopServiceAsync extends AutoCloseable {

    /** Rebuilds the client from scratch. Useful to refresh certificates. */
    void refreshClient();

    /**
     * Sets the endpoint to call (ex, https://www.example.com).
     *
     * @param endpoint The endpoint of the serice.
     */
    void setEndpoint(String endpoint);

    /** Gets the set endpoint for REST call (ex, https://www.example.com) */
    String getEndpoint();

    /**
     * Sets the region to call (ex, Region.US_PHOENIX_1).
     *
     * <p>Note, this will call {@link #setEndpoint(String) setEndpoint} after resolving the
     * endpoint. If the service is not available in this region, however, an
     * IllegalArgumentException will be raised.
     *
     * @param region The region of the service.
     */
    void setRegion(com.oracle.bmc.Region region);

    /**
     * Sets the region to call (ex, 'us-phoenix-1').
     *
     * <p>Note, this will first try to map the region ID to a known Region and call {@link
     * #setRegion(Region) setRegion}.
     *
     * <p>If no known Region could be determined, it will create an endpoint based on the default
     * endpoint format ({@link com.oracle.bmc.Region#formatDefaultRegionEndpoint(Service, String)}
     * and then call {@link #setEndpoint(String) setEndpoint}.
     *
     * @param regionId The public region ID.
     */
    void setRegion(String regionId);

    /**
     * Determines whether realm specific endpoint should be used or not. Set
     * realmSpecificEndpointTemplateEnabled to "true" if the user wants to enable use of realm
     * specific endpoint template, otherwise set it to "false"
     *
     * @param realmSpecificEndpointTemplateEnabled flag to enable the use of realm specific endpoint
     *     template
     */
    void useRealmSpecificEndpointTemplate(boolean realmSpecificEndpointTemplateEnabled);

    /**
     * Cancel work request with the given ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CancelWorkRequestResponse> cancelWorkRequest(
            CancelWorkRequestRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CancelWorkRequestRequest, CancelWorkRequestResponse>
                    handler);

    /**
     * Moves a desktop pool into a different compartment within the same tenancy. You must provide
     * the OCID of the desktop pool and the OCID of the compartment that you are moving the pool to.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ChangeDesktopPoolCompartmentResponse> changeDesktopPoolCompartment(
            ChangeDesktopPoolCompartmentRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ChangeDesktopPoolCompartmentRequest,
                            ChangeDesktopPoolCompartmentResponse>
                    handler);

    /**
     * Creates a desktop pool with the given configuration parameters.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<CreateDesktopPoolResponse> createDesktopPool(
            CreateDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            CreateDesktopPoolRequest, CreateDesktopPoolResponse>
                    handler);

    /**
     * Deletes the desktop with the specified OCID. The service terminates the associated compute
     * instance. The end-user loses access to the desktop instance permanently. Any associated block
     * volume becomes inactive but is not deleted.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteDesktopResponse> deleteDesktop(
            DeleteDesktopRequest request,
            com.oracle.bmc.responses.AsyncHandler<DeleteDesktopRequest, DeleteDesktopResponse>
                    handler);

    /**
     * Deletes a desktop pool with the specified OCID. The service terminates all compute instances
     * and users immediately lose access to their desktops. You can choose to preserve the block
     * volumes associated with the pool.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<DeleteDesktopPoolResponse> deleteDesktopPool(
            DeleteDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            DeleteDesktopPoolRequest, DeleteDesktopPoolResponse>
                    handler);

    /**
     * Provides information about the desktop with the specified OCID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetDesktopResponse> getDesktop(
            GetDesktopRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetDesktopRequest, GetDesktopResponse> handler);

    /**
     * Returns information about the desktop pool including all configuration parameters and the
     * current state.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetDesktopPoolResponse> getDesktopPool(
            GetDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetDesktopPoolRequest, GetDesktopPoolResponse>
                    handler);

    /**
     * Gets the status of the work request with the given ID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<GetWorkRequestResponse> getWorkRequest(
            GetWorkRequestRequest request,
            com.oracle.bmc.responses.AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse>
                    handler);

    /**
     * Returns a list of desktops within a given desktop pool. You can limit the results to an
     * availability domain, desktop name, or desktop state. You can limit the number of results
     * returned, sort the results by time or name, and sort in ascending or descending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListDesktopPoolDesktopsResponse> listDesktopPoolDesktops(
            ListDesktopPoolDesktopsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListDesktopPoolDesktopsRequest, ListDesktopPoolDesktopsResponse>
                    handler);

    /**
     * Returns a list of volumes within the given desktop pool. You can limit the results to an
     * availability domain, volume name, or volume state. You can limit the number of results
     * returned, sort the results by time or name, and sort in ascending or descending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListDesktopPoolVolumesResponse> listDesktopPoolVolumes(
            ListDesktopPoolVolumesRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListDesktopPoolVolumesRequest, ListDesktopPoolVolumesResponse>
                    handler);

    /**
     * Returns a list of desktop pools within the given compartment. You can limit the results to an
     * availability domain, pool name, or pool state. You can limit the number of results returned,
     * sort the results by time or name, and sort in ascending or descending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListDesktopPoolsResponse> listDesktopPools(
            ListDesktopPoolsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListDesktopPoolsRequest, ListDesktopPoolsResponse>
                    handler);

    /**
     * Returns a list of desktops filtered by the specified parameters. You can limit the results to
     * an availability domain, desktop name, desktop OCID, desktop state, pool OCID, or compartment
     * OCID. You can limit the number of results returned, sort the results by time or name, and
     * sort in ascending or descending order.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListDesktopsResponse> listDesktops(
            ListDesktopsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListDesktopsRequest, ListDesktopsResponse>
                    handler);

    /**
     * Return a (paginated) list of errors for a given work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(
            ListWorkRequestErrorsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>
                    handler);

    /**
     * Return a (paginated) list of logs for a given work request.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestLogsResponse> listWorkRequestLogs(
            ListWorkRequestLogsRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>
                    handler);

    /**
     * Lists the work requests in a compartment.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<ListWorkRequestsResponse> listWorkRequests(
            ListWorkRequestsRequest request,
            com.oracle.bmc.responses.AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse>
                    handler);

    /**
     * Starts the desktop with the specified OCID.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<StartDesktopResponse> startDesktop(
            StartDesktopRequest request,
            com.oracle.bmc.responses.AsyncHandler<StartDesktopRequest, StartDesktopResponse>
                    handler);

    /**
     * Starts the desktop pool with the specified OCID. Once the pool is ACTIVE, users will have
     * access to their desktops within the pool.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<StartDesktopPoolResponse> startDesktopPool(
            StartDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<StartDesktopPoolRequest, StartDesktopPoolResponse>
                    handler);

    /**
     * Stops the desktop with the specified OCID. Stopping a desktop causes the end-user to lose
     * access to their desktop instance until the desktop is restarted.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<StopDesktopResponse> stopDesktop(
            StopDesktopRequest request,
            com.oracle.bmc.responses.AsyncHandler<StopDesktopRequest, StopDesktopResponse> handler);

    /**
     * Stops the desktop pool with the specified OCID. Users will lose access to their desktops
     * until you explicitly start the pool again.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<StopDesktopPoolResponse> stopDesktopPool(
            StopDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<StopDesktopPoolRequest, StopDesktopPoolResponse>
                    handler);

    /**
     * Modifies information about the desktop such as the name.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateDesktopResponse> updateDesktop(
            UpdateDesktopRequest request,
            com.oracle.bmc.responses.AsyncHandler<UpdateDesktopRequest, UpdateDesktopResponse>
                    handler);

    /**
     * Modifies the configuration of the desktop pool such as the availability, contact information,
     * description, name, device policy, pool size, standby size, and start or stop time.
     *
     * @param request The request object containing the details to send
     * @param handler The request handler to invoke upon completion, may be null.
     * @return A Future that can be used to get the response if no AsyncHandler was provided. Note,
     *     if you provide an AsyncHandler and use the Future, some types of responses (like
     *     java.io.InputStream) may not be able to be read in both places as the underlying stream
     *     may only be consumed once.
     */
    java.util.concurrent.Future<UpdateDesktopPoolResponse> updateDesktopPool(
            UpdateDesktopPoolRequest request,
            com.oracle.bmc.responses.AsyncHandler<
                            UpdateDesktopPoolRequest, UpdateDesktopPoolResponse>
                    handler);
}
