/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.goldengate.requests;

import com.oracle.bmc.goldengate.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/3.40.0/goldengate/ListDeploymentsExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use ListDeploymentsRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200407")
public class ListDeploymentsRequest extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /**
     * The OCID of the compartment that contains the work request. Work requests should be scoped to
     * the same compartment as the resource the work request affects. If the work request concerns
     * multiple resources, and those resources are not in the same compartment, it is up to the
     * service team to pick the primary resource whose compartment should be used.
     */
    private String compartmentId;

    /**
     * The OCID of the compartment that contains the work request. Work requests should be scoped to
     * the same compartment as the resource the work request affects. If the work request concerns
     * multiple resources, and those resources are not in the same compartment, it is up to the
     * service team to pick the primary resource whose compartment should be used.
     */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** The connection type which the deployment must support. */
    private com.oracle.bmc.goldengate.model.ConnectionType supportedConnectionType;

    /** The connection type which the deployment must support. */
    public com.oracle.bmc.goldengate.model.ConnectionType getSupportedConnectionType() {
        return supportedConnectionType;
    }
    /** The OCID of the connection which for the deployment must be assigned. */
    private String assignedConnectionId;

    /** The OCID of the connection which for the deployment must be assigned. */
    public String getAssignedConnectionId() {
        return assignedConnectionId;
    }
    /** Return the deployments to which the specified connectionId may be assigned. */
    private String assignableConnectionId;

    /** Return the deployments to which the specified connectionId may be assigned. */
    public String getAssignableConnectionId() {
        return assignableConnectionId;
    }
    /** A filter to return only the resources that match the 'lifecycleState' given. */
    private com.oracle.bmc.goldengate.model.LifecycleState lifecycleState;

    /** A filter to return only the resources that match the 'lifecycleState' given. */
    public com.oracle.bmc.goldengate.model.LifecycleState getLifecycleState() {
        return lifecycleState;
    }
    /** A filter to return only the resources that match the 'lifecycleSubState' given. */
    private com.oracle.bmc.goldengate.model.LifecycleSubState lifecycleSubState;

    /** A filter to return only the resources that match the 'lifecycleSubState' given. */
    public com.oracle.bmc.goldengate.model.LifecycleSubState getLifecycleSubState() {
        return lifecycleSubState;
    }
    /** A filter to return only the resources that match the entire 'displayName' given. */
    private String displayName;

    /** A filter to return only the resources that match the entire 'displayName' given. */
    public String getDisplayName() {
        return displayName;
    }
    /** A filter to return only the resources that match the 'fqdn' given. */
    private String fqdn;

    /** A filter to return only the resources that match the 'fqdn' given. */
    public String getFqdn() {
        return fqdn;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    private String page;

    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    public String getPage() {
        return page;
    }
    /** The sort order to use, either 'asc' or 'desc'. */
    private com.oracle.bmc.goldengate.model.SortOrder sortOrder;

    /** The sort order to use, either 'asc' or 'desc'. */
    public com.oracle.bmc.goldengate.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /**
     * The field to sort by. Only one sort order can be provided. Default order for 'timeCreated' is
     * descending. Default order for 'displayName' is ascending. If no value is specified
     * timeCreated is the default.
     */
    private SortBy sortBy;

    /**
     * The field to sort by. Only one sort order can be provided. Default order for 'timeCreated' is
     * descending. Default order for 'displayName' is ascending. If no value is specified
     * timeCreated is the default.
     */
    public enum SortBy implements com.oracle.bmc.http.internal.BmcEnum {
        TimeCreated("timeCreated"),
        DisplayName("displayName"),
        ;

        private final String value;
        private static java.util.Map<String, SortBy> map;

        static {
            map = new java.util.HashMap<>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }

        SortBy(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }
    };

    /**
     * The field to sort by. Only one sort order can be provided. Default order for 'timeCreated' is
     * descending. Default order for 'displayName' is ascending. If no value is specified
     * timeCreated is the default.
     */
    public SortBy getSortBy() {
        return sortBy;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListDeploymentsRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /**
         * The OCID of the compartment that contains the work request. Work requests should be
         * scoped to the same compartment as the resource the work request affects. If the work
         * request concerns multiple resources, and those resources are not in the same compartment,
         * it is up to the service team to pick the primary resource whose compartment should be
         * used.
         */
        private String compartmentId = null;

        /**
         * The OCID of the compartment that contains the work request. Work requests should be
         * scoped to the same compartment as the resource the work request affects. If the work
         * request concerns multiple resources, and those resources are not in the same compartment,
         * it is up to the service team to pick the primary resource whose compartment should be
         * used.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** The connection type which the deployment must support. */
        private com.oracle.bmc.goldengate.model.ConnectionType supportedConnectionType = null;

        /**
         * The connection type which the deployment must support.
         *
         * @param supportedConnectionType the value to set
         * @return this builder instance
         */
        public Builder supportedConnectionType(
                com.oracle.bmc.goldengate.model.ConnectionType supportedConnectionType) {
            this.supportedConnectionType = supportedConnectionType;
            return this;
        }

        /** The OCID of the connection which for the deployment must be assigned. */
        private String assignedConnectionId = null;

        /**
         * The OCID of the connection which for the deployment must be assigned.
         *
         * @param assignedConnectionId the value to set
         * @return this builder instance
         */
        public Builder assignedConnectionId(String assignedConnectionId) {
            this.assignedConnectionId = assignedConnectionId;
            return this;
        }

        /** Return the deployments to which the specified connectionId may be assigned. */
        private String assignableConnectionId = null;

        /**
         * Return the deployments to which the specified connectionId may be assigned.
         *
         * @param assignableConnectionId the value to set
         * @return this builder instance
         */
        public Builder assignableConnectionId(String assignableConnectionId) {
            this.assignableConnectionId = assignableConnectionId;
            return this;
        }

        /** A filter to return only the resources that match the 'lifecycleState' given. */
        private com.oracle.bmc.goldengate.model.LifecycleState lifecycleState = null;

        /**
         * A filter to return only the resources that match the 'lifecycleState' given.
         *
         * @param lifecycleState the value to set
         * @return this builder instance
         */
        public Builder lifecycleState(
                com.oracle.bmc.goldengate.model.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        /** A filter to return only the resources that match the 'lifecycleSubState' given. */
        private com.oracle.bmc.goldengate.model.LifecycleSubState lifecycleSubState = null;

        /**
         * A filter to return only the resources that match the 'lifecycleSubState' given.
         *
         * @param lifecycleSubState the value to set
         * @return this builder instance
         */
        public Builder lifecycleSubState(
                com.oracle.bmc.goldengate.model.LifecycleSubState lifecycleSubState) {
            this.lifecycleSubState = lifecycleSubState;
            return this;
        }

        /** A filter to return only the resources that match the entire 'displayName' given. */
        private String displayName = null;

        /**
         * A filter to return only the resources that match the entire 'displayName' given.
         *
         * @param displayName the value to set
         * @return this builder instance
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        /** A filter to return only the resources that match the 'fqdn' given. */
        private String fqdn = null;

        /**
         * A filter to return only the resources that match the 'fqdn' given.
         *
         * @param fqdn the value to set
         * @return this builder instance
         */
        public Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         */
        private String page = null;

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /** The sort order to use, either 'asc' or 'desc'. */
        private com.oracle.bmc.goldengate.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'asc' or 'desc'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.goldengate.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * The field to sort by. Only one sort order can be provided. Default order for
         * 'timeCreated' is descending. Default order for 'displayName' is ascending. If no value is
         * specified timeCreated is the default.
         */
        private SortBy sortBy = null;

        /**
         * The field to sort by. Only one sort order can be provided. Default order for
         * 'timeCreated' is descending. Default order for 'displayName' is ascending. If no value is
         * specified timeCreated is the default.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListDeploymentsRequest o) {
            compartmentId(o.getCompartmentId());
            supportedConnectionType(o.getSupportedConnectionType());
            assignedConnectionId(o.getAssignedConnectionId());
            assignableConnectionId(o.getAssignableConnectionId());
            lifecycleState(o.getLifecycleState());
            lifecycleSubState(o.getLifecycleSubState());
            displayName(o.getDisplayName());
            fqdn(o.getFqdn());
            limit(o.getLimit());
            page(o.getPage());
            sortOrder(o.getSortOrder());
            sortBy(o.getSortBy());
            opcRequestId(o.getOpcRequestId());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListDeploymentsRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListDeploymentsRequest
         */
        public ListDeploymentsRequest build() {
            ListDeploymentsRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListDeploymentsRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListDeploymentsRequest
         */
        public ListDeploymentsRequest buildWithoutInvocationCallback() {
            ListDeploymentsRequest request = new ListDeploymentsRequest();
            request.compartmentId = compartmentId;
            request.supportedConnectionType = supportedConnectionType;
            request.assignedConnectionId = assignedConnectionId;
            request.assignableConnectionId = assignableConnectionId;
            request.lifecycleState = lifecycleState;
            request.lifecycleSubState = lifecycleSubState;
            request.displayName = displayName;
            request.fqdn = fqdn;
            request.limit = limit;
            request.page = page;
            request.sortOrder = sortOrder;
            request.sortBy = sortBy;
            request.opcRequestId = opcRequestId;
            return request;
            // new ListDeploymentsRequest(compartmentId, supportedConnectionType,
            // assignedConnectionId, assignableConnectionId, lifecycleState, lifecycleSubState,
            // displayName, fqdn, limit, page, sortOrder, sortBy, opcRequestId);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .compartmentId(compartmentId)
                .supportedConnectionType(supportedConnectionType)
                .assignedConnectionId(assignedConnectionId)
                .assignableConnectionId(assignableConnectionId)
                .lifecycleState(lifecycleState)
                .lifecycleSubState(lifecycleSubState)
                .displayName(displayName)
                .fqdn(fqdn)
                .limit(limit)
                .page(page)
                .sortOrder(sortOrder)
                .sortBy(sortBy)
                .opcRequestId(opcRequestId);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",supportedConnectionType=").append(String.valueOf(this.supportedConnectionType));
        sb.append(",assignedConnectionId=").append(String.valueOf(this.assignedConnectionId));
        sb.append(",assignableConnectionId=").append(String.valueOf(this.assignableConnectionId));
        sb.append(",lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(",lifecycleSubState=").append(String.valueOf(this.lifecycleSubState));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",fqdn=").append(String.valueOf(this.fqdn));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDeploymentsRequest)) {
            return false;
        }

        ListDeploymentsRequest other = (ListDeploymentsRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.supportedConnectionType, other.supportedConnectionType)
                && java.util.Objects.equals(this.assignedConnectionId, other.assignedConnectionId)
                && java.util.Objects.equals(
                        this.assignableConnectionId, other.assignableConnectionId)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.lifecycleSubState, other.lifecycleSubState)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.fqdn, other.fqdn)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.supportedConnectionType == null
                                ? 43
                                : this.supportedConnectionType.hashCode());
        result =
                (result * PRIME)
                        + (this.assignedConnectionId == null
                                ? 43
                                : this.assignedConnectionId.hashCode());
        result =
                (result * PRIME)
                        + (this.assignableConnectionId == null
                                ? 43
                                : this.assignableConnectionId.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleSubState == null ? 43 : this.lifecycleSubState.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.fqdn == null ? 43 : this.fqdn.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }
}
