/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.monitoring.model;

/**
 * A timestamped alarm state entry for a metric stream. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20180401")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = AlarmDimensionStatesEntry.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class AlarmDimensionStatesEntry
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"dimensions", "status", "ruleName", "timestamp"})
    public AlarmDimensionStatesEntry(
            java.util.Map<String, String> dimensions,
            Status status,
            String ruleName,
            java.util.Date timestamp) {
        super();
        this.dimensions = dimensions;
        this.status = status;
        this.ruleName = ruleName;
        this.timestamp = timestamp;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Indicator of the metric stream associated with the alarm state entry. Includes one or
         * more dimension key-value pairs.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("dimensions")
        private java.util.Map<String, String> dimensions;

        /**
         * Indicator of the metric stream associated with the alarm state entry. Includes one or
         * more dimension key-value pairs.
         *
         * @param dimensions the value to set
         * @return this builder
         */
        public Builder dimensions(java.util.Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }
        /**
         * Transition state (status value) associated with the alarm state entry.
         *
         * <p>Example: {@code FIRING}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("status")
        private Status status;

        /**
         * Transition state (status value) associated with the alarm state entry.
         *
         * <p>Example: {@code FIRING}
         *
         * @param status the value to set
         * @return this builder
         */
        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }
        /**
         * Identifier of the alarm's base values for alarm evaluation, for use when the alarm
         * contains overrides. A valid ruleName value starts with an alphabetic character and
         * includes only alphanumeric characters, underscores and square brackets. Minimum number of
         * characters: 3. Default value is {@code BASE}. For information about alarm overrides, see
         * {@link #alarmOverride(AlarmOverrideRequest) alarmOverride}.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("ruleName")
        private String ruleName;

        /**
         * Identifier of the alarm's base values for alarm evaluation, for use when the alarm
         * contains overrides. A valid ruleName value starts with an alphabetic character and
         * includes only alphanumeric characters, underscores and square brackets. Minimum number of
         * characters: 3. Default value is {@code BASE}. For information about alarm overrides, see
         * {@link #alarmOverride(AlarmOverrideRequest) alarmOverride}.
         *
         * @param ruleName the value to set
         * @return this builder
         */
        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.__explicitlySet__.add("ruleName");
            return this;
        }
        /**
         * Transition time associated with the alarm state entry. Format defined by RFC3339.
         *
         * <p>Example: {@code 2022-02-01T01:02:29.600Z}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timestamp")
        private java.util.Date timestamp;

        /**
         * Transition time associated with the alarm state entry. Format defined by RFC3339.
         *
         * <p>Example: {@code 2022-02-01T01:02:29.600Z}
         *
         * @param timestamp the value to set
         * @return this builder
         */
        public Builder timestamp(java.util.Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public AlarmDimensionStatesEntry build() {
            AlarmDimensionStatesEntry model =
                    new AlarmDimensionStatesEntry(
                            this.dimensions, this.status, this.ruleName, this.timestamp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(AlarmDimensionStatesEntry model) {
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("ruleName")) {
                this.ruleName(model.getRuleName());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Indicator of the metric stream associated with the alarm state entry. Includes one or more
     * dimension key-value pairs.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("dimensions")
    private final java.util.Map<String, String> dimensions;

    /**
     * Indicator of the metric stream associated with the alarm state entry. Includes one or more
     * dimension key-value pairs.
     *
     * @return the value
     */
    public java.util.Map<String, String> getDimensions() {
        return dimensions;
    }

    /**
     * Transition state (status value) associated with the alarm state entry.
     *
     * <p>Example: {@code FIRING}
     */
    public enum Status implements com.oracle.bmc.http.internal.BmcEnum {
        Firing("FIRING"),
        Ok("OK"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by
         * this version of the SDK.
         */
        UnknownEnumValue(null);

        private static final org.slf4j.Logger LOG = org.slf4j.LoggerFactory.getLogger(Status.class);

        private final String value;
        private static java.util.Map<String, Status> map;

        static {
            map = new java.util.HashMap<>();
            for (Status v : Status.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        Status(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'Status', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * Transition state (status value) associated with the alarm state entry.
     *
     * <p>Example: {@code FIRING}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("status")
    private final Status status;

    /**
     * Transition state (status value) associated with the alarm state entry.
     *
     * <p>Example: {@code FIRING}
     *
     * @return the value
     */
    public Status getStatus() {
        return status;
    }

    /**
     * Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains
     * overrides. A valid ruleName value starts with an alphabetic character and includes only
     * alphanumeric characters, underscores and square brackets. Minimum number of characters: 3.
     * Default value is {@code BASE}. For information about alarm overrides, see {@link
     * #alarmOverride(AlarmOverrideRequest) alarmOverride}.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("ruleName")
    private final String ruleName;

    /**
     * Identifier of the alarm's base values for alarm evaluation, for use when the alarm contains
     * overrides. A valid ruleName value starts with an alphabetic character and includes only
     * alphanumeric characters, underscores and square brackets. Minimum number of characters: 3.
     * Default value is {@code BASE}. For information about alarm overrides, see {@link
     * #alarmOverride(AlarmOverrideRequest) alarmOverride}.
     *
     * @return the value
     */
    public String getRuleName() {
        return ruleName;
    }

    /**
     * Transition time associated with the alarm state entry. Format defined by RFC3339.
     *
     * <p>Example: {@code 2022-02-01T01:02:29.600Z}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timestamp")
    private final java.util.Date timestamp;

    /**
     * Transition time associated with the alarm state entry. Format defined by RFC3339.
     *
     * <p>Example: {@code 2022-02-01T01:02:29.600Z}
     *
     * @return the value
     */
    public java.util.Date getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("AlarmDimensionStatesEntry(");
        sb.append("super=").append(super.toString());
        sb.append("dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", ruleName=").append(String.valueOf(this.ruleName));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmDimensionStatesEntry)) {
            return false;
        }

        AlarmDimensionStatesEntry other = (AlarmDimensionStatesEntry) o;
        return java.util.Objects.equals(this.dimensions, other.dimensions)
                && java.util.Objects.equals(this.status, other.status)
                && java.util.Objects.equals(this.ruleName, other.ruleName)
                && java.util.Objects.equals(this.timestamp, other.timestamp)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = (result * PRIME) + (this.status == null ? 43 : this.status.hashCode());
        result = (result * PRIME) + (this.ruleName == null ? 43 : this.ruleName.hashCode());
        result = (result * PRIME) + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
