/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.osmanagementhub.model;

/**
 * Provides identifying information for the specified software source. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20220901")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = SoftwareSourceDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class SoftwareSourceDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "displayName",
        "description",
        "softwareSourceType",
        "isMandatoryForAutonomousLinux"
    })
    public SoftwareSourceDetails(
            String id,
            String displayName,
            String description,
            SoftwareSourceType softwareSourceType,
            Boolean isMandatoryForAutonomousLinux) {
        super();
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.softwareSourceType = softwareSourceType;
        this.isMandatoryForAutonomousLinux = isMandatoryForAutonomousLinux;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the software source.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
         * of the software source.
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** Software source name. */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * Software source name.
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /** Software source description. */
        @com.fasterxml.jackson.annotation.JsonProperty("description")
        private String description;

        /**
         * Software source description.
         *
         * @param description the value to set
         * @return this builder
         */
        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }
        /** Type of the software source. */
        @com.fasterxml.jackson.annotation.JsonProperty("softwareSourceType")
        private SoftwareSourceType softwareSourceType;

        /**
         * Type of the software source.
         *
         * @param softwareSourceType the value to set
         * @return this builder
         */
        public Builder softwareSourceType(SoftwareSourceType softwareSourceType) {
            this.softwareSourceType = softwareSourceType;
            this.__explicitlySet__.add("softwareSourceType");
            return this;
        }
        /**
         * Indicates whether this is a required software source for Autonomous Linux instances. If
         * true, the user can't unselect it.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("isMandatoryForAutonomousLinux")
        private Boolean isMandatoryForAutonomousLinux;

        /**
         * Indicates whether this is a required software source for Autonomous Linux instances. If
         * true, the user can't unselect it.
         *
         * @param isMandatoryForAutonomousLinux the value to set
         * @return this builder
         */
        public Builder isMandatoryForAutonomousLinux(Boolean isMandatoryForAutonomousLinux) {
            this.isMandatoryForAutonomousLinux = isMandatoryForAutonomousLinux;
            this.__explicitlySet__.add("isMandatoryForAutonomousLinux");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public SoftwareSourceDetails build() {
            SoftwareSourceDetails model =
                    new SoftwareSourceDetails(
                            this.id,
                            this.displayName,
                            this.description,
                            this.softwareSourceType,
                            this.isMandatoryForAutonomousLinux);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(SoftwareSourceDetails model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("softwareSourceType")) {
                this.softwareSourceType(model.getSoftwareSourceType());
            }
            if (model.wasPropertyExplicitlySet("isMandatoryForAutonomousLinux")) {
                this.isMandatoryForAutonomousLinux(model.getIsMandatoryForAutonomousLinux());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the software source.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of
     * the software source.
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** Software source name. */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * Software source name.
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /** Software source description. */
    @com.fasterxml.jackson.annotation.JsonProperty("description")
    private final String description;

    /**
     * Software source description.
     *
     * @return the value
     */
    public String getDescription() {
        return description;
    }

    /** Type of the software source. */
    @com.fasterxml.jackson.annotation.JsonProperty("softwareSourceType")
    private final SoftwareSourceType softwareSourceType;

    /**
     * Type of the software source.
     *
     * @return the value
     */
    public SoftwareSourceType getSoftwareSourceType() {
        return softwareSourceType;
    }

    /**
     * Indicates whether this is a required software source for Autonomous Linux instances. If true,
     * the user can't unselect it.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("isMandatoryForAutonomousLinux")
    private final Boolean isMandatoryForAutonomousLinux;

    /**
     * Indicates whether this is a required software source for Autonomous Linux instances. If true,
     * the user can't unselect it.
     *
     * @return the value
     */
    public Boolean getIsMandatoryForAutonomousLinux() {
        return isMandatoryForAutonomousLinux;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("SoftwareSourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", softwareSourceType=").append(String.valueOf(this.softwareSourceType));
        sb.append(", isMandatoryForAutonomousLinux=")
                .append(String.valueOf(this.isMandatoryForAutonomousLinux));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftwareSourceDetails)) {
            return false;
        }

        SoftwareSourceDetails other = (SoftwareSourceDetails) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.description, other.description)
                && java.util.Objects.equals(this.softwareSourceType, other.softwareSourceType)
                && java.util.Objects.equals(
                        this.isMandatoryForAutonomousLinux, other.isMandatoryForAutonomousLinux)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.description == null ? 43 : this.description.hashCode());
        result =
                (result * PRIME)
                        + (this.softwareSourceType == null
                                ? 43
                                : this.softwareSourceType.hashCode());
        result =
                (result * PRIME)
                        + (this.isMandatoryForAutonomousLinux == null
                                ? 43
                                : this.isMandatoryForAutonomousLinux.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
