/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.stackmonitoring.model;

/**
 * The request of DiscoveryJob details. <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210330")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = CreateDiscoveryJobDetails.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class CreateDiscoveryJobDetails
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "discoveryType",
        "discoveryClient",
        "compartmentId",
        "discoveryDetails",
        "shouldPropagateTagsToDiscoveredResources",
        "freeformTags",
        "definedTags"
    })
    public CreateDiscoveryJobDetails(
            DiscoveryType discoveryType,
            String discoveryClient,
            String compartmentId,
            DiscoveryDetails discoveryDetails,
            Boolean shouldPropagateTagsToDiscoveredResources,
            java.util.Map<String, String> freeformTags,
            java.util.Map<String, java.util.Map<String, Object>> definedTags) {
        super();
        this.discoveryType = discoveryType;
        this.discoveryClient = discoveryClient;
        this.compartmentId = compartmentId;
        this.discoveryDetails = discoveryDetails;
        this.shouldPropagateTagsToDiscoveredResources = shouldPropagateTagsToDiscoveredResources;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /**
         * Add option submits new discovery Job. Add with retry option to re-submit failed discovery
         * job. Refresh option refreshes the existing discovered resources.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("discoveryType")
        private DiscoveryType discoveryType;

        /**
         * Add option submits new discovery Job. Add with retry option to re-submit failed discovery
         * job. Refresh option refreshes the existing discovered resources.
         *
         * @param discoveryType the value to set
         * @return this builder
         */
        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            this.__explicitlySet__.add("discoveryType");
            return this;
        }
        /** Client who submits discovery job. */
        @com.fasterxml.jackson.annotation.JsonProperty("discoveryClient")
        private String discoveryClient;

        /**
         * Client who submits discovery job.
         *
         * @param discoveryClient the value to set
         * @return this builder
         */
        public Builder discoveryClient(String discoveryClient) {
            this.discoveryClient = discoveryClient;
            this.__explicitlySet__.add("discoveryClient");
            return this;
        }
        /** The OCID of Compartment */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * The OCID of Compartment
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("discoveryDetails")
        private DiscoveryDetails discoveryDetails;

        public Builder discoveryDetails(DiscoveryDetails discoveryDetails) {
            this.discoveryDetails = discoveryDetails;
            this.__explicitlySet__.add("discoveryDetails");
            return this;
        }
        /**
         * If this parameter set to true, the specified tags will be applied to all resources
         * discovered in the current request. Default is true.
         */
        @com.fasterxml.jackson.annotation.JsonProperty("shouldPropagateTagsToDiscoveredResources")
        private Boolean shouldPropagateTagsToDiscoveredResources;

        /**
         * If this parameter set to true, the specified tags will be applied to all resources
         * discovered in the current request. Default is true.
         *
         * @param shouldPropagateTagsToDiscoveredResources the value to set
         * @return this builder
         */
        public Builder shouldPropagateTagsToDiscoveredResources(
                Boolean shouldPropagateTagsToDiscoveredResources) {
            this.shouldPropagateTagsToDiscoveredResources =
                    shouldPropagateTagsToDiscoveredResources;
            this.__explicitlySet__.add("shouldPropagateTagsToDiscoveredResources");
            return this;
        }
        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
        private java.util.Map<String, String> freeformTags;

        /**
         * Simple key-value pair that is applied without any predefined name, type or scope. Exists
         * for cross-compatibility only. Example: {@code {"bar-key": "value"}}
         *
         * @param freeformTags the value to set
         * @return this builder
         */
        public Builder freeformTags(java.util.Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }
        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         */
        @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
        private java.util.Map<String, java.util.Map<String, Object>> definedTags;

        /**
         * Defined tags for this resource. Each key is predefined and scoped to a namespace.
         * Example: {@code {"foo-namespace": {"bar-key": "value"}}}
         *
         * @param definedTags the value to set
         * @return this builder
         */
        public Builder definedTags(
                java.util.Map<String, java.util.Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public CreateDiscoveryJobDetails build() {
            CreateDiscoveryJobDetails model =
                    new CreateDiscoveryJobDetails(
                            this.discoveryType,
                            this.discoveryClient,
                            this.compartmentId,
                            this.discoveryDetails,
                            this.shouldPropagateTagsToDiscoveredResources,
                            this.freeformTags,
                            this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(CreateDiscoveryJobDetails model) {
            if (model.wasPropertyExplicitlySet("discoveryType")) {
                this.discoveryType(model.getDiscoveryType());
            }
            if (model.wasPropertyExplicitlySet("discoveryClient")) {
                this.discoveryClient(model.getDiscoveryClient());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("discoveryDetails")) {
                this.discoveryDetails(model.getDiscoveryDetails());
            }
            if (model.wasPropertyExplicitlySet("shouldPropagateTagsToDiscoveredResources")) {
                this.shouldPropagateTagsToDiscoveredResources(
                        model.getShouldPropagateTagsToDiscoveredResources());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /**
     * Add option submits new discovery Job. Add with retry option to re-submit failed discovery
     * job. Refresh option refreshes the existing discovered resources.
     */
    public enum DiscoveryType implements com.oracle.bmc.http.internal.BmcEnum {
        Add("ADD"),
        AddWithRetry("ADD_WITH_RETRY"),
        Refresh("REFRESH"),
        ;

        private final String value;
        private static java.util.Map<String, DiscoveryType> map;

        static {
            map = new java.util.HashMap<>();
            for (DiscoveryType v : DiscoveryType.values()) {
                map.put(v.getValue(), v);
            }
        }

        DiscoveryType(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static DiscoveryType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiscoveryType: " + key);
        }
    };
    /**
     * Add option submits new discovery Job. Add with retry option to re-submit failed discovery
     * job. Refresh option refreshes the existing discovered resources.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("discoveryType")
    private final DiscoveryType discoveryType;

    /**
     * Add option submits new discovery Job. Add with retry option to re-submit failed discovery
     * job. Refresh option refreshes the existing discovered resources.
     *
     * @return the value
     */
    public DiscoveryType getDiscoveryType() {
        return discoveryType;
    }

    /** Client who submits discovery job. */
    @com.fasterxml.jackson.annotation.JsonProperty("discoveryClient")
    private final String discoveryClient;

    /**
     * Client who submits discovery job.
     *
     * @return the value
     */
    public String getDiscoveryClient() {
        return discoveryClient;
    }

    /** The OCID of Compartment */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * The OCID of Compartment
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    @com.fasterxml.jackson.annotation.JsonProperty("discoveryDetails")
    private final DiscoveryDetails discoveryDetails;

    public DiscoveryDetails getDiscoveryDetails() {
        return discoveryDetails;
    }

    /**
     * If this parameter set to true, the specified tags will be applied to all resources discovered
     * in the current request. Default is true.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("shouldPropagateTagsToDiscoveredResources")
    private final Boolean shouldPropagateTagsToDiscoveredResources;

    /**
     * If this parameter set to true, the specified tags will be applied to all resources discovered
     * in the current request. Default is true.
     *
     * @return the value
     */
    public Boolean getShouldPropagateTagsToDiscoveredResources() {
        return shouldPropagateTagsToDiscoveredResources;
    }

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("freeformTags")
    private final java.util.Map<String, String> freeformTags;

    /**
     * Simple key-value pair that is applied without any predefined name, type or scope. Exists for
     * cross-compatibility only. Example: {@code {"bar-key": "value"}}
     *
     * @return the value
     */
    public java.util.Map<String, String> getFreeformTags() {
        return freeformTags;
    }

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     */
    @com.fasterxml.jackson.annotation.JsonProperty("definedTags")
    private final java.util.Map<String, java.util.Map<String, Object>> definedTags;

    /**
     * Defined tags for this resource. Each key is predefined and scoped to a namespace. Example:
     * {@code {"foo-namespace": {"bar-key": "value"}}}
     *
     * @return the value
     */
    public java.util.Map<String, java.util.Map<String, Object>> getDefinedTags() {
        return definedTags;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("CreateDiscoveryJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("discoveryType=").append(String.valueOf(this.discoveryType));
        sb.append(", discoveryClient=").append(String.valueOf(this.discoveryClient));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", discoveryDetails=").append(String.valueOf(this.discoveryDetails));
        sb.append(", shouldPropagateTagsToDiscoveredResources=")
                .append(String.valueOf(this.shouldPropagateTagsToDiscoveredResources));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDiscoveryJobDetails)) {
            return false;
        }

        CreateDiscoveryJobDetails other = (CreateDiscoveryJobDetails) o;
        return java.util.Objects.equals(this.discoveryType, other.discoveryType)
                && java.util.Objects.equals(this.discoveryClient, other.discoveryClient)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.discoveryDetails, other.discoveryDetails)
                && java.util.Objects.equals(
                        this.shouldPropagateTagsToDiscoveredResources,
                        other.shouldPropagateTagsToDiscoveredResources)
                && java.util.Objects.equals(this.freeformTags, other.freeformTags)
                && java.util.Objects.equals(this.definedTags, other.definedTags)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.discoveryType == null ? 43 : this.discoveryType.hashCode());
        result =
                (result * PRIME)
                        + (this.discoveryClient == null ? 43 : this.discoveryClient.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.discoveryDetails == null ? 43 : this.discoveryDetails.hashCode());
        result =
                (result * PRIME)
                        + (this.shouldPropagateTagsToDiscoveredResources == null
                                ? 43
                                : this.shouldPropagateTagsToDiscoveredResources.hashCode());
        result = (result * PRIME) + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = (result * PRIME) + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
