/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * Folder selected for scanning <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = FolderToScan.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class FolderToScan extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({"operatingsystem", "folder"})
    public FolderToScan(OperatingSystem operatingsystem, String folder) {
        super();
        this.operatingsystem = operatingsystem;
        this.folder = folder;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Operating system type */
        @com.fasterxml.jackson.annotation.JsonProperty("operatingsystem")
        private OperatingSystem operatingsystem;

        /**
         * Operating system type
         *
         * @param operatingsystem the value to set
         * @return this builder
         */
        public Builder operatingsystem(OperatingSystem operatingsystem) {
            this.operatingsystem = operatingsystem;
            this.__explicitlySet__.add("operatingsystem");
            return this;
        }
        /** Folder to be scanned in the corresponding operating system */
        @com.fasterxml.jackson.annotation.JsonProperty("folder")
        private String folder;

        /**
         * Folder to be scanned in the corresponding operating system
         *
         * @param folder the value to set
         * @return this builder
         */
        public Builder folder(String folder) {
            this.folder = folder;
            this.__explicitlySet__.add("folder");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public FolderToScan build() {
            FolderToScan model = new FolderToScan(this.operatingsystem, this.folder);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(FolderToScan model) {
            if (model.wasPropertyExplicitlySet("operatingsystem")) {
                this.operatingsystem(model.getOperatingsystem());
            }
            if (model.wasPropertyExplicitlySet("folder")) {
                this.folder(model.getFolder());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Operating system type */
    @com.fasterxml.jackson.annotation.JsonProperty("operatingsystem")
    private final OperatingSystem operatingsystem;

    /**
     * Operating system type
     *
     * @return the value
     */
    public OperatingSystem getOperatingsystem() {
        return operatingsystem;
    }

    /** Folder to be scanned in the corresponding operating system */
    @com.fasterxml.jackson.annotation.JsonProperty("folder")
    private final String folder;

    /**
     * Folder to be scanned in the corresponding operating system
     *
     * @return the value
     */
    public String getFolder() {
        return folder;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("FolderToScan(");
        sb.append("super=").append(super.toString());
        sb.append("operatingsystem=").append(String.valueOf(this.operatingsystem));
        sb.append(", folder=").append(String.valueOf(this.folder));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FolderToScan)) {
            return false;
        }

        FolderToScan other = (FolderToScan) o;
        return java.util.Objects.equals(this.operatingsystem, other.operatingsystem)
                && java.util.Objects.equals(this.folder, other.folder)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result =
                (result * PRIME)
                        + (this.operatingsystem == null ? 43 : this.operatingsystem.hashCode());
        result = (result * PRIME) + (this.folder == null ? 43 : this.folder.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
