/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

/**
 * A scan result for a host agent scan <br>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model
 * distinguishes fields that are {@code null} because they are unset from fields that are explicitly
 * set to {@code null}. This is done in the setter methods of the {@link Builder}, which maintain a
 * set of all explicitly set fields called {@link Builder#__explicitlySet__}. The {@link
 * #hashCode()} and {@link #equals(Object)} methods are implemented to take the explicitly set
 * fields into account. The constructor, on the other hand, does not take the explicitly set fields
 * into account (since the constructor cannot distinguish explicit {@code null} from unset {@code
 * null}).
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
        builder = HostAgentScanResult.Builder.class)
@com.fasterxml.jackson.annotation.JsonFilter(
        com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel.EXPLICITLY_SET_FILTER_NAME)
public final class HostAgentScanResult
        extends com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel {
    @Deprecated
    @java.beans.ConstructorProperties({
        "id",
        "displayName",
        "instanceId",
        "compartmentId",
        "highestProblemSeverity",
        "operatingSystem",
        "kernelVersion",
        "problemCount",
        "timeStarted",
        "timeFinished",
        "problems",
        "lifecycleState",
        "vendor"
    })
    public HostAgentScanResult(
            String id,
            String displayName,
            String instanceId,
            String compartmentId,
            ScanResultProblemSeverity highestProblemSeverity,
            String operatingSystem,
            String kernelVersion,
            Integer problemCount,
            java.util.Date timeStarted,
            java.util.Date timeFinished,
            java.util.List<HostAgentScanResultProblem> problems,
            LifecycleState lifecycleState,
            VendorType vendor) {
        super();
        this.id = id;
        this.displayName = displayName;
        this.instanceId = instanceId;
        this.compartmentId = compartmentId;
        this.highestProblemSeverity = highestProblemSeverity;
        this.operatingSystem = operatingSystem;
        this.kernelVersion = kernelVersion;
        this.problemCount = problemCount;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.problems = problems;
        this.lifecycleState = lifecycleState;
        this.vendor = vendor;
    }

    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    public static class Builder {
        /** Unique identifier of the scan */
        @com.fasterxml.jackson.annotation.JsonProperty("id")
        private String id;

        /**
         * Unique identifier of the scan
         *
         * @param id the value to set
         * @return this builder
         */
        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }
        /** Name of the resource */
        @com.fasterxml.jackson.annotation.JsonProperty("displayName")
        private String displayName;

        /**
         * Name of the resource
         *
         * @param displayName the value to set
         * @return this builder
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }
        /** Instance ID of the Compute Instance scanned */
        @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
        private String instanceId;

        /**
         * Instance ID of the Compute Instance scanned
         *
         * @param instanceId the value to set
         * @return this builder
         */
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }
        /**
         * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
         * target
         */
        @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
        private String compartmentId;

        /**
         * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
         * target
         *
         * @param compartmentId the value to set
         * @return this builder
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }
        /** Highest problem severity in this report */
        @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
        private ScanResultProblemSeverity highestProblemSeverity;

        /**
         * Highest problem severity in this report
         *
         * @param highestProblemSeverity the value to set
         * @return this builder
         */
        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            this.__explicitlySet__.add("highestProblemSeverity");
            return this;
        }
        /** Operating system of the host */
        @com.fasterxml.jackson.annotation.JsonProperty("operatingSystem")
        private String operatingSystem;

        /**
         * Operating system of the host
         *
         * @param operatingSystem the value to set
         * @return this builder
         */
        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }
        /** Kernel version of the operating system */
        @com.fasterxml.jackson.annotation.JsonProperty("kernelVersion")
        private String kernelVersion;

        /**
         * Kernel version of the operating system
         *
         * @param kernelVersion the value to set
         * @return this builder
         */
        public Builder kernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
            this.__explicitlySet__.add("kernelVersion");
            return this;
        }
        /** Total number of problems found in this scan */
        @com.fasterxml.jackson.annotation.JsonProperty("problemCount")
        private Integer problemCount;

        /**
         * Total number of problems found in this scan
         *
         * @param problemCount the value to set
         * @return this builder
         */
        public Builder problemCount(Integer problemCount) {
            this.problemCount = problemCount;
            this.__explicitlySet__.add("problemCount");
            return this;
        }
        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
        private java.util.Date timeStarted;

        /**
         * Date and time the scan was started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStarted the value to set
         * @return this builder
         */
        public Builder timeStarted(java.util.Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }
        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
        private java.util.Date timeFinished;

        /**
         * Date and time the scan was completed, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeFinished the value to set
         * @return this builder
         */
        public Builder timeFinished(java.util.Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }
        /** List of problems found in this scan */
        @com.fasterxml.jackson.annotation.JsonProperty("problems")
        private java.util.List<HostAgentScanResultProblem> problems;

        /**
         * List of problems found in this scan
         *
         * @param problems the value to set
         * @return this builder
         */
        public Builder problems(java.util.List<HostAgentScanResultProblem> problems) {
            this.problems = problems;
            this.__explicitlySet__.add("problems");
            return this;
        }
        /** The current state of the result. */
        @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
        private LifecycleState lifecycleState;

        /**
         * The current state of the result.
         *
         * @param lifecycleState the value to set
         * @return this builder
         */
        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }
        /** Vendor which was used for this host scan agent. */
        @com.fasterxml.jackson.annotation.JsonProperty("vendor")
        private VendorType vendor;

        /**
         * Vendor which was used for this host scan agent.
         *
         * @param vendor the value to set
         * @return this builder
         */
        public Builder vendor(VendorType vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public HostAgentScanResult build() {
            HostAgentScanResult model =
                    new HostAgentScanResult(
                            this.id,
                            this.displayName,
                            this.instanceId,
                            this.compartmentId,
                            this.highestProblemSeverity,
                            this.operatingSystem,
                            this.kernelVersion,
                            this.problemCount,
                            this.timeStarted,
                            this.timeFinished,
                            this.problems,
                            this.lifecycleState,
                            this.vendor);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(HostAgentScanResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("highestProblemSeverity")) {
                this.highestProblemSeverity(model.getHighestProblemSeverity());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("kernelVersion")) {
                this.kernelVersion(model.getKernelVersion());
            }
            if (model.wasPropertyExplicitlySet("problemCount")) {
                this.problemCount(model.getProblemCount());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("problems")) {
                this.problems(model.getProblems());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            return this;
        }
    }

    /** Create a new builder. */
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    /** Unique identifier of the scan */
    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private final String id;

    /**
     * Unique identifier of the scan
     *
     * @return the value
     */
    public String getId() {
        return id;
    }

    /** Name of the resource */
    @com.fasterxml.jackson.annotation.JsonProperty("displayName")
    private final String displayName;

    /**
     * Name of the resource
     *
     * @return the value
     */
    public String getDisplayName() {
        return displayName;
    }

    /** Instance ID of the Compute Instance scanned */
    @com.fasterxml.jackson.annotation.JsonProperty("instanceId")
    private final String instanceId;

    /**
     * Instance ID of the Compute Instance scanned
     *
     * @return the value
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
     * target
     */
    @com.fasterxml.jackson.annotation.JsonProperty("compartmentId")
    private final String compartmentId;

    /**
     * Compartment ID of the resource. This is set to the same as the compartment ID of the scan
     * target
     *
     * @return the value
     */
    public String getCompartmentId() {
        return compartmentId;
    }

    /** Highest problem severity in this report */
    @com.fasterxml.jackson.annotation.JsonProperty("highestProblemSeverity")
    private final ScanResultProblemSeverity highestProblemSeverity;

    /**
     * Highest problem severity in this report
     *
     * @return the value
     */
    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return highestProblemSeverity;
    }

    /** Operating system of the host */
    @com.fasterxml.jackson.annotation.JsonProperty("operatingSystem")
    private final String operatingSystem;

    /**
     * Operating system of the host
     *
     * @return the value
     */
    public String getOperatingSystem() {
        return operatingSystem;
    }

    /** Kernel version of the operating system */
    @com.fasterxml.jackson.annotation.JsonProperty("kernelVersion")
    private final String kernelVersion;

    /**
     * Kernel version of the operating system
     *
     * @return the value
     */
    public String getKernelVersion() {
        return kernelVersion;
    }

    /** Total number of problems found in this scan */
    @com.fasterxml.jackson.annotation.JsonProperty("problemCount")
    private final Integer problemCount;

    /**
     * Total number of problems found in this scan
     *
     * @return the value
     */
    public Integer getProblemCount() {
        return problemCount;
    }

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeStarted")
    private final java.util.Date timeStarted;

    /**
     * Date and time the scan was started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeStarted() {
        return timeStarted;
    }

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    @com.fasterxml.jackson.annotation.JsonProperty("timeFinished")
    private final java.util.Date timeFinished;

    /**
     * Date and time the scan was completed, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     *
     * @return the value
     */
    public java.util.Date getTimeFinished() {
        return timeFinished;
    }

    /** List of problems found in this scan */
    @com.fasterxml.jackson.annotation.JsonProperty("problems")
    private final java.util.List<HostAgentScanResultProblem> problems;

    /**
     * List of problems found in this scan
     *
     * @return the value
     */
    public java.util.List<HostAgentScanResultProblem> getProblems() {
        return problems;
    }

    /** The current state of the result. */
    @com.fasterxml.jackson.annotation.JsonProperty("lifecycleState")
    private final LifecycleState lifecycleState;

    /**
     * The current state of the result.
     *
     * @return the value
     */
    public LifecycleState getLifecycleState() {
        return lifecycleState;
    }

    /** Vendor which was used for this host scan agent. */
    @com.fasterxml.jackson.annotation.JsonProperty("vendor")
    private final VendorType vendor;

    /**
     * Vendor which was used for this host scan agent.
     *
     * @return the value
     */
    public VendorType getVendor() {
        return vendor;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    /**
     * Return a string representation of the object.
     *
     * @param includeByteArrayContents true to include the full contents of byte arrays
     * @return string representation
     */
    public String toString(boolean includeByteArrayContents) {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("HostAgentScanResult(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", highestProblemSeverity=").append(String.valueOf(this.highestProblemSeverity));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(", kernelVersion=").append(String.valueOf(this.kernelVersion));
        sb.append(", problemCount=").append(String.valueOf(this.problemCount));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", problems=").append(String.valueOf(this.problems));
        sb.append(", lifecycleState=").append(String.valueOf(this.lifecycleState));
        sb.append(", vendor=").append(String.valueOf(this.vendor));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostAgentScanResult)) {
            return false;
        }

        HostAgentScanResult other = (HostAgentScanResult) o;
        return java.util.Objects.equals(this.id, other.id)
                && java.util.Objects.equals(this.displayName, other.displayName)
                && java.util.Objects.equals(this.instanceId, other.instanceId)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(
                        this.highestProblemSeverity, other.highestProblemSeverity)
                && java.util.Objects.equals(this.operatingSystem, other.operatingSystem)
                && java.util.Objects.equals(this.kernelVersion, other.kernelVersion)
                && java.util.Objects.equals(this.problemCount, other.problemCount)
                && java.util.Objects.equals(this.timeStarted, other.timeStarted)
                && java.util.Objects.equals(this.timeFinished, other.timeFinished)
                && java.util.Objects.equals(this.problems, other.problems)
                && java.util.Objects.equals(this.lifecycleState, other.lifecycleState)
                && java.util.Objects.equals(this.vendor, other.vendor)
                && super.equals(other);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = (result * PRIME) + (this.id == null ? 43 : this.id.hashCode());
        result = (result * PRIME) + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = (result * PRIME) + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result =
                (result * PRIME)
                        + (this.highestProblemSeverity == null
                                ? 43
                                : this.highestProblemSeverity.hashCode());
        result =
                (result * PRIME)
                        + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result =
                (result * PRIME)
                        + (this.kernelVersion == null ? 43 : this.kernelVersion.hashCode());
        result = (result * PRIME) + (this.problemCount == null ? 43 : this.problemCount.hashCode());
        result = (result * PRIME) + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = (result * PRIME) + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = (result * PRIME) + (this.problems == null ? 43 : this.problems.hashCode());
        result =
                (result * PRIME)
                        + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = (result * PRIME) + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = (result * PRIME) + super.hashCode();
        return result;
    }
}
