/**
 * Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.vulnerabilityscanning.model.*;
/**
 * <b>Example: </b>Click <a
 * href="https://docs.cloud.oracle.com/en-us/iaas/tools/java-sdk-examples/3.40.0/vulnerabilityscanning/ListContainerScanResultsExample.java.html"
 * target="_blank" rel="noopener noreferrer">here</a> to see how to use
 * ListContainerScanResultsRequest.
 */
@jakarta.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20210215")
public class ListContainerScanResultsRequest
        extends com.oracle.bmc.requests.BmcRequest<java.lang.Void> {

    /** The ID of the compartment in which to list resources. */
    private String compartmentId;

    /** The ID of the compartment in which to list resources. */
    public String getCompartmentId() {
        return compartmentId;
    }
    /** Repository name */
    private String repository;

    /** Repository name */
    public String getRepository() {
        return repository;
    }
    /** Image name */
    private String image;

    /** Image name */
    public String getImage() {
        return image;
    }
    /**
     * When listing with one or more filters, whether to include subcompartments for the
     * compartmentId being listed for. Does nothing if no filters are present in the query.
     */
    private Boolean areSubcompartmentsIncluded;

    /**
     * When listing with one or more filters, whether to include subcompartments for the
     * compartmentId being listed for. Does nothing if no filters are present in the query.
     */
    public Boolean getAreSubcompartmentsIncluded() {
        return areSubcompartmentsIncluded;
    }
    /** Parameter to filter by highestProblemSeverity for scan results */
    private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
            highestProblemSeverity;

    /** Parameter to filter by highestProblemSeverity for scan results */
    public com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
            getHighestProblemSeverity() {
        return highestProblemSeverity;
    }
    /**
     * Date and time on or after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    private java.util.Date timeStartedGreaterThanOrEqualTo;

    /**
     * Date and time on or after which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    public java.util.Date getTimeStartedGreaterThanOrEqualTo() {
        return timeStartedGreaterThanOrEqualTo;
    }
    /**
     * Date and time on or before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    private java.util.Date timeStartedLessThanOrEqualTo;

    /**
     * Date and time on or before which scans were started, as described in [RFC
     * 3339](https://tools.ietf.org/rfc/rfc3339)
     */
    public java.util.Date getTimeStartedLessThanOrEqualTo() {
        return timeStartedLessThanOrEqualTo;
    }
    /** The sort order to use, either 'ASC' or 'DESC'. */
    private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder;

    /** The sort order to use, either 'ASC' or 'DESC'. */
    public com.oracle.bmc.vulnerabilityscanning.model.SortOrder getSortOrder() {
        return sortOrder;
    }
    /**
     * The field to sort by. Only one sort order may be provided. Default order is descending. If no
     * value is specified timeStarted is default.
     */
    private com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSortBy sortBy;

    /**
     * The field to sort by. Only one sort order may be provided. Default order is descending. If no
     * value is specified timeStarted is default.
     */
    public com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSortBy getSortBy() {
        return sortBy;
    }
    /** The maximum number of items to return. */
    private Integer limit;

    /** The maximum number of items to return. */
    public Integer getLimit() {
        return limit;
    }
    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    private String page;

    /**
     * The page token representing the page at which to start retrieving results. This is usually
     * retrieved from a previous list call.
     */
    public String getPage() {
        return page;
    }
    /** The client request ID for tracing. */
    private String opcRequestId;

    /** The client request ID for tracing. */
    public String getOpcRequestId() {
        return opcRequestId;
    }
    /** A flag to return only the latest scan result of an instance. */
    private Boolean isLatestOnly;

    /** A flag to return only the latest scan result of an instance. */
    public Boolean getIsLatestOnly() {
        return isLatestOnly;
    }

    public static class Builder
            implements com.oracle.bmc.requests.BmcRequest.Builder<
                    ListContainerScanResultsRequest, java.lang.Void> {
        private com.oracle.bmc.http.client.RequestInterceptor invocationCallback = null;
        private com.oracle.bmc.retrier.RetryConfiguration retryConfiguration = null;

        /** The ID of the compartment in which to list resources. */
        private String compartmentId = null;

        /**
         * The ID of the compartment in which to list resources.
         *
         * @param compartmentId the value to set
         * @return this builder instance
         */
        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        /** Repository name */
        private String repository = null;

        /**
         * Repository name
         *
         * @param repository the value to set
         * @return this builder instance
         */
        public Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        /** Image name */
        private String image = null;

        /**
         * Image name
         *
         * @param image the value to set
         * @return this builder instance
         */
        public Builder image(String image) {
            this.image = image;
            return this;
        }

        /**
         * When listing with one or more filters, whether to include subcompartments for the
         * compartmentId being listed for. Does nothing if no filters are present in the query.
         */
        private Boolean areSubcompartmentsIncluded = null;

        /**
         * When listing with one or more filters, whether to include subcompartments for the
         * compartmentId being listed for. Does nothing if no filters are present in the query.
         *
         * @param areSubcompartmentsIncluded the value to set
         * @return this builder instance
         */
        public Builder areSubcompartmentsIncluded(Boolean areSubcompartmentsIncluded) {
            this.areSubcompartmentsIncluded = areSubcompartmentsIncluded;
            return this;
        }

        /** Parameter to filter by highestProblemSeverity for scan results */
        private com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
                highestProblemSeverity = null;

        /**
         * Parameter to filter by highestProblemSeverity for scan results
         *
         * @param highestProblemSeverity the value to set
         * @return this builder instance
         */
        public Builder highestProblemSeverity(
                com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity
                        highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            return this;
        }

        /**
         * Date and time on or after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        private java.util.Date timeStartedGreaterThanOrEqualTo = null;

        /**
         * Date and time on or after which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedGreaterThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeStartedGreaterThanOrEqualTo(
                java.util.Date timeStartedGreaterThanOrEqualTo) {
            this.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            return this;
        }

        /**
         * Date and time on or before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         */
        private java.util.Date timeStartedLessThanOrEqualTo = null;

        /**
         * Date and time on or before which scans were started, as described in [RFC
         * 3339](https://tools.ietf.org/rfc/rfc3339)
         *
         * @param timeStartedLessThanOrEqualTo the value to set
         * @return this builder instance
         */
        public Builder timeStartedLessThanOrEqualTo(java.util.Date timeStartedLessThanOrEqualTo) {
            this.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            return this;
        }

        /** The sort order to use, either 'ASC' or 'DESC'. */
        private com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder = null;

        /**
         * The sort order to use, either 'ASC' or 'DESC'.
         *
         * @param sortOrder the value to set
         * @return this builder instance
         */
        public Builder sortOrder(com.oracle.bmc.vulnerabilityscanning.model.SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         * If no value is specified timeStarted is default.
         */
        private com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSortBy sortBy = null;

        /**
         * The field to sort by. Only one sort order may be provided. Default order is descending.
         * If no value is specified timeStarted is default.
         *
         * @param sortBy the value to set
         * @return this builder instance
         */
        public Builder sortBy(
                com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /** The maximum number of items to return. */
        private Integer limit = null;

        /**
         * The maximum number of items to return.
         *
         * @param limit the value to set
         * @return this builder instance
         */
        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         */
        private String page = null;

        /**
         * The page token representing the page at which to start retrieving results. This is
         * usually retrieved from a previous list call.
         *
         * @param page the value to set
         * @return this builder instance
         */
        public Builder page(String page) {
            this.page = page;
            return this;
        }

        /** The client request ID for tracing. */
        private String opcRequestId = null;

        /**
         * The client request ID for tracing.
         *
         * @param opcRequestId the value to set
         * @return this builder instance
         */
        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        /** A flag to return only the latest scan result of an instance. */
        private Boolean isLatestOnly = null;

        /**
         * A flag to return only the latest scan result of an instance.
         *
         * @param isLatestOnly the value to set
         * @return this builder instance
         */
        public Builder isLatestOnly(Boolean isLatestOnly) {
            this.isLatestOnly = isLatestOnly;
            return this;
        }

        /**
         * Set the invocation callback for the request to be built.
         *
         * @param invocationCallback the invocation callback to be set for the request
         * @return this builder instance
         */
        public Builder invocationCallback(
                com.oracle.bmc.http.client.RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        /**
         * Set the retry configuration for the request to be built.
         *
         * @param retryConfiguration the retry configuration to be used for the request
         * @return this builder instance
         */
        public Builder retryConfiguration(
                com.oracle.bmc.retrier.RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        /**
         * Copy method to populate the builder with values from the given instance.
         *
         * @return this builder instance
         */
        public Builder copy(ListContainerScanResultsRequest o) {
            compartmentId(o.getCompartmentId());
            repository(o.getRepository());
            image(o.getImage());
            areSubcompartmentsIncluded(o.getAreSubcompartmentsIncluded());
            highestProblemSeverity(o.getHighestProblemSeverity());
            timeStartedGreaterThanOrEqualTo(o.getTimeStartedGreaterThanOrEqualTo());
            timeStartedLessThanOrEqualTo(o.getTimeStartedLessThanOrEqualTo());
            sortOrder(o.getSortOrder());
            sortBy(o.getSortBy());
            limit(o.getLimit());
            page(o.getPage());
            opcRequestId(o.getOpcRequestId());
            isLatestOnly(o.getIsLatestOnly());
            invocationCallback(o.getInvocationCallback());
            retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        /**
         * Build the instance of ListContainerScanResultsRequest as configured by this builder
         *
         * <p>Note that this method takes calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#buildWithoutInvocationCallback} does not.
         *
         * <p>This is the preferred method to build an instance.
         *
         * @return instance of ListContainerScanResultsRequest
         */
        public ListContainerScanResultsRequest build() {
            ListContainerScanResultsRequest request = buildWithoutInvocationCallback();
            request.setInvocationCallback(invocationCallback);
            request.setRetryConfiguration(retryConfiguration);
            return request;
        }

        /**
         * Build the instance of ListContainerScanResultsRequest as configured by this builder
         *
         * <p>Note that this method does not take calls to {@link
         * Builder#invocationCallback(com.oracle.bmc.http.client.RequestInterceptor)} into account,
         * while the method {@link Builder#build} does
         *
         * @return instance of ListContainerScanResultsRequest
         */
        public ListContainerScanResultsRequest buildWithoutInvocationCallback() {
            ListContainerScanResultsRequest request = new ListContainerScanResultsRequest();
            request.compartmentId = compartmentId;
            request.repository = repository;
            request.image = image;
            request.areSubcompartmentsIncluded = areSubcompartmentsIncluded;
            request.highestProblemSeverity = highestProblemSeverity;
            request.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            request.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            request.sortOrder = sortOrder;
            request.sortBy = sortBy;
            request.limit = limit;
            request.page = page;
            request.opcRequestId = opcRequestId;
            request.isLatestOnly = isLatestOnly;
            return request;
            // new ListContainerScanResultsRequest(compartmentId, repository, image,
            // areSubcompartmentsIncluded, highestProblemSeverity, timeStartedGreaterThanOrEqualTo,
            // timeStartedLessThanOrEqualTo, sortOrder, sortBy, limit, page, opcRequestId,
            // isLatestOnly);
        }
    }

    /**
     * Return an instance of {@link Builder} that allows you to modify request properties.
     *
     * @return instance of {@link Builder} that allows you to modify request properties.
     */
    public Builder toBuilder() {
        return new Builder()
                .compartmentId(compartmentId)
                .repository(repository)
                .image(image)
                .areSubcompartmentsIncluded(areSubcompartmentsIncluded)
                .highestProblemSeverity(highestProblemSeverity)
                .timeStartedGreaterThanOrEqualTo(timeStartedGreaterThanOrEqualTo)
                .timeStartedLessThanOrEqualTo(timeStartedLessThanOrEqualTo)
                .sortOrder(sortOrder)
                .sortBy(sortBy)
                .limit(limit)
                .page(page)
                .opcRequestId(opcRequestId)
                .isLatestOnly(isLatestOnly);
    }

    /**
     * Return a new builder for this request object.
     *
     * @return builder for the request object
     */
    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String toString() {
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",repository=").append(String.valueOf(this.repository));
        sb.append(",image=").append(String.valueOf(this.image));
        sb.append(",areSubcompartmentsIncluded=")
                .append(String.valueOf(this.areSubcompartmentsIncluded));
        sb.append(",highestProblemSeverity=").append(String.valueOf(this.highestProblemSeverity));
        sb.append(",timeStartedGreaterThanOrEqualTo=")
                .append(String.valueOf(this.timeStartedGreaterThanOrEqualTo));
        sb.append(",timeStartedLessThanOrEqualTo=")
                .append(String.valueOf(this.timeStartedLessThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf(this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf(this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLatestOnly=").append(String.valueOf(this.isLatestOnly));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListContainerScanResultsRequest)) {
            return false;
        }

        ListContainerScanResultsRequest other = (ListContainerScanResultsRequest) o;
        return super.equals(o)
                && java.util.Objects.equals(this.compartmentId, other.compartmentId)
                && java.util.Objects.equals(this.repository, other.repository)
                && java.util.Objects.equals(this.image, other.image)
                && java.util.Objects.equals(
                        this.areSubcompartmentsIncluded, other.areSubcompartmentsIncluded)
                && java.util.Objects.equals(
                        this.highestProblemSeverity, other.highestProblemSeverity)
                && java.util.Objects.equals(
                        this.timeStartedGreaterThanOrEqualTo, other.timeStartedGreaterThanOrEqualTo)
                && java.util.Objects.equals(
                        this.timeStartedLessThanOrEqualTo, other.timeStartedLessThanOrEqualTo)
                && java.util.Objects.equals(this.sortOrder, other.sortOrder)
                && java.util.Objects.equals(this.sortBy, other.sortBy)
                && java.util.Objects.equals(this.limit, other.limit)
                && java.util.Objects.equals(this.page, other.page)
                && java.util.Objects.equals(this.opcRequestId, other.opcRequestId)
                && java.util.Objects.equals(this.isLatestOnly, other.isLatestOnly);
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        result =
                (result * PRIME)
                        + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = (result * PRIME) + (this.repository == null ? 43 : this.repository.hashCode());
        result = (result * PRIME) + (this.image == null ? 43 : this.image.hashCode());
        result =
                (result * PRIME)
                        + (this.areSubcompartmentsIncluded == null
                                ? 43
                                : this.areSubcompartmentsIncluded.hashCode());
        result =
                (result * PRIME)
                        + (this.highestProblemSeverity == null
                                ? 43
                                : this.highestProblemSeverity.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedGreaterThanOrEqualTo == null
                                ? 43
                                : this.timeStartedGreaterThanOrEqualTo.hashCode());
        result =
                (result * PRIME)
                        + (this.timeStartedLessThanOrEqualTo == null
                                ? 43
                                : this.timeStartedLessThanOrEqualTo.hashCode());
        result = (result * PRIME) + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = (result * PRIME) + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = (result * PRIME) + (this.limit == null ? 43 : this.limit.hashCode());
        result = (result * PRIME) + (this.page == null ? 43 : this.page.hashCode());
        result = (result * PRIME) + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = (result * PRIME) + (this.isLatestOnly == null ? 43 : this.isLatestOnly.hashCode());
        return result;
    }
}
