/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeEntryMemory<K, V>
extends OMVRBTreeEntry<K, V> {
    protected int size = 1;
    protected int pageSize;
    protected K[] keys;
    protected V[] values;
    protected OMVRBTreeEntryMemory<K, V> left = null;
    protected OMVRBTreeEntryMemory<K, V> right = null;
    protected OMVRBTreeEntryMemory<K, V> parent;
    protected boolean color = false;

    protected OMVRBTreeEntryMemory(OMVRBTree<K, V> iTree) {
        super(iTree);
    }

    protected OMVRBTreeEntryMemory(OMVRBTree<K, V> iTree, K iKey, V iValue, OMVRBTreeEntryMemory<K, V> iParent) {
        super(iTree);
        this.setParent(iParent);
        this.pageSize = this.tree.getDefaultPageSize();
        this.keys = new Object[this.pageSize];
        this.keys[0] = iKey;
        this.values = new Object[this.pageSize];
        this.values[0] = iValue;
        this.init();
    }

    protected OMVRBTreeEntryMemory(OMVRBTreeEntryMemory<K, V> iParent, int iPosition) {
        super(iParent.getTree());
        this.pageSize = this.tree.getDefaultPageSize();
        this.keys = new Object[this.pageSize];
        this.values = new Object[this.pageSize];
        this.size = iParent.size - iPosition;
        System.arraycopy(iParent.keys, iPosition, this.keys, 0, this.size);
        System.arraycopy(iParent.values, iPosition, this.values, 0, this.size);
        Arrays.fill(iParent.keys, iPosition, iParent.size, null);
        Arrays.fill(iParent.values, iPosition, iParent.size, null);
        iParent.size = iPosition;
        this.setParent(iParent);
        this.init();
    }

    @Override
    protected void setColor(boolean iColor) {
        this.color = iColor;
    }

    @Override
    public boolean getColor() {
        return this.color;
    }

    @Override
    public void setLeft(OMVRBTreeEntry<K, V> iLeft) {
        this.left = (OMVRBTreeEntryMemory)iLeft;
        if (iLeft != null && iLeft.getParent() != this) {
            iLeft.setParent(this);
        }
    }

    @Override
    public OMVRBTreeEntry<K, V> getLeft() {
        return this.left;
    }

    @Override
    public void setRight(OMVRBTreeEntry<K, V> iRight) {
        this.right = (OMVRBTreeEntryMemory)iRight;
        if (iRight != null && iRight.getParent() != this) {
            iRight.setParent(this);
        }
    }

    @Override
    public OMVRBTreeEntry<K, V> getRight() {
        return this.right;
    }

    @Override
    public OMVRBTreeEntry<K, V> setParent(OMVRBTreeEntry<K, V> iParent) {
        this.parent = (OMVRBTreeEntryMemory)iParent;
        return iParent;
    }

    @Override
    public OMVRBTreeEntry<K, V> getParent() {
        return this.parent;
    }

    @Override
    public OMVRBTreeEntryMemory<K, V> getNextInMemory() {
        OMVRBTreeEntryMemory<K, V> t = this;
        OMVRBTreeEntryMemory<K, V> p = null;
        if (t.right != null) {
            p = t.right;
            while (p.left != null) {
                p = p.left;
            }
        } else {
            p = t.parent;
            while (p != null && t == p.right) {
                t = p;
                p = p.parent;
            }
        }
        return p;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    protected OMVRBTreeEntry<K, V> getLeftInMemory() {
        return this.left;
    }

    @Override
    protected OMVRBTreeEntry<K, V> getParentInMemory() {
        return this.parent;
    }

    @Override
    protected OMVRBTreeEntry<K, V> getRightInMemory() {
        return this.right;
    }

    @Override
    protected K getKeyAt(int iIndex) {
        return this.keys[iIndex];
    }

    @Override
    protected V getValueAt(int iIndex) {
        return this.values[iIndex];
    }

    @Override
    public V setValue(V value) {
        Object oldValue = this.getValue();
        this.values[this.tree.pageIndex] = value;
        return oldValue;
    }

    @Override
    protected void insert(int iPosition, K key, V value) {
        if (iPosition < this.size) {
            System.arraycopy(this.keys, iPosition, this.keys, iPosition + 1, this.size - iPosition);
            System.arraycopy(this.values, iPosition, this.values, iPosition + 1, this.size - iPosition);
        }
        this.keys[iPosition] = key;
        this.values[iPosition] = value;
        ++this.size;
    }

    @Override
    protected void remove() {
        if (this.tree.pageIndex != this.size - 1 && this.tree.pageIndex > -1) {
            System.arraycopy(this.keys, this.tree.pageIndex + 1, this.keys, this.tree.pageIndex, this.size - this.tree.pageIndex - 1);
            System.arraycopy(this.values, this.tree.pageIndex + 1, this.values, this.tree.pageIndex, this.size - this.tree.pageIndex - 1);
        }
        this.keys[this.size - 1] = null;
        this.values[this.size - 1] = null;
        --this.size;
        this.tree.pageIndex = 0;
    }

    @Override
    protected void copyFrom(OMVRBTreeEntry<K, V> iSource) {
        int i;
        OMVRBTreeEntryMemory source = (OMVRBTreeEntryMemory)iSource;
        this.keys = new Object[source.keys.length];
        for (i = 0; i < source.keys.length; ++i) {
            this.keys[i] = source.keys[i];
        }
        this.values = new Object[source.values.length];
        for (i = 0; i < source.values.length; ++i) {
            this.values[i] = source.values[i];
        }
        this.size = source.size;
    }

    public String toString() {
        if (this.keys == null) {
            return "?";
        }
        StringBuilder buffer = new StringBuilder();
        Character k = this.tree.pageIndex >= this.size ? Character.valueOf('?') : this.getKey();
        buffer.append(k);
        buffer.append(" (size=");
        buffer.append(this.size);
        if (this.size > 0) {
            buffer.append(" [");
            buffer.append(this.keys[0] != null ? this.keys[0] : "{lazy}");
            buffer.append('-');
            buffer.append(this.keys[this.size - 1] != null ? this.keys[this.size - 1] : "{lazy}");
            buffer.append(']');
        }
        buffer.append(')');
        return buffer.toString();
    }
}

