/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class OLuceneIndexType {
    public static Field createField(String fieldName, Object value, Field.Store store) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Long) {
                return new LongPoint(fieldName, new long[]{number.longValue()});
            }
            if (value instanceof Float) {
                return new FloatPoint(fieldName, new float[]{number.floatValue()});
            }
            if (value instanceof Double) {
                return new DoublePoint(fieldName, new double[]{number.doubleValue()});
            }
            return new IntPoint(fieldName, new int[]{number.intValue()});
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return new LongPoint(fieldName, new long[]{date.getTime()});
        }
        if (fieldName.equalsIgnoreCase("RID")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        if (fieldName.startsWith("_")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        return new TextField(fieldName, value.toString(), Field.Store.YES);
    }

    public static Query createExactQuery(OIndexDefinition index, Object key) {
        BooleanQuery query = null;
        if (key instanceof String) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            if (index.getFields().size() > 0) {
                for (String idx : index.getFields()) {
                    queryBuilder.add((Query)new TermQuery(new Term(idx, key.toString())), BooleanClause.Occur.SHOULD);
                }
            } else {
                queryBuilder.add((Query)new TermQuery(new Term("KEY", key.toString())), BooleanClause.Occur.SHOULD);
            }
            query = queryBuilder.build();
        } else if (key instanceof OCompositeKey) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            int i = 0;
            OCompositeKey keys = (OCompositeKey)key;
            for (String idx : index.getFields()) {
                String val = (String)keys.getKeys().get(i);
                queryBuilder.add((Query)new TermQuery(new Term(idx, val)), BooleanClause.Occur.MUST);
                ++i;
            }
            query = queryBuilder.build();
        }
        return query;
    }

    public static Query createQueryId(OIdentifiable value) {
        return new TermQuery(new Term("RID", value.getIdentity().toString()));
    }

    public static Query createDeleteQuery(OIdentifiable value, List<String> fields, Object key) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(OLuceneIndexType.createQueryId(value), BooleanClause.Occur.MUST);
        HashMap<String, String> values = new HashMap<String, String>();
        if (!(key instanceof OCompositeKey)) {
            values.put(fields.iterator().next(), key.toString());
        }
        for (String s : values.keySet()) {
            queryBuilder.add((Query)new TermQuery(new Term(s, ((String)values.get(s)).toLowerCase(Locale.ENGLISH))), BooleanClause.Occur.MUST);
        }
        return queryBuilder.build();
    }

    public static Sort sort(Query query, OIndexDefinition index, boolean ascSortOrder) {
        String key = (String)index.getFields().iterator().next();
        Number number = ((LegacyNumericRangeQuery)query).getMin();
        number = number != null ? (Number)number : (Number)((LegacyNumericRangeQuery)query).getMax();
        SortField.Type fieldType = SortField.Type.INT;
        if (number instanceof Long) {
            fieldType = SortField.Type.LONG;
        } else if (number instanceof Float) {
            fieldType = SortField.Type.FLOAT;
        } else if (number instanceof Double) {
            fieldType = SortField.Type.DOUBLE;
        }
        return new Sort(new SortField(key, fieldType, ascSortOrder));
    }
}

