/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.lucene.analyzer.OLuceneAnalyzerFactory;
import com.orientechnologies.lucene.builder.OLuceneIndexType;
import com.orientechnologies.lucene.engine.OLuceneDirectoryFactory;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.lucene.tx.OLuceneTxChangesMultiRid;
import com.orientechnologies.lucene.tx.OLuceneTxChangesSingleRid;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public abstract class OLuceneIndexEngineAbstract<V>
extends OSharedResourceAdaptiveExternal
implements OLuceneIndexEngine {
    public static final String RID = "RID";
    public static final String KEY = "KEY";
    public static final String STORED = "_STORED";
    public static final String OLUCENE_BASE_DIR = "luceneIndexes";
    protected final AtomicLong lastAccess;
    protected SearcherManager searcherManager;
    protected OIndexDefinition indexDefinition;
    protected String name;
    protected boolean isAutomatic;
    protected ControlledRealTimeReopenThread nrt;
    protected ODocument metadata;
    protected Version version;
    protected Map<String, Boolean> collectionFields = new HashMap<String, Boolean>();
    protected TimerTask commitTask;
    protected AtomicBoolean closed;
    protected OStorage storage;
    private volatile long reopenToken;
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;
    private Directory directory;
    private IndexWriter indexWriter;
    private long flushIndexInterval;
    private long closeAfterInterval;
    private long firstFlushAfter;

    public OLuceneIndexEngineAbstract(OStorage storage, String name) {
        super(true, 0, true);
        this.storage = storage;
        this.name = name;
        this.lastAccess = new AtomicLong(System.currentTimeMillis());
        this.closed = new AtomicBoolean(true);
    }

    protected void updateLastAccess() {
        this.lastAccess.set(System.currentTimeMillis());
    }

    protected abstract IndexWriter openIndexWriter(Directory var1) throws IOException;

    protected void addDocument(Document doc) {
        try {
            this.reopenToken = this.indexWriter.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on adding new document '%s' to Lucene index", (Throwable)e, new Object[]{doc});
        }
    }

    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
        this.indexDefinition = indexDefinition;
        this.isAutomatic = isAutomatic;
        this.metadata = metadata;
        OLuceneAnalyzerFactory fc = new OLuceneAnalyzerFactory();
        this.indexAnalyzer = fc.createAnalyzer(indexDefinition, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, metadata);
        this.queryAnalyzer = fc.createAnalyzer(indexDefinition, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, metadata);
        this.checkCollectionIndex(indexDefinition);
        this.flushIndexInterval = ((Integer)Optional.ofNullable(metadata.getProperty("flushIndexInterval")).orElse(10000)).longValue();
        this.closeAfterInterval = ((Integer)Optional.ofNullable(metadata.getProperty("closeAfterInterval")).orElse(20000)).longValue();
        this.firstFlushAfter = ((Integer)Optional.ofNullable(metadata.getProperty("firstFlushAfter")).orElse(20000)).longValue();
    }

    private void scheduleCommitTask() {
        this.commitTask = new TimerTask(){

            @Override
            public boolean cancel() {
                return super.cancel();
            }

            @Override
            public void run() {
                if (System.currentTimeMillis() - OLuceneIndexEngineAbstract.this.lastAccess.get() > OLuceneIndexEngineAbstract.this.closeAfterInterval) {
                    OLuceneIndexEngineAbstract.this.close();
                }
                if (!OLuceneIndexEngineAbstract.this.closed.get()) {
                    OLuceneIndexEngineAbstract.this.flush();
                }
            }
        };
        Orient.instance().scheduleTask(this.commitTask, this.firstFlushAfter, this.flushIndexInterval);
    }

    private void checkCollectionIndex(OIndexDefinition indexDefinition) {
        List fields = indexDefinition.getFields();
        OClass aClass = this.getDatabase().getMetadata().getSchema().getClass(indexDefinition.getClassName());
        for (String field : fields) {
            OProperty property = aClass.getProperty(field);
            if (property.getType().isEmbedded() && property.getLinkedType() != null) {
                this.collectionFields.put(field, true);
                continue;
            }
            this.collectionFields.put(field, false);
        }
    }

    protected void reOpen() throws IOException {
        if (this.indexWriter != null && this.indexWriter.isOpen() && this.directory instanceof RAMDirectory) {
            return;
        }
        this.open();
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private synchronized void open() throws IOException {
        if (!this.closed.get()) {
            return;
        }
        OLuceneDirectoryFactory directoryFactory = new OLuceneDirectoryFactory();
        this.directory = directoryFactory.createDirectory(this.getDatabase(), this.name, this.metadata);
        this.indexWriter = this.createIndexWriter(this.directory);
        this.searcherManager = new SearcherManager(this.indexWriter, true, true, null);
        this.reopenToken = 0L;
        this.startNRT();
        this.closed.set(false);
        this.flush();
        this.scheduleCommitTask();
    }

    private void startNRT() {
        this.nrt = new ControlledRealTimeReopenThread(this.indexWriter, (ReferenceManager)this.searcherManager, 60.0, 0.1);
        this.nrt.setDaemon(true);
        this.nrt.start();
    }

    private void closeNRT() {
        if (this.nrt != null) {
            this.nrt.interrupt();
            this.nrt.close();
        }
    }

    private void cancelCommitTask() {
        if (this.commitTask != null) {
            this.commitTask.cancel();
        }
    }

    private void closeSearchManager() throws IOException {
        if (this.searcherManager != null) {
            this.searcherManager.close();
        }
    }

    private void commitAndCloseWriter() throws IOException {
        if (this.indexWriter != null && this.indexWriter.isOpen()) {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.closed.set(true);
        }
    }

    protected abstract IndexWriter createIndexWriter(Directory var1) throws IOException;

    public void flush() {
        try {
            if (this.indexWriter != null && this.indexWriter.isOpen()) {
                this.indexWriter.commit();
            }
        }
        catch (Throwable e) {
            OLogManager.instance().error((Object)this, "Error on flushing Lucene index", e, new Object[0]);
        }
    }

    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata) {
    }

    public void delete() {
        OAbstractPaginatedStorage storageLocalAbstract;
        this.updateLastAccess();
        this.openIfClosed();
        if (this.indexWriter != null && this.indexWriter.isOpen()) {
            this.close();
        }
        if ((storageLocalAbstract = (OAbstractPaginatedStorage)this.storage.getUnderlying()) instanceof OLocalPaginatedStorage) {
            OLocalPaginatedStorage localAbstract = (OLocalPaginatedStorage)storageLocalAbstract;
            this.deleteIndexFolder(this.indexName(), localAbstract);
        }
    }

    private void deleteIndexFolder(String indexName, OLocalPaginatedStorage localAbstract) {
        File f = new File(this.getIndexPath(localAbstract, indexName));
        OFileUtils.deleteRecursively((File)f);
        f = new File(this.getIndexBasePath(localAbstract));
        OFileUtils.deleteFolderIfEmpty((File)f);
    }

    @Override
    public String indexName() {
        return this.name;
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract, String indexName) {
        return storageLocalAbstract.getStoragePath() + File.separator + OLUCENE_BASE_DIR + File.separator + indexName;
    }

    protected String getIndexBasePath(OLocalPaginatedStorage storageLocalAbstract) {
        return storageLocalAbstract.getStoragePath() + File.separator + OLUCENE_BASE_DIR;
    }

    @Override
    public abstract void onRecordAddedToResultSet(OLuceneQueryContext var1, OContextualRecordId var2, Document var3, ScoreDoc var4);

    @Override
    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    @Override
    public Analyzer queryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.updateLastAccess();
        this.openIfClosed();
        Query query = this.deleteQuery(key, value);
        if (query != null) {
            this.deleteDocument(query);
        }
        return true;
    }

    protected void deleteDocument(Query query) {
        try {
            this.reopenToken = this.indexWriter.deleteDocuments(new Query[]{query});
            if (!this.indexWriter.hasDeletions()) {
                OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)new OIndexException("Error deleting document"), new Object[]{query});
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting document by query '%s' to Lucene index", (Throwable)e, new Object[]{query});
        }
    }

    protected boolean isCollectionDelete() {
        boolean collectionDelete = false;
        for (Boolean aBoolean : this.collectionFields.values()) {
            collectionDelete = collectionDelete || aBoolean != false;
        }
        return collectionDelete;
    }

    protected void openIfClosed() {
        if (this.closed.get()) {
            OLogManager.instance().info((Object)this, "open closed index:: " + this.indexName(), new Object[0]);
            try {
                this.reOpen();
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "error while opening closed index:: " + this.indexName(), (Throwable)e, new Object[0]);
            }
        }
    }

    @Override
    public boolean isCollectionIndex() {
        return this.isCollectionDelete();
    }

    @Override
    public IndexSearcher searcher() {
        try {
            this.updateLastAccess();
            this.openIfClosed();
            this.nrt.waitForGeneration(this.reopenToken);
            IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
            return searcher;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on get searcher from Lucene index", (Throwable)e, new Object[0]);
            throw OException.wrapException((OException)new OLuceneIndexException("Error on get searcher from Lucene index"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sizeInTx(OLuceneTxChanges changes) {
        IndexSearcher searcher = this.searcher();
        try {
            IndexReader reader = searcher.getIndexReader();
            long l = changes == null ? (long)reader.numDocs() : (long)reader.numDocs() + changes.numDocs();
            return l;
        }
        finally {
            this.release(searcher);
        }
    }

    @Override
    public OLuceneTxChanges buildTxChanges() throws IOException {
        if (this.isCollectionDelete()) {
            return new OLuceneTxChangesMultiRid(this, this.createIndexWriter((Directory)new RAMDirectory()), this.createIndexWriter((Directory)new RAMDirectory()));
        }
        return new OLuceneTxChangesSingleRid(this, this.createIndexWriter((Directory)new RAMDirectory()), this.createIndexWriter((Directory)new RAMDirectory()));
    }

    @Override
    public Query deleteQuery(Object key, OIdentifiable value) {
        this.updateLastAccess();
        this.openIfClosed();
        if (this.isCollectionDelete()) {
            return OLuceneIndexType.createDeleteQuery(value, this.indexDefinition.getFields(), key);
        }
        return OLuceneIndexType.createQueryId(value);
    }

    public void deleteWithoutLoad(String indexName) {
        this.internalDelete(indexName);
    }

    protected void internalDelete(String indexName) {
        OAbstractPaginatedStorage storageLocalAbstract;
        if (this.indexWriter != null && this.indexWriter.isOpen()) {
            this.close();
        }
        if ((storageLocalAbstract = (OAbstractPaginatedStorage)this.storage.getUnderlying()) instanceof OLocalPaginatedStorage) {
            OLocalPaginatedStorage localAbstract = (OLocalPaginatedStorage)storageLocalAbstract;
            this.deleteIndexFolder(indexName, localAbstract);
        }
    }

    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties) {
    }

    public void clear() {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            this.reopenToken = this.indexWriter.deleteAll();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on clearing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public synchronized void close() {
        if (this.closed.get()) {
            return;
        }
        try {
            this.closeNRT();
            this.cancelCommitTask();
            this.closeSearchManager();
            this.commitAndCloseWriter();
        }
        catch (Throwable e) {
            OLogManager.instance().error((Object)this, "Error on closing Lucene index", e, new Object[0]);
        }
    }

    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public OIndexKeyCursor keyCursor() {
        throw new UnsupportedOperationException("Cannot iterate over a lucene index");
    }

    public long size(OIndexEngine.ValuesTransformer transformer) {
        return this.sizeInTx(null);
    }

    @Override
    public void release(IndexSearcher searcher) {
        this.updateLastAccess();
        this.openIfClosed();
        try {
            this.searcherManager.release((Object)searcher);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on releasing index searcher  of Lucene index", (Throwable)e, new Object[0]);
        }
    }

    public int getVersion() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean acquireAtomicExclusiveLock(Object key) {
        return true;
    }

    public String getIndexNameByKey(Object key) {
        return this.name;
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract) {
        return this.getIndexPath(storageLocalAbstract, this.name);
    }

    protected Field.Store isToStore(String f) {
        return this.collectionFields.get(f) != false ? Field.Store.YES : Field.Store.NO;
    }

    public boolean isFrozen() {
        return this.closed.get();
    }

    public void freeze(boolean throwException) {
        try {
            this.closeNRT();
            this.cancelCommitTask();
            this.commitAndCloseWriter();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on freezing Lucene index:: " + this.indexName(), (Throwable)e, new Object[0]);
        }
    }

    public void release() {
        try {
            this.close();
            this.reOpen();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on releasing Lucene index:: " + this.indexName(), (Throwable)e, new Object[0]);
        }
    }
}

