/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.orient.core.command.OCommandContext;
import java.util.HashMap;
import org.apache.lucene.search.TopDocs;

public class OLuceneIndexEngineUtils {
    public static void sendTotalHits(String indexName, OCommandContext context, int totalHits) {
        if (context != null) {
            if (context.getVariable("totalHits") == null) {
                context.setVariable("totalHits", (Object)totalHits);
            } else {
                context.setVariable("totalHits", null);
            }
            context.setVariable((indexName + ".totalHits").replace(".", "_"), (Object)totalHits);
        }
    }

    public static void sendLookupTime(String indexName, OCommandContext context, final TopDocs docs, final Integer limit, long startFetching) {
        if (context != null) {
            final long finalTime = System.currentTimeMillis() - startFetching;
            context.setVariable((indexName + ".lookupTime").replace(".", "_"), (Object)new HashMap<String, Object>(){
                {
                    this.put("limit", limit);
                    this.put("totalTime", finalTime);
                    this.put("totalHits", docs.totalHits);
                    this.put("returnedHits", docs.scoreDocs.length);
                    if (!Float.isNaN(docs.getMaxScore())) {
                        this.put("maxScore", Float.valueOf(docs.getMaxScore()));
                    }
                }
            });
        }
    }
}

