/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.functions;

import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.functions.OIndexableSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class OLuceneSearchMoreLikeThisFunction
extends OSQLFunctionAbstract
implements OIndexableSQLFunction {
    public static final String NAME = "search_more";

    public OLuceneSearchMoreLikeThisFunction() {
        super(NAME, 1, 2);
    }

    public String getName() {
        return NAME;
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] params, OCommandContext ctx) {
        throw new OLuceneIndexException("SEARCH_MORE can't be executed by document");
    }

    public String getSyntax() {
        return "SEARCH_MORE( [rids], [ metdatada {} ] )";
    }

    public Iterable<OIdentifiable> searchFromTarget(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx);
        if (index == null) {
            return Collections.emptySet();
        }
        IndexSearcher searcher = index.searcher();
        OExpression expression = args[0];
        ODocument metadata = this.parseMetadata(args);
        List<String> ridsAsString = this.parseRids(ctx, expression);
        List<ORecord> others = ridsAsString.stream().map(rid -> {
            ORecordId recordId = new ORecordId();
            recordId.fromString(rid);
            return recordId;
        }).map(id -> id.getRecord()).collect(Collectors.toList());
        MoreLikeThis mlt = this.buildMoreLikeThis(index, searcher, metadata);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        this.excludeOtherFromResults(ridsAsString, queryBuilder);
        this.addLikeQueries(others, mlt, queryBuilder);
        BooleanQuery mltQuery = queryBuilder.build();
        Object luceneResultSet = index.get(new OLuceneKeyAndMetadata(new OLuceneCompositeKey(Arrays.asList(mltQuery.toString())).setContext(ctx), metadata));
        return luceneResultSet;
    }

    private List<String> parseRids(OCommandContext ctx, OExpression expression) {
        Iterator iter;
        Object expResult = expression.execute((OIdentifiable)null, ctx);
        if (expResult instanceof OIdentifiable) {
            return Collections.singletonList(((OIdentifiable)expResult).getIdentity().toString());
        }
        if (expResult instanceof Iterable) {
            iter = ((Iterable)expResult).iterator();
        } else if (expResult instanceof Iterator) {
            iter = (Iterator)expResult;
        } else {
            return Collections.emptyList();
        }
        ArrayList<String> rids = new ArrayList<String>();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof OResult) {
                Object val;
                if (((OResult)item).isElement()) {
                    rids.add(((ORID)((OResult)item).getIdentity().get()).toString());
                    continue;
                }
                Set properties = ((OResult)item).getPropertyNames();
                if (properties.size() != 1 || !((val = ((OResult)item).getProperty((String)properties.iterator().next())) instanceof OIdentifiable)) continue;
                rids.add(((OIdentifiable)val).getIdentity().toString());
                continue;
            }
            if (!(item instanceof OIdentifiable)) continue;
            rids.add(((OIdentifiable)item).getIdentity().toString());
        }
        return rids;
    }

    private ODocument parseMetadata(OExpression[] args) {
        ODocument metadata = new ODocument();
        if (args.length == 2) {
            metadata.fromJSON(args[1].toString());
        }
        return metadata;
    }

    private MoreLikeThis buildMoreLikeThis(OLuceneFullTextIndex index, IndexSearcher searcher, ODocument metadata) {
        MoreLikeThis mlt = new MoreLikeThis(searcher.getIndexReader());
        mlt.setAnalyzer(index.queryAnalyzer());
        mlt.setFieldNames(((List)Optional.ofNullable(metadata.getProperty("fieldNames")).orElse(index.getDefinition().getFields())).toArray(new String[0]));
        mlt.setMaxQueryTerms(((Integer)Optional.ofNullable(metadata.getProperty("maxQueryTerms")).orElse(25)).intValue());
        mlt.setMinTermFreq(((Integer)Optional.ofNullable(metadata.getProperty("minTermFreq")).orElse(2)).intValue());
        mlt.setMaxDocFreq(((Integer)Optional.ofNullable(metadata.getProperty("maxDocFreq")).orElse(Integer.MAX_VALUE)).intValue());
        mlt.setMinDocFreq(((Integer)Optional.ofNullable(metadata.getProperty("minDocFreq")).orElse(Integer.MAX_VALUE)).intValue());
        mlt.setBoost(((Boolean)Optional.ofNullable(metadata.getProperty("boost")).orElse(false)).booleanValue());
        mlt.setBoostFactor(((Float)Optional.ofNullable(metadata.getProperty("boostFactor")).orElse(Float.valueOf(1.0f))).floatValue());
        mlt.setMaxWordLen(((Integer)Optional.ofNullable(metadata.getProperty("maxWordLen")).orElse(0)).intValue());
        mlt.setMinWordLen(((Integer)Optional.ofNullable(metadata.getProperty("minWordLen")).orElse(0)).intValue());
        mlt.setMaxNumTokensParsed(((Integer)Optional.ofNullable(metadata.getProperty("maxNumTokensParsed")).orElse(5000)).intValue());
        mlt.setStopWords((Set)Optional.ofNullable(metadata.getProperty("stopWords")).orElse(MoreLikeThis.DEFAULT_STOP_WORDS));
        return mlt;
    }

    private void addLikeQueries(List<ORecord> others, MoreLikeThis mlt, BooleanQuery.Builder queryBuilder) {
        others.stream().map(or -> (OElement)or.load()).forEach(element -> Arrays.stream(mlt.getFieldNames()).forEach(fieldName -> {
            String property = (String)element.getProperty(fieldName);
            try {
                Query fieldQuery = mlt.like(fieldName, new Reader[]{new StringReader(property)});
                if (!fieldQuery.toString().isEmpty()) {
                    queryBuilder.add(fieldQuery, BooleanClause.Occur.SHOULD);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
    }

    private void excludeOtherFromResults(List<String> ridsAsString, BooleanQuery.Builder queryBuilder) {
        ridsAsString.stream().forEach(rid -> queryBuilder.add((Query)new TermQuery(new Term("RID", QueryParser.escape((String)rid))), BooleanClause.Occur.MUST_NOT));
    }

    private OLuceneFullTextIndex searchForIndex(OFromClause target, OCommandContext ctx) {
        OFromItem item = target.getItem();
        String className = item.getIdentifier().getStringValue();
        return this.searchForIndex(ctx, className);
    }

    private OLuceneFullTextIndex searchForIndex(OCommandContext ctx, String className) {
        OMetadata dbMetadata = ctx.getDatabase().activateOnCurrentThread().getMetadata();
        List indices = dbMetadata.getSchema().getClass(className).getIndexes().stream().filter(idx -> idx instanceof OLuceneFullTextIndex).map(idx -> (OLuceneFullTextIndex)idx).collect(Collectors.toList());
        if (indices.size() > 1) {
            throw new IllegalArgumentException("too many full-text indices on given class: " + className);
        }
        return indices.size() == 0 ? null : (OLuceneFullTextIndex)indices.get(0);
    }

    public long estimate(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx);
        if (index != null) {
            return index.getSize();
        }
        return 0L;
    }

    public boolean canExecuteInline(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return false;
    }

    public boolean allowsIndexedExecution(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        OLuceneFullTextIndex index = this.searchForIndex(target, ctx);
        return index != null;
    }

    public boolean shouldExecuteAfterSearch(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return false;
    }
}

