/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.lucene.OLuceneTxOperations;
import com.orientechnologies.lucene.collections.OLuceneIndexCursor;
import com.orientechnologies.lucene.collections.OLuceneResultSet;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

public class OLuceneIndexNotUnique
extends OIndexAbstract<Set<OIdentifiable>>
implements OLuceneIndex {
    public OLuceneIndexNotUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, valueContainerAlgorithm, metadata, version, (OStorage)storage);
    }

    public long rebuild(OProgressListener iProgressListener) {
        return super.rebuild(iProgressListener);
    }

    public boolean remove(Object key, OIdentifiable value) {
        if (key != null) {
            OBasicTransaction transaction = this.getDatabase().getMicroOrRegularTransaction();
            if (transaction.isActive()) {
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, this.encodeKey(key), value);
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                transactionChanges.remove(key, value);
                return true;
            }
            while (true) {
                try {
                    return (Boolean)this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.remove(key, value);
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public boolean remove(Object key) {
        return super.remove(key);
    }

    public OIndexAbstract<Set<OIdentifiable>> removeCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
                this.remove("_CLUSTER:" + this.storage.getClusterByName(iClusterName).getId());
            }
            OLuceneIndexNotUnique oLuceneIndexNotUnique = this;
            return oLuceneIndexNotUnique;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.NonUnique);
    }

    public Object getCollatingValue(Object key) {
        return key;
    }

    protected void commitSnapshot(Map<Object, Object> snapshot) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                    OLuceneTxOperations operations;
                    Object key;
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                        key = snapshotEntry.getKey();
                        operations = (OLuceneTxOperations)snapshotEntry.getValue();
                        for (OIdentifiable oIdentifiable : operations.removed) {
                            indexEngine.remove(this.decodeKey(key), oIdentifiable);
                        }
                    }
                    for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                        key = snapshotEntry.getKey();
                        operations = (OLuceneTxOperations)snapshotEntry.getValue();
                        indexEngine.put(this.decodeKey(key), operations.added);
                    }
                    OBasicTransaction transaction = this.getDatabase().getMicroOrRegularTransaction();
                    this.resetTransactionChanges(transaction);
                    return null;
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object decodeKey(Object key) {
        return key;
    }

    private void resetTransactionChanges(OBasicTransaction transaction) {
        transaction.setCustomData(this.getName(), null);
    }

    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.added.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.removed.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void clearSnapshot(OIndexAbstract.IndexTxSnapshot indexTxSnapshot) {
        indexTxSnapshot.clear = true;
        indexTxSnapshot.indexSnapshot.clear();
    }

    protected void onIndexEngineChange(int indexId) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, false, indexId, engine -> {
                    OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                    oIndexEngine.init(this.getName(), this.getType(), this.getDefinition(), this.isAutomatic(), this.getMetadata());
                    return null;
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object encodeKey(Object key) {
        return key;
    }

    private OLuceneTxChanges getTransactionChanges(OBasicTransaction transaction) {
        OLuceneTxChanges changes = (OLuceneTxChanges)transaction.getCustomData(this.getName());
        if (changes == null) {
            while (true) {
                try {
                    changes = (OLuceneTxChanges)this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        try {
                            return indexEngine.buildTxChanges();
                        }
                        catch (IOException e) {
                            throw OException.wrapException((OException)new OIndexException("Cannot get searcher from index " + this.getName()), (Throwable)e);
                        }
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            transaction.setCustomData(this.getName(), (Object)changes);
        }
        return changes;
    }

    public OLuceneIndexNotUnique create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OLuceneIndexNotUnique)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    public Set<OIdentifiable> get(Object key) {
        OBasicTransaction transaction = this.getDatabase().getMicroOrRegularTransaction();
        if (transaction.isActive()) {
            while (true) {
                try {
                    return (Set)this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.getInTx(key, this.getTransactionChanges(transaction));
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        while (true) {
            try {
                return (Set)this.storage.getIndexValue(this.indexId, key);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OLuceneIndexNotUnique put(Object key, OIdentifiable singleValue) {
        if (key != null) {
            OBasicTransaction transaction = this.getDatabase().getMicroOrRegularTransaction();
            if (transaction.isActive()) {
                Document luceneDoc;
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.PUT, this.encodeKey(key), singleValue);
                while (true) {
                    try {
                        luceneDoc = (Document)this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                            OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                            return oIndexEngine.buildDocument(key, singleValue);
                        });
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                transactionChanges.put(key, singleValue, luceneDoc);
            } else {
                while (true) {
                    try {
                        this.storage.updateIndexEntry(this.indexId, key, () -> Arrays.asList(singleValue));
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    public long getSize() {
        while (true) {
            try {
                return (Long)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Long>(){

                    public Long callEngine(OIndexEngine engine) {
                        OBasicTransaction transaction = OLuceneIndexNotUnique.this.getDatabase().getMicroOrRegularTransaction();
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.sizeInTx(OLuceneIndexNotUnique.this.getTransactionChanges(transaction));
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public long getKeySize() {
        return 0L;
    }

    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        String query = (String)keys.stream().findFirst().map(k -> (OCompositeKey)k).map(ck -> ck.getKeys()).orElse(Arrays.asList("q=*:*")).get(0);
        OLuceneResultSet identifiables = (OLuceneResultSet)this.get(query);
        return new OLuceneIndexCursor(identifiables, query);
    }

    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor cursor() {
        while (true) {
            try {
                return this.storage.getIndexCursor(this.indexId, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor descCursor() {
        while (true) {
            try {
                return this.storage.getIndexCursor(this.indexId, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public IndexSearcher searcher() {
        while (true) {
            try {
                return (IndexSearcher)this.storage.callIndexEngine(false, false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.searcher();
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean canBeUsedInEqualityOperators() {
        return false;
    }
}

