/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.operator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.collections.OLuceneCompositeKey;
import com.orientechnologies.lucene.index.OLuceneFullTextIndex;
import com.orientechnologies.lucene.operator.OLuceneOperatorUtil;
import com.orientechnologies.lucene.query.OLuceneKeyAndMetadata;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;

public class OLuceneTextOperator
extends OQueryTargetOperator {
    public static final String MEMORY_INDEX = "_memoryIndex";

    public OLuceneTextOperator() {
        this("LUCENE", 5, false);
    }

    public OLuceneTextOperator(String iKeyword, int iPrecedence, boolean iLogical) {
        super(iKeyword, iPrecedence, iLogical);
    }

    protected static ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_OPERATOR;
    }

    public OIndexSearchResult getOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        return OLuceneOperatorUtil.buildOIndexSearchResult(iSchemaClass, iCondition, iIndexSearchResults, context);
    }

    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        if (!index.getType().toLowerCase().contains("fulltext")) {
            return null;
        }
        if (index.getAlgorithm() == null || !index.getAlgorithm().toLowerCase().contains("lucene")) {
            return null;
        }
        Set indexResult = (Set)index.get((Object)new OLuceneKeyAndMetadata(new OLuceneCompositeKey(keyParams).setContext(iContext), new ODocument()));
        if (indexResult == null) {
            return new OIndexCursorSingleValue((OIdentifiable)indexResult, (Object)new OLuceneCompositeKey(keyParams));
        }
        return new OIndexCursorCollectionValue((Collection)indexResult, (Object)new OLuceneCompositeKey(keyParams));
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public boolean canBeMerged() {
        return false;
    }

    public Collection<OIdentifiable> filterRecords(ODatabase<?> iRecord, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        return null;
    }

    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        OLuceneFullTextIndex index = this.involvedIndex(iRecord, iCurrentResult, iCondition, iLeft, iRight);
        if (index == null) {
            throw new OCommandExecutionException("Cannot evaluate lucene condition without index configuration.");
        }
        MemoryIndex memoryIndex = (MemoryIndex)iContext.getVariable(MEMORY_INDEX);
        if (memoryIndex == null) {
            memoryIndex = new MemoryIndex();
            iContext.setVariable(MEMORY_INDEX, (Object)memoryIndex);
        }
        memoryIndex.reset();
        try {
            if (iLeft instanceof List && index.isCollectionIndex()) {
                return this.matchCollectionIndex((List)iLeft, iRight, index, memoryIndex);
            }
            return this.matchField(iLeft, iRight, index, memoryIndex);
        }
        catch (ParseException e) {
            OLogManager.instance().error((Object)this, "error occurred while building query", (Throwable)e, new Object[0]);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "error occurred while building memory index", (Throwable)e, new Object[0]);
        }
        return null;
    }

    private boolean matchField(Object iLeft, Object iRight, OLuceneFullTextIndex index, MemoryIndex memoryIndex) throws IOException, ParseException {
        for (IndexableField field : index.buildDocument(iLeft).getFields()) {
            memoryIndex.addField(field, index.indexAnalyzer());
        }
        return memoryIndex.search(index.buildQuery(iRight)) > 0.0f;
    }

    private boolean matchCollectionIndex(List iLeft, Object iRight, OLuceneFullTextIndex index, MemoryIndex memoryIndex) throws IOException, ParseException {
        boolean match = false;
        List<Object> collections = this.transformInput(iLeft, iRight, index, memoryIndex);
        for (Object collection : collections) {
            memoryIndex.reset();
            if (!(match = match || this.matchField(collection, iRight, index, memoryIndex))) continue;
            break;
        }
        return match;
    }

    private List<Object> transformInput(List iLeft, Object iRight, OLuceneFullTextIndex index, MemoryIndex memoryIndex) {
        Integer collectionIndex = this.getCollectionIndex(iLeft);
        if (collectionIndex == -1) {
            return iLeft;
        }
        if (collectionIndex > 1) {
            throw new UnsupportedOperationException("Index of collection cannot be > 1");
        }
        Collection collection = (Collection)iLeft.get(collectionIndex);
        if (iLeft.size() == 1) {
            return new ArrayList<Object>(collection);
        }
        ArrayList<Object> transformed = new ArrayList<Object>(collection.size());
        for (Object o : collection) {
            ArrayList objects = new ArrayList();
            if (collectionIndex == 0) {
                objects.add(o);
                objects.add(iLeft.get(1));
            } else {
                objects.add(iLeft.get(0));
                objects.add(o);
            }
            transformed.add(objects);
        }
        return transformed;
    }

    private Integer getCollectionIndex(List iLeft) {
        int i = 0;
        for (Object o : iLeft) {
            if (o instanceof Collection) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected OLuceneFullTextIndex involvedIndex(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        ODocument doc = (ODocument)iRecord.getRecord();
        OClass cls = OLuceneTextOperator.getDatabase().getMetadata().getSchema().getClass(doc.getClassName());
        if (this.isChained(iCondition.getLeft())) {
            OSQLFilterItemField chained = (OSQLFilterItemField)iCondition.getLeft();
            OSQLFilterItemField.FieldChain fieldChain = chained.getFieldChain();
            OClass oClass = cls;
            for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
                oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
            }
            if (oClass != null) {
                cls = oClass;
            }
        }
        Set classInvolvedIndexes = cls.getInvolvedIndexes(this.fields(iCondition));
        OLuceneFullTextIndex idx = null;
        for (OIndex classInvolvedIndex : classInvolvedIndexes) {
            if (!(classInvolvedIndex.getInternal() instanceof OLuceneFullTextIndex)) continue;
            idx = (OLuceneFullTextIndex)classInvolvedIndex.getInternal();
            break;
        }
        return idx;
    }

    private boolean isChained(Object left) {
        if (left instanceof OSQLFilterItemField) {
            OSQLFilterItemField field = (OSQLFilterItemField)left;
            return field.isFieldChain();
        }
        return false;
    }

    protected Collection<String> fields(OSQLFilterCondition iCondition) {
        Object left = iCondition.getLeft();
        if (left instanceof String) {
            String fName = (String)left;
            return Arrays.asList(fName);
        }
        if (left instanceof Collection) {
            Collection f = (Collection)left;
            ArrayList<String> fields = new ArrayList<String>();
            for (OSQLFilterItemField field : f) {
                fields.add(field.toString());
            }
            return fields;
        }
        if (left instanceof OSQLFilterItemField) {
            OSQLFilterItemField fName = (OSQLFilterItemField)left;
            if (fName.isFieldChain()) {
                int itemCount = fName.getFieldChain().getItemCount();
                return Arrays.asList(fName.getFieldChain().getItemName(itemCount - 1));
            }
            return Arrays.asList(fName.toString());
        }
        return Collections.emptyList();
    }
}

