/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.parser;

import com.orientechnologies.lucene.builder.OLuceneDateTools;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;

public class OLuceneMultiFieldQueryParser
extends MultiFieldQueryParser {
    private final Map<String, OType> types;

    public OLuceneMultiFieldQueryParser(Map<String, OType> types, String[] fields, Analyzer analyzer) {
        this(types, fields, analyzer, null);
    }

    public OLuceneMultiFieldQueryParser(Map<String, OType> types, String[] fields, Analyzer analyzer, Map<String, Float> boosts) {
        super(fields, analyzer, boosts);
        this.types = types;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Optional<Query> query = this.getQuery(field, queryText, queryText, true, true);
        return query.orElse(super.getFieldQuery(field, queryText, slop));
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        Optional<Query> query = this.getQuery(field, queryText, queryText, true, true);
        return query.orElse(super.getFieldQuery(field, queryText, quoted));
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Optional<Query> query = this.getQuery(field, part1, part2, startInclusive, endInclusive);
        return query.orElse(super.getRangeQuery(field, part1, part2, startInclusive, endInclusive));
    }

    private Optional<Query> getQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        int start = 0;
        int end = 0;
        if (!startInclusive) {
            start = 1;
        }
        if (!endInclusive) {
            end = -1;
        }
        if (this.types.containsKey(field)) {
            switch (this.types.get(field)) {
                case LONG: {
                    return Optional.of(LongPoint.newRangeQuery((String)field, (long)Math.addExact(Long.parseLong(part1), (long)start), (long)Math.addExact(Long.parseLong(part2), (long)end)));
                }
                case INTEGER: {
                    return Optional.of(IntPoint.newRangeQuery((String)field, (int)Math.addExact(Integer.parseInt(part1), start), (int)Math.addExact(Integer.parseInt(part2), end)));
                }
                case DOUBLE: {
                    return Optional.of(DoublePoint.newRangeQuery((String)field, (double)(Double.parseDouble(part1) - (double)start), (double)(Double.parseDouble(part2) + (double)end)));
                }
                case DATE: 
                case DATETIME: {
                    try {
                        return Optional.of(LongPoint.newRangeQuery((String)field, (long)Math.addExact(OLuceneDateTools.stringToTime(part1), (long)start), (long)Math.addExact(OLuceneDateTools.stringToTime(part2), (long)end)));
                    }
                    catch (java.text.ParseException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
            }
        }
        return Optional.empty();
    }
}

