/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed;

import com.orientechnologies.orient.client.binary.OChannelBinarySynchClient;
import com.orientechnologies.orient.client.remote.OBinaryRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectResponse;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ORemoteServerAvailabilityCheck;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ORemoteServerChannel {
    private final ORemoteServerAvailabilityCheck check;
    private final String url;
    private final String remoteHost;
    private final int remotePort;
    private final String userName;
    private final String userPassword;
    private final String server;
    private OChannelBinarySynchClient channel;
    private int protocolVersion;
    private ODistributedRequest prevRequest;
    private ODistributedResponse prevResponse;
    private String localNodeName;
    private static final int MAX_RETRY = 3;
    private static final String CLIENT_TYPE = "OrientDB Server";
    private static final boolean COLLECT_STATS = false;
    private int sessionId = -1;
    private byte[] sessionToken;
    private OContextConfiguration contextConfig = new OContextConfiguration();
    private Date createdOn = new Date();
    private volatile int totalConsecutiveErrors = 0;
    private static final int MAX_CONSECUTIVE_ERRORS = 10;
    private ExecutorService executor;

    public ORemoteServerChannel(ORemoteServerAvailabilityCheck check, String localNodeName, String iServer, String iURL, String user, String passwd, int currentProtocolVersion) throws IOException {
        this.check = check;
        this.localNodeName = localNodeName;
        this.server = iServer;
        this.url = iURL;
        this.userName = user;
        this.userPassword = passwd;
        int sepPos = iURL.lastIndexOf(":");
        this.remoteHost = iURL.substring(0, sepPos);
        this.remotePort = Integer.parseInt(iURL.substring(sepPos + 1));
        this.protocolVersion = currentProtocolVersion;
        RejectedExecutionHandler reject = (task, executor) -> {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10), reject);
        this.connect();
    }

    public int getDistributedProtocolVersion() {
        return this.protocolVersion;
    }

    public void sendBinaryRequest(OBinaryRequest request) {
        this.executor.execute(() -> this.networkOperation(request.getCommand(), () -> {
            request.write((OChannelDataOutput)this.channel, null);
            this.channel.flush();
            return null;
        }, "Cannot send distributed request " + request.getClass(), 3, true));
    }

    public void sendRequest(ODistributedRequest request) {
        this.executor.execute(() -> this.networkOperation((byte)120, () -> {
            request.toStream(this.channel.getDataOutput());
            this.channel.flush();
            return null;
        }, "Cannot send distributed request " + request.getClass(), 3, true));
        this.prevRequest = request;
    }

    public void sendResponse(ODistributedResponse response) {
        this.executor.execute(() -> this.networkOperation((byte)121, () -> {
            response.toStream(this.channel.getDataOutput());
            this.channel.flush();
            return null;
        }, "Cannot send response back to the sender node '" + response.getSenderNodeName() + "' " + response.getClass(), 3, true));
        this.prevResponse = response;
    }

    public void connect() throws IOException {
        this.channel = new OChannelBinarySynchClient(this.remoteHost, this.remotePort, null, this.contextConfig, 37);
        this.networkOperation((byte)122, () -> {
            ODistributedConnectRequest request = new ODistributedConnectRequest(this.protocolVersion, this.userName, this.userPassword);
            request.write((OChannelDataOutput)this.channel, null);
            this.channel.flush();
            this.channel.beginResponse(true);
            ODistributedConnectResponse response = request.createResponse();
            response.read((OChannelDataInput)this.channel, null);
            this.sessionId = response.getSessionId();
            this.sessionToken = response.getToken();
            this.protocolVersion = response.getDistributedProtocolVersion();
            return null;
        }, "Cannot connect to the remote server '" + this.url + "'", 3, false);
    }

    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.networkClose();
    }

    private void networkClose() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.sessionId = -1;
        this.sessionToken = null;
    }

    protected synchronized <T> T networkOperation(byte operationId, OStorageRemoteOperation<T> operation, String errorMessage, int maxRetry, boolean autoReconnect) {
        Exception lastException = null;
        for (int retry = 1; retry <= maxRetry && this.totalConsecutiveErrors < 10; ++retry) {
            try {
                this.channel.setWaitResponseTimeout();
                this.channel.beginRequest(operationId, this.sessionId, this.sessionToken);
                T result = operation.execute();
                this.totalConsecutiveErrors = 0;
                return result;
            }
            catch (Exception e) {
                lastException = e;
                this.handleNewError();
                this.networkClose();
                if (!autoReconnect || !this.check.isNodeAvailable(this.server)) break;
                if (retry > 1) {
                    try {
                        Thread.sleep(100 * (retry * 2));
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
                try {
                    this.connect();
                    this.totalConsecutiveErrors = 0;
                }
                catch (IOException e1) {
                    lastException = e1;
                    this.handleNewError();
                }
                continue;
            }
        }
        if (lastException == null) {
            this.handleNewError();
        }
        return null;
    }

    public String getServer() {
        return this.server;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    private void handleNewError() {
        ++this.totalConsecutiveErrors;
        if (this.totalConsecutiveErrors >= 10) {
            ODistributedServerLog.warn((Object)this, this.localNodeName, this.server, ODistributedServerLog.DIRECTION.OUT, "Reached %d consecutive errors on connection, remove the server '%s' from the cluster", this.totalConsecutiveErrors, this.server);
            try {
                this.check.nodeDisconnected(this.server);
            }
            catch (Exception e) {
                ODistributedServerLog.warn((Object)this, this.localNodeName, this.server, ODistributedServerLog.DIRECTION.OUT, "Error on removing server '%s' from the cluster", this.server);
            }
        }
    }

    public static interface OStorageRemoteOperation<T> {
        public T execute() throws IOException;
    }
}

