/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest;

import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;

public class ODatabaseUtils {
    public static void createDatabase(ODatabaseIdentifier databaseIdentifier) throws Exception {
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                new ODatabaseDocumentTx(databaseIdentifier.getUrl()).create();
                break;
            }
            case REMOTE: {
                new OServerAdmin(databaseIdentifier.getUrl()).connect("root", databaseIdentifier.getPassword()).createDatabase(databaseIdentifier.getName(), "document", "plocal");
            }
        }
    }

    public static ODatabase openDatabase(ODatabaseIdentifier databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY connectionStrategy) {
        ODatabaseDocumentTx database = null;
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                database = (ODatabaseDocument)new ODatabaseDocumentTx(databaseIdentifier.getUrl()).open("admin", "admin");
                break;
            }
            case REMOTE: {
                database = new ODatabaseDocumentTx(databaseIdentifier.getUrl());
                database.setProperty("connectionStrategy", (Object)connectionStrategy.toString());
                database.open("root", databaseIdentifier.getPassword());
            }
        }
        return database;
    }

    public static void dropDatabase(ODatabaseIdentifier databaseIdentifier) throws Exception {
        switch (databaseIdentifier.getMode()) {
            case PLOCAL: 
            case MEMORY: {
                ODatabaseUtils.openDatabase(databaseIdentifier, OStorageRemote.CONNECTION_STRATEGY.STICKY).drop();
                break;
            }
            case REMOTE: {
                new OServerAdmin(databaseIdentifier.getUrl()).connect("root", databaseIdentifier.getPassword()).dropDatabase(databaseIdentifier.getName(), "plocal");
            }
        }
    }
}

