/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.jcabi.log.Logger;
import com.qulice.maven.DefaultMavenEnvironment;
import com.qulice.maven.MavenEnvironment;
import com.qulice.maven.MojoExecutor;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractQuliceMojo
extends AbstractMojo
implements Contextualizable {
    private final DefaultMavenEnvironment environment = new DefaultMavenEnvironment();
    @Component
    private MavenProject project;
    @Component
    private MavenSession sess;
    @Component
    private MavenPluginManager manager;
    @Parameter(property="qulice.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="qulice.license", defaultValue="LICENSE.txt")
    private String license = "LICENSE.txt";
    @Parameter(property="qulice.excludes")
    private final Collection<String> excludes = new LinkedList<String>();
    @Parameter(property="qulice.asserts", required=false)
    private final Collection<String> asserts = new LinkedList<String>();

    public final void setProject(MavenProject proj) {
        this.project = proj;
    }

    public final void setSkip(boolean skp) {
        this.skip = skp;
    }

    public final void setAsserts(Collection<String> asser) {
        this.asserts.clear();
        this.asserts.addAll(asser);
    }

    public final void setLicense(String lcs) {
        this.license = lcs;
    }

    public final void setExcludes(Collection<String> exprs) {
        this.excludes.clear();
        this.excludes.addAll(exprs);
    }

    public final void contextualize(Context ctx) {
        this.environment.setContext(ctx);
    }

    public final void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution skipped");
            return;
        }
        this.environment.setProperty("license", this.license);
        this.environment.setProject(this.project);
        this.environment.setMojoExecutor(new MojoExecutor(this.manager, this.sess));
        this.environment.setExcludes(this.excludes);
        this.environment.setAsser(this.asserts);
        long start = System.nanoTime();
        this.doExecute();
        Logger.info((Object)((Object)this), (String)"Qulice quality check completed in %[nano]s", (Object[])new Object[]{System.nanoTime() - start});
    }

    public final MavenSession session() {
        return this.sess;
    }

    protected abstract void doExecute() throws MojoFailureException;

    protected final MavenEnvironment env() {
        return this.environment;
    }
}

