/*
 * Decompiled with CFR 0.152.
 */
package com.qulice.maven;

import com.jcabi.log.Logger;
import com.qulice.spi.ValidationException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.reporting.exec.DefaultMavenPluginManagerHelper;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class MojoExecutor {
    private final MavenPluginManager manager;
    private final MavenSession session;
    private final DefaultMavenPluginManagerHelper helper;

    public MojoExecutor(MavenPluginManager mngr, MavenSession sesn) {
        this.manager = mngr;
        this.session = sesn;
        this.helper = new DefaultMavenPluginManagerHelper(){
            {
                this.mavenPluginManager = MojoExecutor.this.manager;
            }
        };
    }

    public void execute(String coords, String goal, Properties config) throws ValidationException {
        Plugin plugin = new Plugin();
        String[] sectors = StringUtils.split((String)coords, (char)':');
        plugin.setGroupId(sectors[0]);
        plugin.setArtifactId(sectors[1]);
        plugin.setVersion(sectors[2]);
        MojoDescriptor descriptor = this.descriptor(plugin, goal);
        try {
            this.helper.setupPluginRealm(descriptor.getPluginDescriptor(), this.session, Thread.currentThread().getContextClassLoader(), new LinkedList(), new LinkedList());
        }
        catch (PluginResolutionException ex) {
            throw new IllegalStateException("Plugin resolution problem", ex);
        }
        catch (PluginContainerException ex) {
            throw new IllegalStateException("Can't setup realm", ex);
        }
        Xpp3Dom xpp = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)this.toXppDom(config, "configuration"), (Xpp3Dom)this.toXppDom(descriptor.getMojoConfiguration()));
        MojoExecution execution = new MojoExecution(descriptor, xpp);
        Mojo mojo = this.mojo(execution);
        try {
            Logger.info((Object)this, (String)"Calling %s:%s...", (Object[])new Object[]{coords, goal});
            mojo.execute();
        }
        catch (MojoExecutionException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (MojoFailureException ex) {
            throw new ValidationException((Throwable)ex);
        }
        finally {
            this.manager.releaseMojo((Object)mojo, execution);
        }
    }

    private MojoDescriptor descriptor(Plugin plugin, String goal) {
        try {
            return this.helper.getPluginDescriptor(plugin, this.session.getCurrentProject().getRemotePluginRepositories(), this.session).getMojo(goal);
        }
        catch (PluginResolutionException ex) {
            throw new IllegalStateException("Can't resolve plugin", ex);
        }
        catch (PluginDescriptorParsingException ex) {
            throw new IllegalStateException("Can't parse descriptor", ex);
        }
        catch (InvalidPluginDescriptorException ex) {
            throw new IllegalStateException("Invalid plugin descriptor", ex);
        }
    }

    private Mojo mojo(MojoExecution execution) {
        Mojo mojo;
        try {
            mojo = (Mojo)this.manager.getConfiguredMojo(Mojo.class, this.session, execution);
        }
        catch (PluginConfigurationException ex) {
            throw new IllegalStateException("Can't configure MOJO", ex);
        }
        catch (PluginContainerException ex) {
            throw new IllegalStateException("Plugin container failure", ex);
        }
        return mojo;
    }

    private Xpp3Dom toXppDom(Properties config, String name) {
        Xpp3Dom xpp = new Xpp3Dom(name);
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            Xpp3Dom child;
            if (entry.getValue() instanceof String) {
                child = new Xpp3Dom(entry.getKey().toString());
                child.setValue(config.getProperty(entry.getKey().toString()));
                xpp.addChild(child);
                continue;
            }
            if (entry.getValue() instanceof String[]) {
                child = new Xpp3Dom(entry.getKey().toString());
                for (String val : (String[])String[].class.cast(entry.getValue())) {
                    Xpp3Dom row = new Xpp3Dom(entry.getKey().toString());
                    row.setValue(val);
                    child.addChild(row);
                }
                xpp.addChild(child);
                continue;
            }
            if (entry.getValue() instanceof Collection) {
                child = new Xpp3Dom(entry.getKey().toString());
                for (Object val : (Collection)Collection.class.cast(entry.getValue())) {
                    Xpp3Dom row = new Xpp3Dom(entry.getKey().toString());
                    if (val == null) continue;
                    row.setValue(val.toString());
                    child.addChild(row);
                }
                xpp.addChild(child);
                continue;
            }
            if (entry.getValue() instanceof Properties) {
                xpp.addChild(this.toXppDom((Properties)Properties.class.cast(entry.getValue()), entry.getKey().toString()));
                continue;
            }
            throw new IllegalArgumentException(String.format("Invalid properties value at '%s'", entry.getKey().toString()));
        }
        return xpp;
    }

    private Xpp3Dom toXppDom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            try {
                result.setAttribute(string, config.getAttribute(string));
            }
            catch (PlexusConfigurationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXppDom((PlexusConfiguration)string));
        }
        return result;
    }
}

