/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.OutputFactory;
import com.redis.lettucemod.timeseries.GetResult;
import com.redis.lettucemod.timeseries.Sample;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GetOutput<K, V>
extends CommandOutput<K, V, List<GetResult<K, V>>>
implements StreamingOutput<GetResult<K, V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<GetResult<K, V>> subscriber;
    private boolean skipKeyReset = false;
    private K key;
    private K labelKey;
    private Map<K, V> labels;
    private Sample sample;
    private boolean labelsReceived = false;
    private boolean labelsComplete = false;

    public GetOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<GetResult<K, V>>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            if (bytes == null) {
                return;
            }
            this.key = this.codec.decodeKey(bytes);
            this.skipKeyReset = true;
            return;
        }
        if (this.labelsComplete) {
            this.sampleValue(bytes == null ? null : Double.valueOf(LettuceStrings.toDouble((String)this.decodeAscii(bytes))));
            return;
        }
        if (this.labelKey == null) {
            this.labelsReceived = true;
            if (bytes == null) {
                return;
            }
            this.labelKey = this.codec.decodeKey(bytes);
            return;
        }
        if (this.labels == null) {
            this.labels = new LinkedHashMap();
        }
        this.labels.put(this.labelKey, bytes == null ? null : this.codec.decodeValue(bytes));
        this.labelKey = null;
    }

    public void set(long integer) {
        this.sample = new Sample();
        this.sample.setTimestamp(integer);
    }

    public void set(double number) {
        this.sampleValue(number);
    }

    private void sampleValue(Double value) {
        this.sample.setValue(value);
        GetResult result = new GetResult();
        result.setKey(this.key);
        result.setLabels(this.labels == null ? Collections.emptyMap() : this.labels);
        result.setSample(this.sample);
        this.subscriber.onNext((Collection)this.output, result);
        this.labelsReceived = false;
        this.labelsComplete = false;
        this.labelKey = null;
        this.labels = null;
        this.sample = null;
    }

    public void multi(int count) {
        if (this.key != null && this.labelKey == null && count == -1) {
            this.labelsReceived = true;
        }
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    public void complete(int depth) {
        if (depth == 2 && this.labelsReceived) {
            this.labelsComplete = true;
            return;
        }
        if (depth == 2 && this.skipKeyReset) {
            this.skipKeyReset = false;
        }
        if (depth == 1) {
            if (this.skipKeyReset) {
                this.skipKeyReset = false;
            } else {
                this.key = null;
            }
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<GetResult<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, (String)"Subscriber must not be null");
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<GetResult<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

