/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.output.OutputFactory;
import com.redis.lettucemod.timeseries.RangeResult;
import com.redis.lettucemod.timeseries.Sample;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RangeOutput<K, V>
extends CommandOutput<K, V, List<RangeResult<K, V>>>
implements StreamingOutput<RangeResult<K, V>> {
    private StreamingOutput.Subscriber<RangeResult<K, V>> subscriber;
    private K key;
    private K labelKey;
    private Map<K, V> labels;
    private long timestamp;
    private List<Sample> samples;
    private boolean initialized;
    private boolean skipKeyReset;
    private boolean keyComplete;
    private boolean labelsComplete;

    public RangeOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<RangeResult<K, V>>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            if (bytes == null) {
                return;
            }
            this.key = this.codec.decodeKey(bytes);
            this.skipKeyReset = true;
            return;
        }
        if (this.labelsComplete) {
            this.sampleValue(bytes == null ? null : Double.valueOf(LettuceStrings.toDouble((String)this.decodeAscii(bytes))));
            return;
        }
        if (this.labelKey == null) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap();
            }
            if (bytes == null) {
                return;
            }
            this.labelKey = this.codec.decodeKey(bytes);
            return;
        }
        this.labels.put(this.labelKey, bytes == null ? null : this.codec.decodeValue(bytes));
        this.labelKey = null;
    }

    public void set(long integer) {
        this.timestamp = integer;
    }

    public void set(double number) {
        this.sampleValue(number);
    }

    private void sampleValue(Double value) {
        if (this.samples == null) {
            this.samples = new ArrayList<Sample>();
        }
        if (value != null) {
            this.samples.add(new Sample(this.timestamp, value));
        }
        this.timestamp = 0L;
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
    }

    public void complete(int depth) {
        if (depth == 2) {
            if (this.keyComplete) {
                if (this.labelsComplete) {
                    this.labelsComplete();
                } else {
                    this.labelsComplete = true;
                }
            } else {
                this.keyComplete = true;
            }
        } else if (depth == 1) {
            if (this.skipKeyReset) {
                this.skipKeyReset = false;
            } else {
                this.key = null;
            }
        }
    }

    private void labelsComplete() {
        RangeResult result = new RangeResult();
        result.setKey(this.key);
        result.setLabels(this.labels == null ? Collections.emptyMap() : this.labels);
        result.setSamples(this.samples == null ? Collections.emptyList() : this.samples);
        this.subscriber.onNext((Collection)this.output, result);
        this.labelsComplete = false;
        this.labelKey = null;
        this.labels = null;
        this.samples = null;
        if (this.skipKeyReset) {
            this.skipKeyReset = false;
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<RangeResult<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, (String)"Subscriber must not be null");
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<RangeResult<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

