/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.RedisModulesCommandBuilder;
import com.redis.lettucemod.output.AggregateOutput;
import com.redis.lettucemod.output.AggregateWithCursorOutput;
import com.redis.lettucemod.output.SearchNoContentOutput;
import com.redis.lettucemod.output.SearchOutput;
import com.redis.lettucemod.output.SuggetOutput;
import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.protocol.SearchCommandType;
import com.redis.lettucemod.search.AggregateOptions;
import com.redis.lettucemod.search.AggregateResults;
import com.redis.lettucemod.search.AggregateWithCursorResults;
import com.redis.lettucemod.search.CreateOptions;
import com.redis.lettucemod.search.Cursor;
import com.redis.lettucemod.search.Field;
import com.redis.lettucemod.search.SearchOptions;
import com.redis.lettucemod.search.SearchResults;
import com.redis.lettucemod.search.Suggestion;
import com.redis.lettucemod.search.SuggetOptions;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;

public class RediSearchCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public RediSearchCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(SearchCommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    private static void notNullIndex(Object index) {
        RediSearchCommandBuilder.notNull(index, "Index");
    }

    public Command<K, V, String> create(K index, CreateOptions<K, V> options, Field ... fields) {
        RediSearchCommandBuilder.notNullIndex(index);
        LettuceAssert.isTrue((fields.length > 0 ? 1 : 0) != 0, (String)"At least one field is required.");
        CommandArgs args = this.args((Object)index);
        if (options != null) {
            options.build((SearchCommandArgs<K, V>)args);
        }
        args.add((ProtocolKeyword)SearchCommandKeyword.SCHEMA);
        for (Field field : fields) {
            field.build((SearchCommandArgs)args);
        }
        return this.createCommand(SearchCommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> dropIndex(K index, boolean deleteDocs) {
        RediSearchCommandBuilder.notNullIndex(index);
        CommandArgs args = this.args((Object)index);
        if (deleteDocs) {
            args.add((ProtocolKeyword)SearchCommandKeyword.DD);
        }
        return this.createCommand(SearchCommandType.DROPINDEX, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Object>> info(K index) {
        RediSearchCommandBuilder.notNullIndex(index);
        CommandArgs args = this.args((Object)index);
        return this.createCommand(SearchCommandType.INFO, (CommandOutput)new NestedMultiOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> alter(K index, Field field) {
        RediSearchCommandBuilder.notNullIndex(index);
        RediSearchCommandBuilder.notNull(field, "Field");
        CommandArgs args = this.args((Object)index);
        args.add((ProtocolKeyword)SearchCommandKeyword.SCHEMA);
        args.add((ProtocolKeyword)SearchCommandKeyword.ADD);
        field.build((SearchCommandArgs)args);
        return this.createCommand(SearchCommandType.ALTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    @Override
    protected SearchCommandArgs<K, V> args(K key) {
        return new SearchCommandArgs(this.codec).addKey((Object)key);
    }

    private static void notNullQuery(Object query) {
        RediSearchCommandBuilder.notNull(query, "Query");
    }

    public Command<K, V, SearchResults<K, V>> search(K index, V query, SearchOptions<K, V> options) {
        RediSearchCommandBuilder.notNullIndex(index);
        RediSearchCommandBuilder.notNullQuery(query);
        CommandArgs args = this.args((Object)index);
        args.addValue((Object)query);
        if (options != null) {
            options.build((SearchCommandArgs<K, V>)args);
        }
        return this.createCommand(SearchCommandType.SEARCH, this.searchOutput(options), args);
    }

    private CommandOutput<K, V, SearchResults<K, V>> searchOutput(SearchOptions<K, V> options) {
        if (options == null) {
            return new SearchOutput(this.codec);
        }
        if (options.isNoContent()) {
            return new SearchNoContentOutput(this.codec, options.isWithScores());
        }
        return new SearchOutput(this.codec, options.isWithScores(), options.isWithSortKeys(), options.isWithPayloads());
    }

    public Command<K, V, AggregateResults<K>> aggregate(K index, V query, AggregateOptions<K, V> options) {
        RediSearchCommandBuilder.notNullIndex(index);
        RediSearchCommandBuilder.notNullQuery(query);
        CommandArgs args = this.args((Object)index);
        args.addValue((Object)query);
        if (options != null) {
            options.build((SearchCommandArgs<K, V>)args);
        }
        return this.createCommand(SearchCommandType.AGGREGATE, new AggregateOutput(this.codec, new AggregateResults()), args);
    }

    public Command<K, V, AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor, AggregateOptions<K, V> options) {
        RediSearchCommandBuilder.notNullIndex(index);
        RediSearchCommandBuilder.notNullQuery(query);
        CommandArgs args = this.args((Object)index);
        args.addValue((Object)query);
        if (options != null) {
            options.build((SearchCommandArgs<K, V>)args);
        }
        args.add((ProtocolKeyword)SearchCommandKeyword.WITHCURSOR);
        if (cursor != null) {
            cursor.build(args);
        }
        return this.createCommand(SearchCommandType.AGGREGATE, new AggregateWithCursorOutput(this.codec), args);
    }

    public Command<K, V, AggregateWithCursorResults<K>> cursorRead(K index, long cursor, Long count) {
        RediSearchCommandBuilder.notNullIndex(index);
        SearchCommandArgs args = new SearchCommandArgs(this.codec);
        args.add(SearchCommandKeyword.READ);
        args.addKey((Object)index);
        args.add(cursor);
        if (count != null) {
            args.add(SearchCommandKeyword.COUNT);
            args.add(count);
        }
        return this.createCommand(SearchCommandType.CURSOR, new AggregateWithCursorOutput(this.codec), args);
    }

    public Command<K, V, String> cursorDelete(K index, long cursor) {
        RediSearchCommandBuilder.notNullIndex(index);
        SearchCommandArgs args = new SearchCommandArgs(this.codec);
        args.add(SearchCommandKeyword.DEL);
        args.addKey((Object)index);
        args.add(cursor);
        return this.createCommand(SearchCommandType.CURSOR, (CommandOutput)new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<V>> tagVals(K index, K field) {
        RediSearchCommandBuilder.notNullIndex(index);
        CommandArgs args = this.args((Object)index);
        args.addKey((Object)field);
        return this.createCommand(SearchCommandType.TAGVALS, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    private static void notNullDict(Object dict) {
        RediSearchCommandBuilder.notNull(dict, "Dict");
    }

    public Command<K, V, Long> dictadd(K dict, V ... terms) {
        RediSearchCommandBuilder.notNullDict(dict);
        return this.createCommand(SearchCommandType.DICTADD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)this.args((Object)dict).addValues((Object[])terms));
    }

    public Command<K, V, Long> dictdel(K dict, V ... terms) {
        RediSearchCommandBuilder.notNullDict(dict);
        return this.createCommand(SearchCommandType.DICTDEL, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)this.args((Object)dict).addValues((Object[])terms));
    }

    public Command<K, V, List<V>> dictdump(K dict) {
        RediSearchCommandBuilder.notNullDict(dict);
        return this.createCommand(SearchCommandType.DICTDUMP, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)this.args((Object)dict));
    }

    public Command<K, V, Long> sugadd(K key, V string, double score) {
        return this.sugadd(key, string, score, null, false);
    }

    public Command<K, V, Long> sugaddIncr(K key, V string, double score) {
        return this.sugadd(key, string, score, null, true);
    }

    public Command<K, V, Long> sugadd(K key, V string, double score, V payload) {
        return this.sugadd(key, string, score, payload, false);
    }

    public Command<K, V, Long> sugaddIncr(K key, V string, double score, V payload) {
        return this.sugadd(key, string, score, payload, true);
    }

    public Command<K, V, Long> sugadd(K key, V string, double score, V payload, boolean increment) {
        RediSearchCommandBuilder.notNullKey(key);
        RediSearchCommandBuilder.notNull(string, "String");
        CommandArgs args = this.args((Object)key);
        args.addValue((Object)string);
        args.add(score);
        if (increment) {
            args.add((ProtocolKeyword)SearchCommandKeyword.INCR);
        }
        if (payload != null) {
            args.add((ProtocolKeyword)SearchCommandKeyword.PAYLOAD);
            args.addValue((Object)payload);
        }
        return this.createCommand(SearchCommandType.SUGADD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> sugadd(K key, Suggestion<V> suggestion) {
        RediSearchCommandBuilder.notNull(suggestion, "Suggestion");
        return this.sugadd(key, suggestion.getString(), suggestion.getScore(), suggestion.getPayload(), false);
    }

    public Command<K, V, Long> sugaddIncr(K key, Suggestion<V> suggestion) {
        RediSearchCommandBuilder.notNull(suggestion, "Suggestion");
        return this.sugadd(key, suggestion.getString(), suggestion.getScore(), suggestion.getPayload(), true);
    }

    public Command<K, V, List<Suggestion<V>>> sugget(K key, V prefix) {
        return this.sugget(key, prefix, null);
    }

    public Command<K, V, List<Suggestion<V>>> sugget(K key, V prefix, SuggetOptions options) {
        RediSearchCommandBuilder.notNullKey(key);
        RediSearchCommandBuilder.notNull(prefix, "Prefix");
        CommandArgs args = this.args((Object)key);
        args.addValue((Object)prefix);
        if (options != null) {
            options.build((SearchCommandArgs)args);
        }
        return this.createCommand(SearchCommandType.SUGGET, this.suggetOutput(options), args);
    }

    private SuggetOutput<K, V> suggetOutput(SuggetOptions options) {
        if (options == null) {
            return new SuggetOutput(this.codec);
        }
        return new SuggetOutput(this.codec, options.isWithScores(), options.isWithPayloads());
    }

    public Command<K, V, Boolean> sugdel(K key, V string) {
        RediSearchCommandBuilder.notNullKey(key);
        RediSearchCommandBuilder.notNull(string, "String");
        return this.createCommand(SearchCommandType.SUGDEL, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)this.args((Object)key).addValue((Object)string));
    }

    public Command<K, V, Long> suglen(K key) {
        RediSearchCommandBuilder.notNullKey(key);
        return this.createCommand(SearchCommandType.SUGLEN, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)this.args((Object)key));
    }

    private static void notNullName(Object name) {
        RediSearchCommandBuilder.notNull(name, "Name");
    }

    public Command<K, V, String> aliasAdd(K name, K index) {
        RediSearchCommandBuilder.notNullName(name);
        RediSearchCommandBuilder.notNullIndex(index);
        return this.createCommand(SearchCommandType.ALIASADD, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)this.args((Object)name).addKey((Object)index));
    }

    public Command<K, V, String> aliasUpdate(K name, K index) {
        RediSearchCommandBuilder.notNullName(name);
        RediSearchCommandBuilder.notNullIndex(index);
        return this.createCommand(SearchCommandType.ALIASUPDATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)this.args((Object)name).addKey((Object)index));
    }

    public Command<K, V, String> aliasDel(K name) {
        RediSearchCommandBuilder.notNullName(name);
        return this.createCommand(SearchCommandType.ALIASDEL, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)this.args((Object)name));
    }

    public Command<K, V, List<K>> list() {
        return new Command((ProtocolKeyword)SearchCommandType._LIST, (CommandOutput)new KeyListOutput(this.codec));
    }
}

