/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import com.redis.lettucemod.protocol.SearchCommandArgs;
import com.redis.lettucemod.protocol.SearchCommandKeyword;
import com.redis.lettucemod.search.Order;
import com.redis.lettucemod.search.PropertyReducer;
import com.redis.lettucemod.search.Reducer;

public class Reducers {
    private Reducers() {
    }

    public static class Quantile
    extends PropertyReducer {
        private final double quantileValue;

        public Quantile(String as, String property, double quantile) {
            super(as, property);
            this.quantileValue = quantile;
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.QUANTILE);
            args.add(2L);
            args.addProperty(this.property);
            args.add(this.quantileValue);
        }

        public static QuantileBuilder property(String property) {
            return new QuantileBuilder(property);
        }

        public static class Builder
        extends PropertyReducer.PropertyReducerBuilder<Builder> {
            private final double quantile;

            protected Builder(String property, double quantile) {
                super(property);
                this.quantile = quantile;
            }

            public Quantile build() {
                return new Quantile(this.as, this.property, this.quantile);
            }
        }

        public static class QuantileBuilder {
            private final String property;

            public QuantileBuilder(String property) {
                this.property = property;
            }

            public Builder quantile(double quantile) {
                return new Builder(this.property, quantile);
            }
        }
    }

    public static class CountDistinct
    extends PropertyReducer {
        public CountDistinct(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.COUNT_DISTINCT);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static CountDistinctBuilder property(String property) {
            return new CountDistinctBuilder(property);
        }

        public static class CountDistinctBuilder
        extends PropertyReducer.PropertyReducerBuilder<CountDistinctBuilder> {
            public CountDistinctBuilder(String property) {
                super(property);
            }

            public CountDistinct build() {
                return new CountDistinct(this.as, this.property);
            }
        }
    }

    public static class CountDistinctish
    extends PropertyReducer {
        private CountDistinctish(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.COUNT_DISTINCTISH);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static CountDistinctishBuilder property(String property) {
            return new CountDistinctishBuilder(property);
        }

        public static class CountDistinctishBuilder
        extends PropertyReducer.PropertyReducerBuilder<CountDistinctishBuilder> {
            public CountDistinctishBuilder(String property) {
                super(property);
            }

            public CountDistinctish build() {
                return new CountDistinctish(this.as, this.property);
            }
        }
    }

    public static class StdDev
    extends PropertyReducer {
        public StdDev(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.STDDEV);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static StdDevBuilder property(String property) {
            return new StdDevBuilder(property);
        }

        public static class StdDevBuilder
        extends PropertyReducer.PropertyReducerBuilder<StdDevBuilder> {
            public StdDevBuilder(String property) {
                super(property);
            }

            public StdDev build() {
                return new StdDev(this.as, this.property);
            }
        }
    }

    public static class Sum
    extends PropertyReducer {
        public Sum(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.SUM);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static SumBuilder property(String property) {
            return new SumBuilder(property);
        }

        public static class SumBuilder
        extends PropertyReducer.PropertyReducerBuilder<SumBuilder> {
            public SumBuilder(String property) {
                super(property);
            }

            public Sum build() {
                return new Sum(this.as, this.property);
            }
        }
    }

    public static class ToList
    extends PropertyReducer {
        public ToList(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.TOLIST);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static ToListBuilder property(String property) {
            return new ToListBuilder(property);
        }

        public static class ToListBuilder
        extends PropertyReducer.PropertyReducerBuilder<ToListBuilder> {
            public ToListBuilder(String property) {
                super(property);
            }

            public ToList build() {
                return new ToList(this.as, this.property);
            }
        }
    }

    public static class Avg
    extends PropertyReducer {
        public Avg(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.AVG);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static AvgBuilder property(String property) {
            return new AvgBuilder(property);
        }

        public static class AvgBuilder
        extends PropertyReducer.PropertyReducerBuilder<AvgBuilder> {
            public AvgBuilder(String property) {
                super(property);
            }

            public Avg build() {
                return new Avg(this.as, this.property);
            }
        }
    }

    public static class RandomSample
    extends PropertyReducer {
        private final int size;

        public RandomSample(String as, String property, int size) {
            super(as, property);
            this.size = size;
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.RANDOM_SAMPLE);
            args.add(2L);
            args.addProperty(this.property);
            args.add(this.size);
        }

        public static SizeBuilder property(String property) {
            return new SizeBuilder(property);
        }

        public static class Builder
        extends PropertyReducer.PropertyReducerBuilder<Builder> {
            private final int size;

            public Builder(String property, int size) {
                super(property);
                this.size = size;
            }

            public RandomSample build() {
                return new RandomSample(this.as, this.property, this.size);
            }
        }

        public static class SizeBuilder {
            private final String property;

            public SizeBuilder(String property) {
                this.property = property;
            }

            public Builder size(int size) {
                return new Builder(this.property, size);
            }
        }
    }

    public static class Min
    extends PropertyReducer {
        public Min(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.MIN);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static MinBuilder property(String property) {
            return new MinBuilder(property);
        }

        public static class MinBuilder
        extends PropertyReducer.PropertyReducerBuilder<MinBuilder> {
            public MinBuilder(String property) {
                super(property);
            }

            public Min build() {
                return new Min(this.as, this.property);
            }
        }
    }

    public static class Count
    extends Reducer {
        public Count(String as) {
            super(as);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.COUNT);
            args.add(0L);
        }

        public static Count create() {
            return new Count(null);
        }

        public static Count as(String as) {
            return new Count(as);
        }
    }

    public static class FirstValue
    extends PropertyReducer {
        private final By by;

        public FirstValue(String as, String property, By by) {
            super(as, property);
            this.by = by;
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.FIRST_VALUE);
            args.add(this.getNumberOfArgs());
            args.addProperty(this.property);
            if (this.by != null) {
                args.add(SearchCommandKeyword.BY);
                args.addProperty(this.property);
                if (this.by.getOrder() != null) {
                    args.add(this.by.getOrder() == Order.ASC ? SearchCommandKeyword.ASC : SearchCommandKeyword.DESC);
                }
            }
        }

        private int getNumberOfArgs() {
            int nargs = 1;
            if (this.by != null) {
                nargs += this.by.getOrder() == null ? 2 : 3;
            }
            return nargs;
        }

        public static FirstValueBuilder property(String property) {
            return new FirstValueBuilder(property);
        }

        public static class By {
            private String property;
            private Order order;

            public By(String property, Order order) {
                this.property = property;
                this.order = order;
            }

            public String getProperty() {
                return this.property;
            }

            public void setProperty(String property) {
                this.property = property;
            }

            public Order getOrder() {
                return this.order;
            }

            public void setOrder(Order order) {
                this.order = order;
            }

            public static ByBuilder property(String property) {
                return new ByBuilder(property);
            }

            public static class ByBuilder {
                private final String property;
                private Order order;

                public ByBuilder(String property) {
                    this.property = property;
                }

                public ByBuilder order(Order order) {
                    this.order = order;
                    return this;
                }

                public By build() {
                    return new By(this.property, this.order);
                }
            }
        }

        public static class FirstValueBuilder
        extends PropertyReducer.PropertyReducerBuilder<FirstValueBuilder> {
            private By by;

            protected FirstValueBuilder(String property) {
                super(property);
            }

            public FirstValueBuilder by(By by) {
                this.by = by;
                return this;
            }

            public FirstValue build() {
                return new FirstValue(this.as, this.property, this.by);
            }
        }
    }

    public static class Max
    extends PropertyReducer {
        public Max(String as, String property) {
            super(as, property);
        }

        @Override
        protected void buildFunction(SearchCommandArgs args) {
            args.add(SearchCommandKeyword.MAX);
            args.add(1L);
            args.addProperty(this.property);
        }

        public static MaxBuilder property(String property) {
            return new MaxBuilder(property);
        }

        public static class MaxBuilder
        extends PropertyReducer.PropertyReducerBuilder<MaxBuilder> {
            public MaxBuilder(String property) {
                super(property);
            }

            public Max build() {
                return new Max(this.as, this.property);
            }
        }
    }
}

